/******************************************************************************
 *
 *  <:copyright-BRCM:2016:DUAL/GPL:standard
 *
 *     Copyright (c) 2016 Broadcom
 *     All Rights Reserved
 *
 *  Unless you and Broadcom execute a separate written software license
 *  agreement governing use of this software, this software is licensed
 *  to you under the terms of the GNU General Public License version 2
 *  (the "GPL"), available at http://www.broadcom.com/licenses/GPLv2.php,
 *  with the following added to such license:
 *
 *     As a special exception, the copyright holders of this software give
 *     you permission to link this software with independent modules, and
 *     to copy and distribute the resulting executable under terms of your
 *     choice, provided that you also meet, for each linked independent
 *     module, the terms and conditions of the license of that module.
 *     An independent module is a module which is not derived from this
 *     software.  The special exception does not apply to any modifications
 *     of the software.
 *
 *  Not withstanding the above, under no circumstances may you combine
 *  this software in any way with any other Broadcom software provided
 *  under a license other than the GPL, without Broadcom's express prior
 *  written consent.
 *
 *  :>
 *
 *****************************************************************************/

/**
 * @file bal_mac_util_epon.h
 *
 * @brief mac util interfaces definition used by Bal Core, for EPON
 *
 * This file expose the APIs to the core to configure the mac
 * with regarding to the operation of access terminal, interface, subscriber terminal and flow.
 *
 * @addtogroup mac_util
 */

/*@{*/

#include <bal_mac_util.h>

/* Temporarily exclude some code to get this module compiling again - we should get rid of this ASAP */
#define BAL_EPON_EXCLUDE 0

#if BAL_EPON_EXCLUDE
bcmos_errno mac_util_handle_all_olt_ind_for_epon (bcmolt_devid device_id, bcmolt_msg *p_msg);

bcmos_errno mac_util_register_for_epon_auto_indications(struct bcmolt_rx_cfg *p_rx_cfg, bcmolt_devid device_id);
#endif /* BAL_EPON_EXCLUDE */

bcmos_errno mac_util_access_terminal_set_for_epon_8_tdma(
    acc_term_inst *p_acc_term,
    bal_util_oper_acc_term op_type,
    bcmolt_devid device_id);

bcmos_errno mac_util_access_terminal_set_for_epon_4_tdma(
    acc_term_inst *p_acc_term,
    bal_util_oper_acc_term op_type,
    bcmolt_devid device_id);

bcmos_errno mac_util_access_terminal_set_for_epon_16_1g(
    acc_term_inst *p_acc_term,
    bal_util_oper_acc_term op_type,
    bcmolt_devid device_id);

bcmos_errno mac_util_access_terminal_set_for_epon_8_1g(
    acc_term_inst *p_acc_term,
    bal_util_oper_acc_term op_type,
    bcmolt_devid device_id);

bcmos_errno mac_util_access_terminal_set_for_epon_4_1g(
    acc_term_inst *p_acc_term,
    bal_util_oper_acc_term op_type,
    bcmolt_devid device_id);

bcmos_errno mac_util_access_terminal_set_for_epon_8_10g(
    acc_term_inst *p_acc_term,
    bal_util_oper_acc_term op_type,
    bcmolt_devid device_id);

bcmos_errno mac_util_access_terminal_set_for_epon_4_10g(
    acc_term_inst *p_acc_term,
    bal_util_oper_acc_term op_type,
    bcmolt_devid device_id);

bcmos_errno mac_util_access_terminal_set_for_epon_2_10g(
    acc_term_inst *p_acc_term,
    bal_util_oper_acc_term op_type,
    bcmolt_devid device_id);

bcmos_errno mac_util_interface_set_for_epon(acc_term_interface *p_interface_inst, bal_util_oper_if op_type);

#if BAL_EPON_EXCLUDE
bcmos_errno mac_util_validate_subscriber_terminal_info_for_epon(const bcmbal_subscriber_terminal_cfg *p_sub_term_req);

bcmos_errno mac_util_subscriber_terminal_set_for_epon(sub_term_inst *p_sub_term_inst, bal_util_oper_sub_term op_type, bcmos_bool is_post_discovery);

bcmos_errno mac_util_flow_set_for_epon (bcmbal_flow_cfg *p_flow_req, bal_util_oper_flow op_type, flow_inst *p_flow_core);

void bal_proxy_rx_cb_for_epon (bcmolt_devid device_id, bcmolt_msg *p_msg);
#endif /* BAL_EPON_EXCLUDE */

/*@}*/

