/******************************************************************************
 *
 *  <:copyright-BRCM:2016:DUAL/GPL:standard
 *
 *     Copyright (c) 2016 Broadcom
 *     All Rights Reserved
 *
 *  Unless you and Broadcom execute a separate written software license
 *  agreement governing use of this software, this software is licensed
 *  to you under the terms of the GNU General Public License version 2
 *  (the "GPL"), available at http://www.broadcom.com/licenses/GPLv2.php,
 *  with the following added to such license:
 *
 *     As a special exception, the copyright holders of this software give
 *     you permission to link this software with independent modules, and
 *     to copy and distribute the resulting executable under terms of your
 *     choice, provided that you also meet, for each linked independent
 *     module, the terms and conditions of the license of that module.
 *     An independent module is a module which is not derived from this
 *     software.  The special exception does not apply to any modifications
 *     of the software.
 *
 *  Not withstanding the above, under no circumstances may you combine
 *  this software in any way with any other Broadcom software provided
 *  under a license other than the GPL, without Broadcom's express prior
 *  written consent.
 *
 *  :>
 *
 *****************************************************************************/

/**
 * @file bal_mac_util.h
 *
 * @brief Mac util interfaces header file
 *
 * This file expose the APIs to the core to configure the mac
 * with regarding to the operation of access terminal, interface, subscriber terminal and flow.
 *
 * @defgroup mac_util Mac Util
 * @ingroup core
 */

#ifndef BAL_MAC_UTIL_H
#define BAL_MAC_UTIL_H

/****************************************/

#include <bcmolt_host_api.h>
#include <acc_term_fsm.h>
#include <sub_term_fsm.h>
#include <flow_fsm.h>
#include <group_fsm.h>
#include <tm_sched_fsm.h>
#include <bal_utils_msg.h>

#include <bal_common.h>
#include <bal_mac_util.h>
#include <rsc_mgr.h>
#include <bal_app_common_utils.h>
#include <bal_utils.h>
#include <bal_worker.h>
#include <bal_msg.h>
#include <bcm_topo.h>

#ifdef ENABLE_LOG
#include <bcm_dev_log.h>
#include <bcmtr_debug_cli.h>
#endif //ENABLE_LOG


/*@{*/

/** @brief none fail reason for sub term deactivation. Defined locally, since Maple SDK does not define this. */
#define MAC_UTIL_DEACTIVATION_FAIL_REASON_NONE                      BCMOLT_ACTIVATION_FAIL_REASON_NONE

/**
 * @brief The following macros define the max and min user flow Id values and the check for a valid flow Id.
 */
extern uint32_t mac_util_flow_id_start_val;
#define MAC_UTIL_FLOW_DB_FLOW_ID_START_VAL                          (mac_util_flow_id_start_val)
#define MAC_UTIL_FLOW_DB_FLOW_ID_MAX_VAL                            (MAC_UTIL_FLOW_DB_FLOW_ID_START_VAL+BAL_ACC_TERM_MAX_FLOWS-1)

#define MAC_UTIL_FLOW_DB_FLOW_ID_START_VAL_CONFIG(_start_val)       (mac_util_flow_id_start_val = (_start_val))

#define MAC_UTIL_FLOW_DB_FLOW_ID_IS_VALID(_flow_id)                 \
        (((_flow_id) >= MAC_UTIL_FLOW_DB_FLOW_ID_START_VAL) &&      \
              ((_flow_id) <= MAC_UTIL_FLOW_DB_FLOW_ID_MAX_VAL))

typedef struct mac_util_sla mac_util_sla;
struct mac_util_sla
{
    uint64_t min_rate; /* min_rate (this is a uint64_t as the units are bytes per second) */
    uint64_t max_rate; /* max_rate (this is a uint64_t as the units are bytes per second) */
};

/* flow entry structure */
typedef struct flow_list_entry flow_list_entry;
struct flow_list_entry
{
    TAILQ_ENTRY(flow_list_entry) next;
    bcmbal_flow_key bal_flow_key;           /* bal flow key */
    uint32_t if_id;                         /* pon_ni id */
    uint32_t sub_term_id;                   /* onu_id */
    uint16_t svc_port_id;                   /* the flow related gem port id */
    uint16_t agg_id;                        /* the flow related alloc-id */
    uint16_t vlan_id;
    bcmos_bool is_waiting_for_svc_port_active; /* indicates whether waiting for a gem port to become active */
    bcmos_bool is_configuration_completed;
    bal_util_flow_ind  ind_sent;    /* indicates whether an indication was sent to core none/success/fail */
    mac_util_sla sla;               /* it saves a converted value for the SLAs; we may retain this in mac util */
    bal_util_oper_flow  op_type;    /* Operation type: FLOW_ADD or FLOW_REMOVE */
};

#define RSRC_MGR_KEEPS_FLOW_LIST_PER_GEM    BCMOS_FALSE

extern dev_log_id   log_id_mac_util;
extern dev_log_id   log_id_mac_util_pon_if[];
/** @def get log Id for pon interface */
#define MAC_UTIL_GET_LOG_ID_FOR_PON_IF(_pon_if_id)   (log_id_mac_util_pon_if[(_pon_if_id)])


/** @def system default transceiver type */
#define BCMBAL_MAC_UTIL_TRX_TYPE_DEFAULT_GPON BCMBAL_TRX_TYPE_GPON_LTE_3680_M
#define BCMBAL_MAC_UTIL_TRX_TYPE_DEFAULT_XGPON BCMBAL_TRX_TYPE_XGPON_LTH_7222_PC
#define BCMBAL_MAC_UTIL_TRX_TYPE_DEFAULT_XGS BCMBAL_TRX_TYPE_XGPON_LTH_5302_PC


/**
 * @brief is valid pon interface id
 * @todo see if it is feasible to tie it up with system mode. However
 * keep in mind that this check would be called for every db api call.
 */
#define IS_VALID_PON_IF(_pon_if)   (NUM_SUPPORTED_SUBSCRIBER_INTERFACES > (_pon_if))


/* Function Prototypes for external */
bcmos_errno mac_util_access_terminal_sw_version_validate(bcmolt_devid device);
bcmos_errno mac_util_access_terminal_set(acc_term_inst *p_acc_term, bal_util_oper_acc_term op_type);
bcmos_errno mac_util_access_terminal_info_validate(const bcmbal_access_terminal_cfg *p_acc_term_req);

bcmos_errno mac_util_subscriber_terminal_set(sub_term_inst *p_sub_term, bal_util_oper_sub_term op_type, bcmos_bool is_post_discovery);
bcmos_errno mac_util_subscriber_terminal_info_validate(const bcmbal_subscriber_terminal_cfg *p_sub_term_req);

bcmos_errno mac_util_interface_set(acc_term_interface *p_interface_inst, bal_util_oper_if op_type);

bcmos_errno mac_util_flow_set(flow_inst *p_flow_core, bal_util_oper_flow op_type);
bcmos_errno mac_util_flow_info_validate(const bcmbal_flow_cfg *p_flow_req);

bcmos_errno mac_util_group_set(group_inst *p_flow, bal_util_oper_group op_type, bcmos_bool send_ind);
bcmos_errno mac_util_group_info_validate(const bcmbal_group_cfg *p_group_req);

bcmos_errno mac_util_tm_sched_info_validate(const bcmbal_tm_sched_cfg *p_tm_sched_req);
bcmos_errno mac_util_agg_port_set(tm_sched_inst *p_tm_sched, bal_util_oper_agg_port op_type);


bcmos_errno mac_util_init(const char *maple_address);

bcmos_errno mac_util_cli_init(bcmcli_entry *p_cli_dir);

void mac_util_indication_cb(bcmolt_devid device_id, bcmolt_msg *p_msg);

bcmos_errno mac_util_finish(void);

/* reporting functions to core */
void mac_util_report_flow_add_success(bcmbal_flow_key flow_key, uint32_t pon_if);
void mac_util_report_flow_add_failed(bcmbal_flow_key flow_key, uint32_t pon_if, bcmos_errno err);
void mac_util_report_flow_remove_success(bcmbal_flow_key flow_key, uint32_t pon_if, bal_util_oper_flow op_type);
void mac_util_report_flow_remove_failed(bcmbal_flow_key flow_key, uint32_t pon_if, bal_util_oper_flow op_type, bcmos_errno err);

void mac_util_report_tm_sched_set_indication (bcmbal_tm_sched_key tm_sched_key, bcmos_errno err, bcmolt_result ind_result);

/** @brief handler routine type for maple indication handlers */
typedef bcmos_errno (mac_util_olt_ind_handler)(bcmolt_devid device_id, bcmolt_msg *p_msg);

/** @brief generic struct for maple indication object types and handlers that would be be handled in mac util */
typedef struct mac_util_olt_ind_obj_and_handlers
{
    bcmolt_obj_id obj_type;
    char          obj_type_str[50];
    mac_util_olt_ind_handler *ind_handler;
} mac_util_ind_obj_and_handlers;


char *_mac_util_get_obj_type_str_for_indications ( bcmolt_obj_id obj_type,
                                                   mac_util_ind_obj_and_handlers obj_types_and_handlers[], uint16_t num_obj_types);

/* maple indication handlers */
bcmos_errno mac_util_handle_all_olt_ind_for_gpon (bcmolt_devid device_id, bcmolt_msg *p_msg);
bcmos_errno mac_util_handle_all_olt_ind_for_xgpon (bcmolt_devid device_id, bcmolt_msg *p_msg);


/* flow mgmt wrapper functions */
flow_list_entry *_mac_util_db_flow_alloc (void);
bcmos_errno _mac_util_db_flow_free (uint32_t pon_if, flow_list_entry *p_entry);

bcmos_errno _mac_util_db_flow_add (uint32_t pon_if, flow_list_entry *p_entry);
bcmos_errno _mac_util_db_flow_remove (uint32_t pon_if, flow_list_entry *p_entry);

flow_list_entry *_mac_util_db_flow_get_w_flow_key (uint32_t pon_if, bcmbal_flow_key *p_flow_key);
flow_list_entry *_mac_util_db_flow_get_next_w_flow_key (uint32_t pon_if, flow_list_entry *p_curr_entry, flow_list_entry **pp_next_entry);


flow_list_entry *_mac_util_db_flow_get_next_w_sub_term_id (uint32_t pon_if, uint32_t sub_term_id,
                                                       flow_list_entry *p_curr_entry, flow_list_entry **pp_next_entry);


bcmos_errno _mac_util_db_flow_count_w_gem (uint32_t pon_if, uint16_t gem_port_id, uint32_t *p_count);
flow_list_entry *_mac_util_db_flow_get_next_w_gem (uint32_t pon_if, uint16_t gem_port_id,
                                                   void **pp_rsc_mgr_curr_entry, void **pp_rsc_mgr_next_entry);

bcmos_errno _mac_util_db_flow_count_w_alloc_id (uint32_t pon_if, uint16_t alloc_id, uint32_t *p_count);
flow_list_entry *_mac_util_db_flow_get_next_w_alloc_id (uint32_t pon_if, uint16_t alloc_id,
                                                        void **pp_rsc_mgr_curr_entry, void **pp_rsc_mgr_next_entry);

/* interface set */
bcmos_errno mac_util_interface_set_for_gpon(acc_term_interface *p_interface_inst, bal_util_oper_if op_type);
bcmos_errno mac_util_interface_set_for_xgpon(acc_term_interface *p_interface_inst, bal_util_oper_if op_type);
bcmos_errno mac_util_interface_set_for_loopback(acc_term_interface *p_interface_inst, bal_util_oper_if op_type);

/* sub term validate */
bcmos_errno mac_util_validate_subscriber_terminal_info_for_gpon(const bcmbal_subscriber_terminal_cfg *p_sub_term_req);
bcmos_errno mac_util_validate_subscriber_terminal_info_for_xgpon(const bcmbal_subscriber_terminal_cfg *p_sub_term_req);

/* sub term set */
bcmos_errno mac_util_subscriber_terminal_set_for_gpon(sub_term_inst *p_sub_term_inst, bal_util_oper_sub_term op_type, bcmos_bool is_post_discovery);
bcmos_errno mac_util_subscriber_terminal_set_for_xgpon(sub_term_inst *p_sub_term_inst, bal_util_oper_sub_term op_type, bcmos_bool is_post_discovery);
bcmos_errno mac_util_subscriber_terminal_set_for_loopback(sub_term_inst *p_sub_term_inst, bal_util_oper_sub_term op_type, bcmos_bool is_post_discovery);

/* flow validates */
bcmos_errno mac_util_validate_flow_info_for_gpon(const bcmbal_flow_cfg *p_flow_req);
bcmos_errno mac_util_validate_flow_info_for_xgpon(const bcmbal_flow_cfg *p_flow_req);


/* flow sets */
bcmos_errno mac_util_flow_set_for_gpon (bcmbal_flow_cfg *p_flow_req, bal_util_oper_flow op_type, flow_inst *p_flow_core);
bcmos_errno mac_util_flow_set_for_xgpon (bcmbal_flow_cfg *p_flow_req, bal_util_oper_flow op_type, flow_inst *p_flow_core);
bcmos_errno mac_util_flow_set_for_loopback(bcmbal_flow_cfg *p_flow_req, bal_util_oper_flow op_type, flow_inst *p_flow_core);

/* group sets */
bcmos_errno mac_util_group_set_for_gpon (bcmbal_group_cfg *p_group_req, bal_util_oper_group op_type, group_inst *p_group_context);
bcmos_errno mac_util_group_set_for_xgpon (bcmbal_group_cfg *p_group_req, bal_util_oper_group op_type, group_inst *p_group_context);

bcmos_errno maple_access_terminal_set_common (acc_term_inst *p_acc_term, bal_util_oper_acc_term op_type, bcmolt_devid device_id);
bcmos_errno maple_access_terminal_connect_common (bcmolt_devid device_id);
bcmos_errno mac_util_init_parse_mac_ip_and_port (const char *maple_address);


/* Report events to core */
void mac_util_report_acc_term_event(uint16_t event);
void mac_util_report_if_event(bcmbal_intf_id intf_id,
                              bcmbal_intf_type intf_type,
                              bcmos_errno err,
                              bcmolt_result result,
                              bcmolt_pon_state new_state);
bcmos_errno check_send_flow_bal_ind_msg(flow_list_entry *p_flow,
                                        bcmos_errno err,
                                        bcmolt_result ind_result);

void mac_util_report_sub_term_event(bcmbal_intf_id pon_ni,
                                    bcmbal_sub_id onu_id,
                                    bcmolt_serial_number *p_serial_number,
                                    bal_util_oper_sub_term oper,
                                    bcmos_errno err,
                                    bcmolt_result result,
                                    bcmolt_activation_fail_reason fail_reason,
                                    bcmolt_epon_tunnel_id tunnel_id);



void mac_util_report_flow_auto_ind (uint32_t pon_if,
    bcmbal_flow_key  flow_key ,bal_util_oper_flow  op_type, bal_util_flow_ind ind);


#define MAC_UTIL_DUMMY_ONU_ID_FOR_MULTICAST_GEM BCMOLT_GPON_ONU_ID_ANY

#define GET_DEVICE_ID_AND_PHYSICAL_ID_FROM_IF_ID(_if_id, _device_id, _physical_if_id) \
    do \
    { \
       rc = bcm_topo_pon_get_logical2physical(_if_id, &(_device_id), &(_physical_if_id)); \
       if (BCM_ERR_OK != rc) \
       { \
           BCM_LOG(ERROR, MAC_UTIL_GET_LOG_ID_FOR_PON_IF(_if_id), \
                   "Failed to get physical if from logical if (%s)\n", bcmos_strerror(rc)); \
           return rc; \
       } \
    } \
    while (0)


/*@}*/
#endif /* BAL_MAC_UTIL_H */



