/******************************************************************************
 *
 *  <:copyright-BRCM:2016:DUAL/GPL:standard
 *  
 *     Copyright (c) 2016 Broadcom
 *     All Rights Reserved
 *  
 *  Unless you and Broadcom execute a separate written software license
 *  agreement governing use of this software, this software is licensed
 *  to you under the terms of the GNU General Public License version 2
 *  (the "GPL"), available at http://www.broadcom.com/licenses/GPLv2.php,
 *  with the following added to such license:
 *  
 *     As a special exception, the copyright holders of this software give
 *     you permission to link this software with independent modules, and
 *     to copy and distribute the resulting executable under terms of your
 *     choice, provided that you also meet, for each linked independent
 *     module, the terms and conditions of the license of that module.
 *     An independent module is a module which is not derived from this
 *     software.  The special exception does not apply to any modifications
 *     of the software.
 *  
 *  Not withstanding the above, under no circumstances may you combine
 *  this software in any way with any other Broadcom software provided
 *  under a license other than the GPL, without Broadcom's express prior
 *  written consent.
 *  
 *  :>
 *
 *****************************************************************************/
 
#ifndef BCMOS_PLATFORM_H_
#define BCMOS_PLATFORM_H_

#ifndef BCMOS_SYSTEM_H_
#error Please do not include bcmos_platform.h directly. Include bcmos_system.h
#endif

#include <bal_osmsg.h>

/** BAL CORE CPU core
 * \ingroup system_task */
typedef enum
{
    BCMOS_CPU_CORE_ANY,                         /**< Any core */

    BCMOS_CPU_CORE__NUM_OF = 1,                 /**< Number of cores */
} bcmos_core;

/*
 * BAL CORE modules
 *
 * \ingroup system_module
 */
typedef enum
{
    BCMOS_MODULE_ID_NONE,                       /**< no module */

    BCMOS_MODULE_ID_WORKER_MGMT,                /** worker module for MGMT message handling */
    BCMOS_MODULE_ID_WORKER_API_IND,             /** worker module for BAL API INDICATION message handling */
    BCMOS_MODULE_ID_WORKER_BAL_CORE_FOR_AGENT,  /** worker module for the BAL CORE when running as an OF agent */
    BCMOS_MODULE_ID_USER_APPL_EON,              /** EON module */
    BCMOS_MODULE_ID_USER_APPL_EPON_OAM,         /** EPON OAM module */
    BCMOS_MODULE_ID_OFPAL,                      /** OF-PAL module */
	BCMOS_MODULE_ID_OMCI_TRANSPORT,         /** OMCI Transport module */

    BCMOS_MODULE_ID__NUM_OF,                    /**< Number of modules */
    BCMOS_MODULE_ID_INVALID = BCMOS_MODULE_ID_NONE
} bcmos_module_id;

/*
 * BAL CORE event group. Each group supports up to 32 events.
 *
 * \ingroup system_event
 */
typedef enum
{
    BCMOS_EVENT_FIRST,

    BCMOS_EVENT_ID__NUM_OF,                     /**< Number of event groups */
} bcmos_event_id;

/** Message hash size
 * \ingroup system_msg
 */
#define BCMOS_MSG_HASH_SIZE     512

/*
 * Task priorities
 */
#define TASK_PRIORITY_IPC_RX            	BCMOS_TASK_PRIORITY_3
#define TASK_PRIORITY_CLI              		BCMOS_TASK_PRIORITY_15
#define TASK_PRIORITY_WORKER            	BCMOS_TASK_PRIORITY_16
#define TASK_PRIORITY_USER_APPL_EON     	BCMOS_TASK_PRIORITY_17
#define TASK_PRIORITY_OFPAL            		BCMOS_TASK_PRIORITY_18
#define TASK_PRIORITY_OMCI_TRANSPORT        BCMOS_TASK_PRIORITY_20
#define TASK_PRIORITY_DEV_LOG           	BCMOS_TASK_PRIORITY_30

#endif /* BCMOS_PLATFORM_H_ */
