/******************************************************************************
 *
 *  <:copyright-BRCM:2016:DUAL/GPL:standard
 *  
 *     Copyright (c) 2016 Broadcom
 *     All Rights Reserved
 *  
 *  Unless you and Broadcom execute a separate written software license
 *  agreement governing use of this software, this software is licensed
 *  to you under the terms of the GNU General Public License version 2
 *  (the "GPL"), available at http://www.broadcom.com/licenses/GPLv2.php,
 *  with the following added to such license:
 *  
 *     As a special exception, the copyright holders of this software give
 *     you permission to link this software with independent modules, and
 *     to copy and distribute the resulting executable under terms of your
 *     choice, provided that you also meet, for each linked independent
 *     module, the terms and conditions of the license of that module.
 *     An independent module is a module which is not derived from this
 *     software.  The special exception does not apply to any modifications
 *     of the software.
 *  
 *  Not withstanding the above, under no circumstances may you combine
 *  this software in any way with any other Broadcom software provided
 *  under a license other than the GPL, without Broadcom's express prior
 *  written consent.
 *  
 *  :>
 *
 *****************************************************************************/
 
/**
 * @file tm_sched_fsm.h
 * @brief Code to support the BAL TM Sched FSM
 *
 */

#ifndef TM_SCHED_FSM_H
#define TM_SCHED_FSM_H

/*@{*/

#include <bcmos_system.h>
#include <bal_api.h>
#include <tm_queue_fsm.h>

/* set the total pool size of available tm sched instances to 4k */
#define TM_SCHED_ALLOCATION_BLOCK_SIZE  (4096)

typedef enum
{
    TM_SCHED_FSM_EVENT_TYPE_NONE       = -1,
    TM_SCHED_FSM_EVENT_TYPE_CREATE     ,
    TM_SCHED_FSM_EVENT_TYPE_DESTROY    ,
    TM_SCHED_FSM_EVENT_TYPE_ASSIGN        ,
    TM_SCHED_FSM_EVENT_TYPE_UTIL_MSG   ,

    TM_SCHED_FSM_EVENT_TYPE__LAST,
    TM_SCHED_FSM_EVENT_TYPE__NUM_OF
} tm_sched_fsm_event_type;



typedef enum
{
    TM_SCHED_FSM_STATE_NONE =     -1,
    TM_SCHED_FSM_STATE_NULL         ,
    TM_SCHED_FSM_STATE_INACTIVE   ,
    TM_SCHED_FSM_STATE_ASSIGNED   ,
    TM_SCHED_FSM_STATE_ACTIVE   ,
    TM_SCHED_FSM_STATE_DELETING     ,
 
    TM_SCHED_FSM_STATE__LAST,
    TM_SCHED_FSM_STATE__NUM_OF
} tm_sched_fsm_state;


typedef enum
{
    TM_SCHED_FLAG_ACTIVE =     1<<0,    /**< A tm_sched is on the active list */
    TM_SCHED_FLAG_FREE =       1<<1,    /**< A tm_sched is on the free list */
    TM_SCHED_FLAG_ANY =        (TM_SCHED_FLAG_ACTIVE | TM_SCHED_FLAG_FREE),    /**< A tm_sched is on either the active or free list */
} tm_sched_flag;


typedef struct tm_sched_fsm_event_t
{
    tm_sched_fsm_event_type event_type;   /**< The tm_sched fsm events */
    void             *msg;

    /* other necessary information */
} tm_sched_fsm_event;

typedef struct queue_entry
{
    bcmbal_tm_queue_id queue_id;
    TAILQ_ENTRY(queue_entry) next; /**< TAILQ link */    
}queue_entry;

typedef struct sub_sched_entry
{
    bcmbal_tm_sched_id sched_id;
    TAILQ_ENTRY(sub_sched_entry) next; /**< TAILQ link */    
}sub_sched_entry;

typedef struct tm_sched_inst tm_sched_inst;
struct tm_sched_inst
{
    bcmbal_tm_sched_cfg    current_tm_sched_info;   /**< The current information for this tm_sched (used for GET) */
    bcmbal_tm_sched_cfg    req_tm_sched_info;   /**< The last tm_sched object info received from the Public API */	
    uint16_t             num_queues_on_node;   /**< The number of queues attached to this node */
    TAILQ_HEAD(queues_list_head, queue_entry) queues_list;	
    uint16_t             num_sub_scheds_on_node;   /**< The number of sub schedulers for this tm sched */
    TAILQ_HEAD(sub_scheds_list_head, sub_sched_entry) sub_scheds_list;
    tm_sched_fsm_state     fsm_state;          /**< The tm_sched FSM state */
    TAILQ_ENTRY(tm_sched_inst) tm_sched_inst_next; /**< TAILQ link */
};


/* 
 * Group FSM data structures
 */
typedef struct tm_sched_fsm_ctx
{
    /* Lists of free tm_sched entries and active tm_sched entries
     */
    TAILQ_HEAD(free_tm_sched_list_head, tm_sched_inst) free_tm_sched_list;

    TAILQ_HEAD(active_tm_sched_list_head, tm_sched_inst) active_tm_sched_list;

} tm_sched_fsm_ctx;


/* Function declarations */

extern bcmos_errno tm_sched_fsm_init(void);
extern bcmos_errno tm_sched_fsm_finish(void);
extern bcmos_errno process_tm_sched_util_msg(void *msg_payload);
extern bcmos_errno process_tm_sched_object(void *msg_payload);

tm_sched_inst *tm_sched_inst_get(bcmbal_tm_sched_key key, tm_sched_flag search_flag);
bcmos_errno bcmbal_tm_sched_auto_create(bcmbal_tm_sched_cfg cfg, tm_sched_inst **p_tm_sched_inst);
bcmos_errno bcmbal_tm_sched_set_owner(tm_sched_inst *p_tm_sched_inst);
bcmos_errno bcmbal_tm_sched_unset_owner(tm_sched_inst *p_tm_sched_inst);
bcmos_errno bcmbal_tm_sched_set_queue(tm_queue_inst *p_tm_queue_inst);
bcmos_errno bcmbal_tm_sched_remove_queue(tm_queue_inst *p_tm_queue_inst);
tm_sched_inst * tm_sched_find_agg_port_node(uint8_t intf_id, bcmbal_aggregation_port_id agg_port_id);
bcmos_errno bcmbal_tm_sched_fsm_active_destroy(tm_sched_inst *p_tm_sched_inst);



#define TM_SCHED_DIR_TO_STR(dir) ((dir) == BCMBAL_TM_SCHED_DIR_DS ? "ds" : "us")
/*@}*/

#endif /*TM_SCHED_FSM_H */

