/******************************************************************************
 *
 *  <:copyright-BRCM:2016:DUAL/GPL:standard
 *  
 *     Copyright (c) 2016 Broadcom
 *     All Rights Reserved
 *  
 *  Unless you and Broadcom execute a separate written software license
 *  agreement governing use of this software, this software is licensed
 *  to you under the terms of the GNU General Public License version 2
 *  (the "GPL"), available at http://www.broadcom.com/licenses/GPLv2.php,
 *  with the following added to such license:
 *  
 *     As a special exception, the copyright holders of this software give
 *     you permission to link this software with independent modules, and
 *     to copy and distribute the resulting executable under terms of your
 *     choice, provided that you also meet, for each linked independent
 *     module, the terms and conditions of the license of that module.
 *     An independent module is a module which is not derived from this
 *     software.  The special exception does not apply to any modifications
 *     of the software.
 *  
 *  Not withstanding the above, under no circumstances may you combine
 *  this software in any way with any other Broadcom software provided
 *  under a license other than the GPL, without Broadcom's express prior
 *  written consent.
 *  
 *  :>
 *
 *****************************************************************************/
 
/**
 * @file tm_queue_fsm.h
 * @brief Code to support the BAL tm_queue FSM
 *
 */

#ifndef TM_QUEUE_FSM_H
#define TM_QUEUE_FSM_H

/*@{*/

#include <bcmos_system.h>
#include <bal_api.h>

/* set the total pool size of available tm queue to 4k */
#define TM_QUEUE_ALLOCATION_BLOCK_SIZE  (4096)

typedef enum
{
    TM_QUEUE_FSM_EVENT_TYPE_NONE       = -1,
    TM_QUEUE_FSM_EVENT_TYPE_CREATE     ,
    TM_QUEUE_FSM_EVENT_TYPE_DESTROY    ,
    TM_QUEUE_FSM_EVENT_TYPE_UTIL_MSG   ,

    TM_QUEUE_FSM_EVENT_TYPE__LAST,
    TM_QUEUE_FSM_EVENT_TYPE__NUM_OF
} tm_queue_fsm_event_type;



typedef enum
{
    TM_QUEUE_FSM_STATE_NONE =     -1,
    TM_QUEUE_FSM_STATE_NULL         ,
    TM_QUEUE_FSM_STATE_INACTIVE     ,
    TM_QUEUE_FSM_STATE_ACTIVE       ,
    TM_QUEUE_FSM_STATE_IN_USE       ,
    TM_QUEUE_FSM_STATE_DELETING     ,
 
    TM_QUEUE_FSM_STATE__LAST,
    TM_QUEUE_FSM_STATE__NUM_OF
} tm_queue_fsm_state;


typedef enum
{
    TM_QUEUE_FLAG_ACTIVE =     1<<0,    /**< A tm_queue is on the active list */
    TM_QUEUE_FLAG_FREE =       1<<1,    /**< A tm_queue is on the free list */
    TM_QUEUE_FLAG_ANY =        (TM_QUEUE_FLAG_ACTIVE | TM_QUEUE_FLAG_FREE),    /**< A tm_queue is on either the active or free list */
} tm_queue_flag;


typedef struct tm_queue_fsm_event_t
{
    tm_queue_fsm_event_type event_type;   /**< The tm_queue fsm events */
    void             *msg;

    /* other necessary information */
} tm_queue_fsm_event;


typedef struct tm_queue_inst tm_queue_inst;
struct tm_queue_inst
{
    bcmbal_tm_queue_cfg    current_tm_queue_info;   /**< The current information for this tm queue (used for GET) */
    bcmbal_tm_queue_cfg    api_req_tm_queue_info;   /**< The tm queue  object info received from the Public API */
    tm_queue_fsm_state     fsm_state;          /**< The tm queue FSM state */

    TAILQ_ENTRY(tm_queue_inst) tm_queue_inst_next; /**< TAILQ link */
};


/* 
 * tm_queue FSM data structures
 */
typedef struct tm_queue_fsm_ctx
{
    /* Lists of free tm_queue entries and active tm_queue entries
     */
    TAILQ_HEAD(free_tm_queue_list_head, tm_queue_inst) free_tm_queue_list;

    TAILQ_HEAD(active_tm_queue_list_head, tm_queue_inst) active_tm_queue_list;

} tm_queue_fsm_ctx;


/* Function declarations */

extern bcmos_errno tm_queue_fsm_init(void);
extern bcmos_errno tm_queue_fsm_finish(void);
extern bcmos_errno process_tm_queue_object(void *msg_payload);

extern tm_queue_inst *tm_queue_inst_get(bcmbal_tm_queue_key key, tm_queue_flag search_flag);
extern bcmos_errno bcmbal_tm_queue_auto_create(bcmbal_tm_queue_cfg tm_queue_default_cfg);
extern bcmos_errno bcmbal_tm_queue_set_owner(bcmbal_tm_queue_key key);
extern bcmos_errno bcmbal_tm_queue_unset_owner(bcmbal_tm_queue_key key);

extern bcmos_errno bcmbal_tm_queue_activate(tm_queue_inst *p_tm_queue_inst);
extern bcmos_errno bcmbal_tm_queue_deactivate(tm_queue_inst *p_tm_queue_inst);
extern bcmos_errno bcmbal_tm_queue_use_set(tm_queue_inst *p_tm_queue_inst, bcmos_bool is_in_use);
extern bcmos_errno bcmbal_tm_queue_destroy(tm_queue_inst *p_tm_queue_inst, bcmos_bool remove_from_node);



/*@}*/

#endif /*TM_QUEUE_FSM_H */

