/******************************************************************************
 *
 *  <:copyright-BRCM:2016:DUAL/GPL:standard
 *  
 *     Copyright (c) 2016 Broadcom
 *     All Rights Reserved
 *  
 *  Unless you and Broadcom execute a separate written software license
 *  agreement governing use of this software, this software is licensed
 *  to you under the terms of the GNU General Public License version 2
 *  (the "GPL"), available at http://www.broadcom.com/licenses/GPLv2.php,
 *  with the following added to such license:
 *  
 *     As a special exception, the copyright holders of this software give
 *     you permission to link this software with independent modules, and
 *     to copy and distribute the resulting executable under terms of your
 *     choice, provided that you also meet, for each linked independent
 *     module, the terms and conditions of the license of that module.
 *     An independent module is a module which is not derived from this
 *     software.  The special exception does not apply to any modifications
 *     of the software.
 *  
 *  Not withstanding the above, under no circumstances may you combine
 *  this software in any way with any other Broadcom software provided
 *  under a license other than the GPL, without Broadcom's express prior
 *  written consent.
 *  
 *  :>
 *
 *****************************************************************************/
 
/**
 * @file sub_term_fsm.h
 * @brief Code to support the BAL Subscriber Terminal FSM
 *
 * @defgroup sub_terminal Subscriber Terminal
 * @ingroup core
 */


#ifndef SUB_TERM_FSM_H
#define SUB_TERM_FSM_H

/*@{*/

#include <bal_api.h>

/* The current implementation supports a global pool of
 * ONU instances.
 */
#define NUM_SUPPORTED_SUB_TERMS (4096)

typedef enum
{
    SUB_TERM_FSM_EVENT_TYPE_NONE                 = -1,
    SUB_TERM_FSM_EVENT_TYPE_ADMIN_UP                 ,
    SUB_TERM_FSM_EVENT_TYPE_ADMIN_DN                 ,
    SUB_TERM_FSM_EVENT_TYPE_REMOVE                   ,
    SUB_TERM_FSM_EVENT_TYPE_UTIL_MSG                 ,
    SUB_TERM_FSM_EVENT_TYPE_UTIL_AUTO_MSG            ,


    SUB_TERM_FSM_EVENT_TYPE__LAST,
    SUB_TERM_FSM_EVENT_TYPE__NUM_OF
} sub_term_fsm_event_type;



typedef enum
{
    SUB_TERM_FSM_STATE_NONE     = -1,
    SUB_TERM_FSM_STATE_NULL         ,
    SUB_TERM_FSM_STATE_CONFIGURING  ,
    SUB_TERM_FSM_STATE_CONFIGURED   ,
    SUB_TERM_FSM_STATE_REMOVING     ,
 

    SUB_TERM_FSM_STATE__LAST,
    SUB_TERM_FSM_STATE__NUM_OF
} sub_term_fsm_state;


typedef enum
{
    SUB_TERM_FLAG_ANY  = 1,            /**< ONLY USED in the sub_term get argument */
    SUB_TERM_FLAG_ACTIVE  ,            /**< A sub_term is on the active list */
    SUB_TERM_FLAG_FREE                 /**< A sub_term is on the free list */
} sub_term_flag;


typedef struct sub_term_fsm_event
{
    sub_term_fsm_event_type event_type;   /**< The sub_term FSM event */
    void             *msg;
} sub_term_fsm_event;


typedef struct svc_port_id_entry
{
    bcmbal_service_port_id svc_port_id;
    uint8_t ref_count;                    /**< A count of the number of re-uses of this svc_port_id on this subscriber terminal */
    TAILQ_ENTRY(svc_port_id_entry) next ; /**< TAILQ link */    
}svc_port_id_entry;

typedef struct agg_port_id_entry
{
    bcmbal_aggregation_port_id agg_port_id;
    uint8_t ref_count;                    /**< A count of the number of re-uses of this agg_port_id on this subscriber terminal */
    TAILQ_ENTRY(agg_port_id_entry) next ; /**< TAILQ link */    
}agg_port_id_entry;

typedef struct sub_term_inst sub_term_inst;
struct sub_term_inst
{
    bcmbal_subscriber_terminal_cfg  current_sub_term_info;  /**< The current information for this sub_term (used for GET) */
    bcmbal_subscriber_terminal_cfg  api_req_sub_term_info;  /**< The last sub_term object info received from the Public API */
    sub_term_fsm_state              fsm_state;              /**< The sub_term instance FSM state */
    uint16_t                        num_svc_port_ids;       /**< The number of bearer traffic GEMs on this subscriber terminal */
    TAILQ_HEAD(svc_port_id_list_head, svc_port_id_entry) svc_port_id_list; /* A list of svc_port_ids on this subscriber terminal */
    uint16_t                        num_agg_port_ids;       /**< The number of alloc ids on this subscriber terminal */
    TAILQ_HEAD(agg_port_id_list_head, agg_port_id_entry) agg_port_id_list; /* A list of svc_port_ids on this subscriber terminal */
    TAILQ_ENTRY(sub_term_inst)      sub_term_inst_next ;    /**< TAILQ link for active list and free list management */
};


/* 
 * Sub_Term FSM data structures
 */
typedef struct sub_term_fsm_ctx
{
    /* Lists of free sub_term entries and active sub_term entries
     */
    TAILQ_HEAD(free_sub_term_list_head, sub_term_inst) free_sub_term_list;  

    TAILQ_HEAD(active_sub_term_list_head, sub_term_inst) active_sub_term_list;  

} sub_term_fsm_ctx;


/* 
 * Function declarations 
 */
extern bcmos_errno sub_term_fsm_init(void);

extern bcmos_errno sub_term_fsm_finish(void);

extern bcmos_errno process_subscriber_terminal_object(void *msg_payload);

extern bcmos_errno process_subscriber_terminal_util_msg(void *msg_payload);

extern sub_term_inst *sub_term_inst_get(bcmbal_subscriber_terminal_key *key, 
                                          sub_term_flag sub_term_flag);

extern bcmos_errno sub_term_svc_port_id_get(bcmbal_sub_id sub_term_id, 
                                            uint16_t access_int_id, 
                                            bcmbal_service_port_id *p_svc_port_id);

extern bcmos_errno bcmbal_sub_term_svc_port_id_list_entry_add(sub_term_inst *p_sub_term_inst,
                                                              bcmbal_service_port_id svc_port_id);

extern bcmos_errno bcmbal_sub_term_svc_port_id_list_entry_remove(sub_term_inst *p_sub_term_inst,
                                                                 bcmbal_service_port_id svc_port_id);

bcmos_errno bcmbal_sub_term_agg_port_id_list_entry_add(sub_term_inst *p_sub_term_inst,
                                                       bcmbal_aggregation_port_id agg_port_id);

bcmos_errno bcmbal_sub_term_agg_port_id_list_entry_remove(sub_term_inst *p_sub_term_inst,
                                                          bcmbal_aggregation_port_id agg_port_id);

bcmos_errno bcmbal_sub_term_check_agg_port_in_use(sub_term_inst *p_sub_term_inst,
                                                  bcmbal_aggregation_port_id agg_port_id);

bcmos_errno bcmbal_sub_term_check_svc_port_in_use(sub_term_inst *p_sub_term_inst,
                                                  bcmbal_service_port_id svc_port_id);



/*@}*/

#endif /*SUB_TERM_FSM_H */


