/******************************************************************************
 *
 *  <:copyright-BRCM:2016:DUAL/GPL:standard
 *  
 *     Copyright (c) 2016 Broadcom
 *     All Rights Reserved
 *  
 *  Unless you and Broadcom execute a separate written software license
 *  agreement governing use of this software, this software is licensed
 *  to you under the terms of the GNU General Public License version 2
 *  (the "GPL"), available at http://www.broadcom.com/licenses/GPLv2.php,
 *  with the following added to such license:
 *  
 *     As a special exception, the copyright holders of this software give
 *     you permission to link this software with independent modules, and
 *     to copy and distribute the resulting executable under terms of your
 *     choice, provided that you also meet, for each linked independent
 *     module, the terms and conditions of the license of that module.
 *     An independent module is a module which is not derived from this
 *     software.  The special exception does not apply to any modifications
 *     of the software.
 *  
 *  Not withstanding the above, under no circumstances may you combine
 *  this software in any way with any other Broadcom software provided
 *  under a license other than the GPL, without Broadcom's express prior
 *  written consent.
 *  
 *  :>
 *
 *****************************************************************************/
 
/**
 * @file group_fsm.h
 * @brief Code to support the BAL Group FSM
 *
 */

#ifndef GROUP_FSM_H
#define GROUP_FSM_H

/*@{*/

#include <bcmos_system.h>
#include <bal_api.h>

/* set the total number of available group to 4k */
#define GROUP_ALLOCATION_BLOCK_SIZE  (4095)

typedef enum
{
    GROUP_FSM_EVENT_TYPE_NONE       = -1,
    GROUP_FSM_EVENT_TYPE_CREATE     ,
    GROUP_FSM_EVENT_TYPE_DESTROY    ,
    GROUP_FSM_EVENT_TYPE_ADD        ,
    GROUP_FSM_EVENT_TYPE_REMOVE     ,
    GROUP_FSM_EVENT_TYPE_SET        ,
    GROUP_FSM_EVENT_TYPE_UTIL_MSG   ,

    GROUP_FSM_EVENT_TYPE__LAST,
    GROUP_FSM_EVENT_TYPE__NUM_OF
} group_fsm_event_type;



typedef enum
{
    GROUP_FSM_STATE_NONE =     -1,
    GROUP_FSM_STATE_NULL         ,
    GROUP_FSM_STATE_CONFIGURING  ,
    GROUP_FSM_STATE_CONFIGURED   ,
    GROUP_FSM_STATE_DELETING     ,
 
    GROUP_FSM_STATE__LAST,
    GROUP_FSM_STATE__NUM_OF
} group_fsm_state;


typedef enum
{
    GROUP_FLAG_ACTIVE =     1<<0,    /**< A group is on the active list */
    GROUP_FLAG_FREE =       1<<1,    /**< A group is on the free list */
    GROUP_FLAG_ANY =        (GROUP_FLAG_ACTIVE | GROUP_FLAG_FREE),    /**< A group is on either the active or free list */
} group_flag;


typedef struct group_fsm_event_t
{
    group_fsm_event_type event_type;   /**< The group fsm events */
    void             *msg;

    /* other necessary information */
} group_fsm_event;


typedef struct group_inst group_inst;
struct group_inst
{
    bcmbal_group_cfg    current_group_info;   /**< The current information for this group (used for GET) */
    bcmbal_group_cfg    api_req_group_info;   /**< The last group object info received from the Public API */
    group_fsm_state     fsm_state;          /**< The group FSM state */
    bcmos_timer         timer_info;       /**< A structure used for the state machine timeout timer */
    TAILQ_ENTRY(group_inst) group_inst_next ; /**< TAILQ link */
};


/* 
 * Group FSM data structures
 */
typedef struct group_fsm_ctx
{
    /* Lists of free group entries and active group entries
     */
    TAILQ_HEAD(free_group_list_head, group_inst) free_group_list;

    TAILQ_HEAD(active_group_list_head, group_inst) active_group_list;

} group_fsm_ctx;


/* Function declarations */

extern bcmos_errno group_fsm_init(void);
extern bcmos_errno group_fsm_finish(void);
extern bcmos_errno process_group_util_msg(void *msg_payload);
extern bcmos_errno process_group_object(void *msg_payload);
extern bcmos_bool  group_is_active(bcmbal_group_key *p_group_key);
extern bcmos_errno group_owner_set(bcmbal_group_key group_key, bcmbal_group_owner group_owner);
extern bcmos_errno group_owner_get(bcmbal_group_key group_key, bcmbal_group_owner *p_group_owner);

/*@}*/

#endif /*GROUP_FSM_H */

