/******************************************************************************
 *
 *  <:copyright-BRCM:2016:DUAL/GPL:standard
 *  
 *     Copyright (c) 2016 Broadcom
 *     All Rights Reserved
 *  
 *  Unless you and Broadcom execute a separate written software license
 *  agreement governing use of this software, this software is licensed
 *  to you under the terms of the GNU General Public License version 2
 *  (the "GPL"), available at http://www.broadcom.com/licenses/GPLv2.php,
 *  with the following added to such license:
 *  
 *     As a special exception, the copyright holders of this software give
 *     you permission to link this software with independent modules, and
 *     to copy and distribute the resulting executable under terms of your
 *     choice, provided that you also meet, for each linked independent
 *     module, the terms and conditions of the license of that module.
 *     An independent module is a module which is not derived from this
 *     software.  The special exception does not apply to any modifications
 *     of the software.
 *  
 *  Not withstanding the above, under no circumstances may you combine
 *  this software in any way with any other Broadcom software provided
 *  under a license other than the GPL, without Broadcom's express prior
 *  written consent.
 *  
 *  :>
 *
 *****************************************************************************/
 
/**
 * @file fsm_common.h
 * @brief Common code to support the BAL Access Terminal FSMs
 *
 * @ingroup core
 */
#ifndef FSM_COMMON_H
#define FSM_COMMON_H

/*@{*/

#include <bal_common.h>
#include <bal_obj.h>

#define TIMER_DURATION_1_SEC                      (1000)
#define TIMER_DURATION_IN_SEC(time_in_seconds)    (TIMER_DURATION_1_SEC*time_in_seconds)


extern bcmos_errno mgmt_msg_send_balapi_rsp(bcmos_errno cmd_status, 
                                            void *msg_payload,
                                            bcmbal_obj_msg_type oper_type, 
                                            dev_log_id log_id);

extern bcmos_errno mgmt_msg_send_balapi_ind(bcmos_errno cmd_status,
                                            void *msg_payload, /* If this is NULL, there is no message body */
                                            dev_log_id log_id);

extern bcmos_errno mgmt_msg_send_balapi_auto_ind(bcmos_errno cmd_status,
                                                 void *msg_payload, /* If this is NULL, there is no message body */
                                                 dev_log_id log_id);

extern bcmos_errno fsm_timer_start(bcmos_timer *p_timer_inst,
                                   void *p_inst,
                                   F_bcmos_timer_handler p_timer_expiry_handler,
                                   uint32_t delay,  /* delay is in mS */
                                   dev_log_id log_id);

extern void fsm_timer_stop(bcmos_timer *p_timer_inst);

/*@}*/

#endif /*FSM_COMMON_H */
