/******************************************************************************
 *
 *  <:copyright-BRCM:2016:DUAL/GPL:standard
 *  
 *     Copyright (c) 2016 Broadcom
 *     All Rights Reserved
 *  
 *  Unless you and Broadcom execute a separate written software license
 *  agreement governing use of this software, this software is licensed
 *  to you under the terms of the GNU General Public License version 2
 *  (the "GPL"), available at http://www.broadcom.com/licenses/GPLv2.php,
 *  with the following added to such license:
 *  
 *     As a special exception, the copyright holders of this software give
 *     you permission to link this software with independent modules, and
 *     to copy and distribute the resulting executable under terms of your
 *     choice, provided that you also meet, for each linked independent
 *     module, the terms and conditions of the license of that module.
 *     An independent module is a module which is not derived from this
 *     software.  The special exception does not apply to any modifications
 *     of the software.
 *  
 *  Not withstanding the above, under no circumstances may you combine
 *  this software in any way with any other Broadcom software provided
 *  under a license other than the GPL, without Broadcom's express prior
 *  written consent.
 *  
 *  :>
 *
 *****************************************************************************/
 
/**
 * @file flow_fsm.h
 * @brief Code to support the BAL Flow FSM
 *
 * @defgroup flow Flow
 * @ingroup core
 */

#ifndef FLOW_FSM_H
#define FLOW_FSM_H

/*@{*/

#include <bcmos_system.h>
#include <bal_api.h>

#define FLOW_ALLOCATION_BLOCK_SIZE  (16384)

#define CORE_FSM_FLOW_TYPE_GET_STR(_fsm_flow_type)   (BCMBAL_FLOW_TYPE_MULTICAST == (_fsm_flow_type) ? "Multicast":\
                                             BCMBAL_FLOW_TYPE_BROADCAST == (_fsm_flow_type) ? "Broadcast":\
                                             BCMBAL_FLOW_TYPE_DOWNSTREAM == (_fsm_flow_type) ? "Downstream":\
                                             BCMBAL_FLOW_TYPE_UPSTREAM == (_fsm_flow_type) ? "Upstream":"Invalid")


typedef enum
{
    FLOW_FSM_EVENT_TYPE_NONE                 = -1,
    FLOW_FSM_EVENT_TYPE_ADMIN_UP                 ,
    FLOW_FSM_EVENT_TYPE_ADMIN_DN                 ,
    FLOW_FSM_EVENT_TYPE_REMOVE                   ,
    FLOW_FSM_EVENT_TYPE_UTIL_MSG                 ,
    FLOW_FSM_EVENT_TYPE_UTIL_AUTO_MSG            ,


    FLOW_FSM_EVENT_TYPE__LAST,
    FLOW_FSM_EVENT_TYPE__NUM_OF
} flow_fsm_event_type;



typedef enum
{
    FLOW_FSM_STATE_NONE =     -1,
    FLOW_FSM_STATE_NULL         ,
    FLOW_FSM_STATE_CONFIGURING  ,
    FLOW_FSM_STATE_CONFIGURED   ,
    FLOW_FSM_STATE_REMOVING     ,
 

    FLOW_FSM_STATE__LAST,
    FLOW_FSM_STATE__NUM_OF
} flow_fsm_state;


typedef enum
{
    FLOW_FLAG_ACTIVE =     1<<0,    /**< A flow is on the active list */
    FLOW_FLAG_FREE =       1<<1,    /**< A flow is on the free list */
    FLOW_FLAG_ANY =        (FLOW_FLAG_ACTIVE | FLOW_FLAG_FREE),    /**< A flow is on either the active or free list */
    FLOW_FLAG_IGNORE_DIR = 1<<2     /**< Ignore direction during operation */
} flow_flag;


typedef struct flow_fsm_event_t
{
    flow_fsm_event_type event_type;   /**< The flow fsm events */
    void             *msg;

    /* other necessary information */
} flow_fsm_event;


/* Flow state in MAC plugin */
typedef enum
{
    FLOW_MAC_STATE_NONE  =  0x00,    /**< Neither svc_id nor agg_id configured */
    FLOW_MAC_STATE_SVC   =  1<<0,    /**< SVC is configured */
    FLOW_MAC_STATE_AGG   =  1<<1,    /**< AGG is configured */
    FLOW_MAC_STATE_READY = (FLOW_MAC_STATE_SVC | FLOW_MAC_STATE_AGG)
} flow_mac_state;

typedef struct flow_inst flow_inst;
struct flow_inst
{
    bcmbal_flow_cfg    current_flow_info;    /**< The current information for this flow (used for GET) */
    bcmbal_flow_cfg    api_req_flow_info;    /**< The last flow object info received from the Public API */
    flow_fsm_state      fsm_state;           /**< The Flow FSM state */
    flow_mac_state      mac_state;           /**< Flow state from MAC point of view */
    struct flow_inst      *p_peer_flow_inst; /**< Pointer to the linked flow in the opposite direction (if any) */
    struct sub_term_inst  *p_sub_term_inst;  /**< Pointer to subscriber terminal instance associated with this flow */
    bcmos_timer           timer_info;        /**< A structure used for the state machine timeout timer */
    TAILQ_ENTRY(flow_inst) flow_inst_next ;  /**< TAILQ link */
    TAILQ_ENTRY(flow_inst) rsc_mgr_list_next ;  /**< TAILQ link used for storing in Resource mgr list */
};


/* 
 * Flow FSM data structures
 */
typedef struct flow_fsm_ctx
{
    /* Lists of free flow entries and active flow entries
     */
    TAILQ_HEAD(free_flow_list_head, flow_inst) free_flow_list;

    TAILQ_HEAD(active_flow_list_head, flow_inst) active_flow_list;

} flow_fsm_ctx;


/* 
 * Function declarations 
 */
extern bcmos_errno flow_fsm_init(void);
extern bcmos_errno flow_fsm_finish(void);

extern bcmos_errno process_flow_object(void *msg_payload);

extern bcmos_errno process_flow_util_msg(void *msg_payload);

extern flow_inst *flow_get_by_svc_id(uint16_t access_if_id, 
                                       bcmbal_flow_type type,
                                       bcmbal_service_port_id svc_port_id);

extern flow_inst *flow_get_by_agg_id(uint16_t access_if_id, 
                                       bcmbal_aggregation_port_id agg_port_id);

extern bcmos_errno svc_port_id_for_sub_term_ds_flow_get(uint16_t access_if_id, 
                                                        uint16_t sub_term_id,
                                                        uint16_t sub_term_uni,
                                                        uint16_t *svc_port_id);

extern bcmbal_flow_cfg *flow_get_current_info_by_key(bcmbal_flow_key key);


/*@}*/

#endif /*FLOW_FSM_H */

