/******************************************************************************
 *
 *  <:copyright-BRCM:2016:DUAL/GPL:standard
 *
 *     Copyright (c) 2016 Broadcom
 *     All Rights Reserved
 *
 *  Unless you and Broadcom execute a separate written software license
 *  agreement governing use of this software, this software is licensed
 *  to you under the terms of the GNU General Public License version 2
 *  (the "GPL"), available at http://www.broadcom.com/licenses/GPLv2.php,
 *  with the following added to such license:
 *
 *     As a special exception, the copyright holders of this software give
 *     you permission to link this software with independent modules, and
 *     to copy and distribute the resulting executable under terms of your
 *     choice, provided that you also meet, for each linked independent
 *     module, the terms and conditions of the license of that module.
 *     An independent module is a module which is not derived from this
 *     software.  The special exception does not apply to any modifications
 *     of the software.
 *
 *  Not withstanding the above, under no circumstances may you combine
 *  this software in any way with any other Broadcom software provided
 *  under a license other than the GPL, without Broadcom's express prior
 *  written consent.
 *
 *  :>
 *
 *****************************************************************************/

/**
 * @file bal_core.h
 * @brief The include files common to all core files
 *
 * @addtogroup ctrlr
 */


#ifndef	COREMAIN_H
#define	COREMAIN_H

/*@{*/
#include <bcmos_system.h>
#include <bal_objs.h>
#ifdef ENABLE_LOG
#include <bcm_dev_log.h>
#endif
#include <bcm_topo.h>
#include <cmdline.h>

extern dev_log_id log_id_core;


#define BIT_FIELD_MAC_IN_LOOPBACK       0x01
#define BIT_FIELD_SWITCH_IN_LOOPBACK    0x02
#define IS_MAC_IN_LOOPBACK(config)      ((config) & BIT_FIELD_MAC_IN_LOOPBACK)
#define IS_NNI_INTF_AUTONEG_ON(config, intf)      (config & (1 << intf))

typedef struct bcmbal_config_params
{
    bcmbal_iwf_mode iwf_mode;
    uint32_t        intf_maptable;
    uint32_t        trap_udp_port;
    uint16_t        num_nni_ports;
    uint32_t        ds_sched_mode;
    uint32_t        pkt_send_svr_listen_port;  /* The port number where the bcm.user process listens for packet send messages from the core */
    uint8_t         loopback_modes_bit_mask;   /* mac | switch | something else  in loopback mode */
    bcm_topo_params topo_params;
    uint32_t        nni_autoneg_bit_mask;      /* NNI autoneg is ON */

    /*
     * IP:Port strings specifying IP:Port assignments of the queues
     * required for IPC between BAL components
     */
    const char *core_mgmt_ip_port;
    const char *balapi_mgmt_ip_port;
    const char *mac_rpc_ip_port;
    const char *sw_rpc_ip;

    /* CLI session configuration */
    bcmcli_access_right access;
    bcmcli_line_edit_mode edit_mode;
    const char *init_script;

    /* Logger parameters */
    bcmos_bool disable_log;
    const char *log_file_name;
    bcmos_bool log_syslog;
} bcmbal_config_params;

extern bcmos_errno bcmbal_init(void);
extern void bcmbal_finish(void);
extern int bcmbal_supported_args_get(cl_argument supported_args[], int size);
extern bcmos_errno bcmbal_cmdline_parse(int argc, char *argv[]);
extern bcmos_errno bcmbal_log_init(void);
extern const bcmbal_config_params *bcmbal_config_get(void);

typedef void (* bcmbal_exit_cb)(void);

/* Top-level initialization sequence
 * - parse commend line
 * - initialize OS abstraction
 * - initialize logger
 * - initialize BAL core and utils
 * - initialize BAL CLI
 */
extern bcmos_errno bcmbal_init_all(int argc, char *argv[], bcmbal_exit_cb exit_cb);

extern bcmos_bool bcmbal_is_mac_in_loopback(void);

extern bcmos_bool bcmbal_is_nni_autoneg_on(bcmbal_intf_id intf_id);

/*@}*/

#endif /*COREMAIN_H*/

