/******************************************************************************
 *
 *  <:copyright-BRCM:2016:DUAL/GPL:standard
 *
 *     Copyright (c) 2016 Broadcom
 *     All Rights Reserved
 *
 *  Unless you and Broadcom execute a separate written software license
 *  agreement governing use of this software, this software is licensed
 *  to you under the terms of the GNU General Public License version 2
 *  (the "GPL"), available at http://www.broadcom.com/licenses/GPLv2.php,
 *  with the following added to such license:
 *
 *     As a special exception, the copyright holders of this software give
 *     you permission to link this software with independent modules, and
 *     to copy and distribute the resulting executable under terms of your
 *     choice, provided that you also meet, for each linked independent
 *     module, the terms and conditions of the license of that module.
 *     An independent module is a module which is not derived from this
 *     software.  The special exception does not apply to any modifications
 *     of the software.
 *
 *  Not withstanding the above, under no circumstances may you combine
 *  this software in any way with any other Broadcom software provided
 *  under a license other than the GPL, without Broadcom's express prior
 *  written consent.
 *
 *  :>
 *
 *****************************************************************************/

/**
 * @file bal_cli_app.c
 * @brief BAL CLI application
 * @addtogroup ctrlr
 */

/*@{*/

#include <bcmos_system.h>
#include <bal_core.h>
#include <bal_cli.h>

#ifdef OMCI_SVC
#include <omci_svc.h>
#include <omci_svc_cli.h>
#endif


/*****************************************************************************/
/**
 * @brief The main entry point for the Bal Core
 *
 *  A function to initialize and start the Bal Core. The user
 *  supplied command line arguments are processed, the internal CLI is
 *  initialized, as are all of the components in the Core.  User input to
 *  the CLI is then processed.  This function does not return until the
 *  user quits the CLI, at which time the BAL core terminates operation.
 *
 *  Errors encountered during the execution of this function are considered
 *  to be fatal.
 *
 * @param argc command line argument count
 *
 * @param argv pointer to command line argument list
 *
 * @returns 0 on success, or -EINVAL when an error is encountered
 *
 *****************************************************************************/
int main(int argc, char *argv[])
{
    bcmos_errno ret;

    do
    {
        /* Init BAL components */
        ret = bcmbal_init_all(argc, argv, NULL);
        if (BCM_ERR_OK != ret)
            break;

        /* Execute init script if any */
        ret = bcmbal_cli_exec_init_script();
        if (BCM_ERR_OK != ret)
            break;

        /* Let everything run until CLI terminates */
        while (!bcmbal_cli_is_terminated())
            bcmos_usleep(1000000);
    }
    while (0);

    /* Cleanup */
    bcmbal_cli_finish();
    bcmbal_finish();
    bcmos_exit();

    return (BCM_ERR_OK == ret) ? 0 : -1;
}


/*@}*/
