// Package desc contains "rich descriptors" for protocol buffers. The built-in
// descriptor types are simple protobuf messages, each one representing a
// different kind of element in the AST of a .proto source file.
//
// Because of this inherent "tree" quality, these build-in descriptors cannot
// refer to their enclosing file descriptor. Nor can a field descriptor refer to
// a message or enum descriptor that represents the field's type (for enum and
// nested message fields). All such links must instead be stringly typed. This
// limitation makes them much harder to use for doing interesting things with
// reflection.
//
// Without this package, resolving references to types is particularly complex.
// For example, resolving a field's type, the message type an extension extends,
// or the request and response types of an RPC method all require searching
// through symbols defined not only in the file in which these elements are
// declared but also in its transitive closure of dependencies.
//
// "Rich descriptors" avoid the need to deal with the complexities described
// above. A rich descriptor has all type references resolved and provides
// methods to access other rich descriptors for all referenced elements. Each
// rich descriptor has a usefully broad API, but does not try to mimic the full
// interface of the underlying descriptor proto. Instead, every rich descriptor
// provides access to that underlying proto, for extracting descriptor
// properties that are not immediately accessible through rich descriptor's
// methods.
//
// Rich descriptors can be accessed in similar ways as their "poor" cousins
// (descriptor protos). Instead of using proto.FileDescriptor, use
// desc.LoadFileDescriptor. Message descriptors and extension field descriptors
// can also be easily accessed using desc.LoadMessageDescriptor and
// desc.LoadFieldDescriptorForExtension, respectively.
//
// It is also possible create rich descriptors for proto messages that a given
// Go program doesn't even know about. For example, they could be loaded from a
// FileDescriptorSet file (which can be generated by protoc) or loaded from a
// server. This enables interesting things like dynamic clients: where a Go
// program can be an RPC client of a service it wasn't compiled to know about.
//
// Also see the grpcreflect, dynamic, and grpcdynamic packages in this same
// repo to see just how useful rich descriptors really are.
package desc
