// Code generated by protoc-gen-go. DO NOT EDIT.
// source: voltha_protos/voltha.proto

package voltha

import (
	context "context"
	fmt "fmt"
	proto "github.com/golang/protobuf/proto"
	empty "github.com/golang/protobuf/ptypes/empty"
	common "github.com/opencord/voltha-protos/v5/go/common"
	extension "github.com/opencord/voltha-protos/v5/go/extension"
	health "github.com/opencord/voltha-protos/v5/go/health"
	omci "github.com/opencord/voltha-protos/v5/go/omci"
	openflow_13 "github.com/opencord/voltha-protos/v5/go/openflow_13"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	math "math"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

// ID from public import voltha_protos/common.proto
type ID = common.ID

// IDs from public import voltha_protos/common.proto
type IDs = common.IDs

// Connection from public import voltha_protos/common.proto
type Connection = common.Connection

// AdminState from public import voltha_protos/common.proto
type AdminState = common.AdminState

// OperStatus from public import voltha_protos/common.proto
type OperStatus = common.OperStatus

// ConnectStatus from public import voltha_protos/common.proto
type ConnectStatus = common.ConnectStatus

// OperationResp from public import voltha_protos/common.proto
type OperationResp = common.OperationResp

// TestModeKeys from public import voltha_protos/common.proto
type TestModeKeys = common.TestModeKeys

var TestModeKeys_name = common.TestModeKeys_name
var TestModeKeys_value = common.TestModeKeys_value

const TestModeKeys_api_test = TestModeKeys(common.TestModeKeys_api_test)

// AdminState_Types from public import voltha_protos/common.proto
type AdminState_Types = common.AdminState_Types

var AdminState_Types_name = common.AdminState_Types_name
var AdminState_Types_value = common.AdminState_Types_value

const AdminState_UNKNOWN = AdminState_Types(common.AdminState_UNKNOWN)
const AdminState_PREPROVISIONED = AdminState_Types(common.AdminState_PREPROVISIONED)
const AdminState_ENABLED = AdminState_Types(common.AdminState_ENABLED)
const AdminState_DISABLED = AdminState_Types(common.AdminState_DISABLED)
const AdminState_DOWNLOADING_IMAGE = AdminState_Types(common.AdminState_DOWNLOADING_IMAGE)

// OperStatus_Types from public import voltha_protos/common.proto
type OperStatus_Types = common.OperStatus_Types

var OperStatus_Types_name = common.OperStatus_Types_name
var OperStatus_Types_value = common.OperStatus_Types_value

const OperStatus_UNKNOWN = OperStatus_Types(common.OperStatus_UNKNOWN)
const OperStatus_DISCOVERED = OperStatus_Types(common.OperStatus_DISCOVERED)
const OperStatus_ACTIVATING = OperStatus_Types(common.OperStatus_ACTIVATING)
const OperStatus_TESTING = OperStatus_Types(common.OperStatus_TESTING)
const OperStatus_ACTIVE = OperStatus_Types(common.OperStatus_ACTIVE)
const OperStatus_FAILED = OperStatus_Types(common.OperStatus_FAILED)
const OperStatus_RECONCILING = OperStatus_Types(common.OperStatus_RECONCILING)
const OperStatus_RECONCILING_FAILED = OperStatus_Types(common.OperStatus_RECONCILING_FAILED)
const OperStatus_REBOOTED = OperStatus_Types(common.OperStatus_REBOOTED)

// ConnectStatus_Types from public import voltha_protos/common.proto
type ConnectStatus_Types = common.ConnectStatus_Types

var ConnectStatus_Types_name = common.ConnectStatus_Types_name
var ConnectStatus_Types_value = common.ConnectStatus_Types_value

const ConnectStatus_UNKNOWN = ConnectStatus_Types(common.ConnectStatus_UNKNOWN)
const ConnectStatus_UNREACHABLE = ConnectStatus_Types(common.ConnectStatus_UNREACHABLE)
const ConnectStatus_REACHABLE = ConnectStatus_Types(common.ConnectStatus_REACHABLE)

// OperationResp_OperationReturnCode from public import voltha_protos/common.proto
type OperationResp_OperationReturnCode = common.OperationResp_OperationReturnCode

var OperationResp_OperationReturnCode_name = common.OperationResp_OperationReturnCode_name
var OperationResp_OperationReturnCode_value = common.OperationResp_OperationReturnCode_value

const OperationResp_OPERATION_SUCCESS = OperationResp_OperationReturnCode(common.OperationResp_OPERATION_SUCCESS)
const OperationResp_OPERATION_FAILURE = OperationResp_OperationReturnCode(common.OperationResp_OPERATION_FAILURE)
const OperationResp_OPERATION_UNSUPPORTED = OperationResp_OperationReturnCode(common.OperationResp_OPERATION_UNSUPPORTED)
const OperationResp_OPERATION_IN_PROGRESS = OperationResp_OperationReturnCode(common.OperationResp_OPERATION_IN_PROGRESS)

// CoreInstance represents a core instance.  It is data held in memory when a core
// is running.  This data is not persistent.
type CoreInstance struct {
	InstanceId           string               `protobuf:"bytes,1,opt,name=instance_id,json=instanceId,proto3" json:"instance_id,omitempty"`
	Health               *health.HealthStatus `protobuf:"bytes,2,opt,name=health,proto3" json:"health,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *CoreInstance) Reset()         { *m = CoreInstance{} }
func (m *CoreInstance) String() string { return proto.CompactTextString(m) }
func (*CoreInstance) ProtoMessage()    {}
func (*CoreInstance) Descriptor() ([]byte, []int) {
	return fileDescriptor_e084f1a60ce7016c, []int{0}
}

func (m *CoreInstance) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CoreInstance.Unmarshal(m, b)
}
func (m *CoreInstance) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CoreInstance.Marshal(b, m, deterministic)
}
func (m *CoreInstance) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CoreInstance.Merge(m, src)
}
func (m *CoreInstance) XXX_Size() int {
	return xxx_messageInfo_CoreInstance.Size(m)
}
func (m *CoreInstance) XXX_DiscardUnknown() {
	xxx_messageInfo_CoreInstance.DiscardUnknown(m)
}

var xxx_messageInfo_CoreInstance proto.InternalMessageInfo

func (m *CoreInstance) GetInstanceId() string {
	if m != nil {
		return m.InstanceId
	}
	return ""
}

func (m *CoreInstance) GetHealth() *health.HealthStatus {
	if m != nil {
		return m.Health
	}
	return nil
}

type CoreInstances struct {
	Items                []*CoreInstance `protobuf:"bytes,1,rep,name=items,proto3" json:"items,omitempty"`
	XXX_NoUnkeyedLiteral struct{}        `json:"-"`
	XXX_unrecognized     []byte          `json:"-"`
	XXX_sizecache        int32           `json:"-"`
}

func (m *CoreInstances) Reset()         { *m = CoreInstances{} }
func (m *CoreInstances) String() string { return proto.CompactTextString(m) }
func (*CoreInstances) ProtoMessage()    {}
func (*CoreInstances) Descriptor() ([]byte, []int) {
	return fileDescriptor_e084f1a60ce7016c, []int{1}
}

func (m *CoreInstances) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CoreInstances.Unmarshal(m, b)
}
func (m *CoreInstances) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CoreInstances.Marshal(b, m, deterministic)
}
func (m *CoreInstances) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CoreInstances.Merge(m, src)
}
func (m *CoreInstances) XXX_Size() int {
	return xxx_messageInfo_CoreInstances.Size(m)
}
func (m *CoreInstances) XXX_DiscardUnknown() {
	xxx_messageInfo_CoreInstances.DiscardUnknown(m)
}

var xxx_messageInfo_CoreInstances proto.InternalMessageInfo

func (m *CoreInstances) GetItems() []*CoreInstance {
	if m != nil {
		return m.Items
	}
	return nil
}

// Voltha represents the Voltha cluster data.  Each Core instance will hold a subset of
// the entire cluster. However, some items (e.g. adapters) will be held by all cores
// for better performance
type Voltha struct {
	Version              string                  `protobuf:"bytes,1,opt,name=version,proto3" json:"version,omitempty"`
	Adapters             []*Adapter              `protobuf:"bytes,2,rep,name=adapters,proto3" json:"adapters,omitempty"`
	LogicalDevices       []*LogicalDevice        `protobuf:"bytes,3,rep,name=logical_devices,json=logicalDevices,proto3" json:"logical_devices,omitempty"`
	Devices              []*Device               `protobuf:"bytes,4,rep,name=devices,proto3" json:"devices,omitempty"`
	DeviceTypes          []*DeviceType           `protobuf:"bytes,5,rep,name=device_types,json=deviceTypes,proto3" json:"device_types,omitempty"`
	EventFilters         []*EventFilter          `protobuf:"bytes,7,rep,name=event_filters,json=eventFilters,proto3" json:"event_filters,omitempty"`
	OmciMibDatabase      []*omci.MibDeviceData   `protobuf:"bytes,28,rep,name=omci_mib_database,json=omciMibDatabase,proto3" json:"omci_mib_database,omitempty"`
	OmciAlarmDatabase    []*omci.AlarmDeviceData `protobuf:"bytes,29,rep,name=omci_alarm_database,json=omciAlarmDatabase,proto3" json:"omci_alarm_database,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                `json:"-"`
	XXX_unrecognized     []byte                  `json:"-"`
	XXX_sizecache        int32                   `json:"-"`
}

func (m *Voltha) Reset()         { *m = Voltha{} }
func (m *Voltha) String() string { return proto.CompactTextString(m) }
func (*Voltha) ProtoMessage()    {}
func (*Voltha) Descriptor() ([]byte, []int) {
	return fileDescriptor_e084f1a60ce7016c, []int{2}
}

func (m *Voltha) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Voltha.Unmarshal(m, b)
}
func (m *Voltha) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Voltha.Marshal(b, m, deterministic)
}
func (m *Voltha) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Voltha.Merge(m, src)
}
func (m *Voltha) XXX_Size() int {
	return xxx_messageInfo_Voltha.Size(m)
}
func (m *Voltha) XXX_DiscardUnknown() {
	xxx_messageInfo_Voltha.DiscardUnknown(m)
}

var xxx_messageInfo_Voltha proto.InternalMessageInfo

func (m *Voltha) GetVersion() string {
	if m != nil {
		return m.Version
	}
	return ""
}

func (m *Voltha) GetAdapters() []*Adapter {
	if m != nil {
		return m.Adapters
	}
	return nil
}

func (m *Voltha) GetLogicalDevices() []*LogicalDevice {
	if m != nil {
		return m.LogicalDevices
	}
	return nil
}

func (m *Voltha) GetDevices() []*Device {
	if m != nil {
		return m.Devices
	}
	return nil
}

func (m *Voltha) GetDeviceTypes() []*DeviceType {
	if m != nil {
		return m.DeviceTypes
	}
	return nil
}

func (m *Voltha) GetEventFilters() []*EventFilter {
	if m != nil {
		return m.EventFilters
	}
	return nil
}

func (m *Voltha) GetOmciMibDatabase() []*omci.MibDeviceData {
	if m != nil {
		return m.OmciMibDatabase
	}
	return nil
}

func (m *Voltha) GetOmciAlarmDatabase() []*omci.AlarmDeviceData {
	if m != nil {
		return m.OmciAlarmDatabase
	}
	return nil
}

func init() {
	proto.RegisterType((*CoreInstance)(nil), "voltha.CoreInstance")
	proto.RegisterType((*CoreInstances)(nil), "voltha.CoreInstances")
	proto.RegisterType((*Voltha)(nil), "voltha.Voltha")
}

func init() { proto.RegisterFile("voltha_protos/voltha.proto", fileDescriptor_e084f1a60ce7016c) }

var fileDescriptor_e084f1a60ce7016c = []byte{
	// 2130 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xc4, 0x59, 0xeb, 0x6e, 0x1b, 0xb9,
	0x15, 0xde, 0x71, 0x76, 0x73, 0xa1, 0x25, 0xdb, 0xa2, 0x7c, 0x91, 0x25, 0xf9, 0xc6, 0x64, 0xb3,
	0x5e, 0x25, 0x91, 0x92, 0x38, 0xd9, 0xb6, 0xd9, 0x2e, 0x0a, 0xaf, 0x6f, 0xf5, 0x36, 0x81, 0x0d,
	0x29, 0x71, 0xda, 0x62, 0xb3, 0xc2, 0x48, 0x43, 0xcb, 0x83, 0x8e, 0x66, 0xd4, 0x21, 0x65, 0x27,
	0x30, 0xf6, 0x4f, 0x2f, 0x40, 0x8a, 0xa2, 0xe8, 0x8f, 0x7d, 0x8b, 0x3e, 0x45, 0xff, 0xf5, 0x01,
	0xfa, 0x0a, 0x7d, 0x90, 0x82, 0x87, 0xa4, 0x3c, 0xd4, 0xcc, 0xc8, 0x56, 0xba, 0x40, 0xff, 0x58,
	0x26, 0x0f, 0xf9, 0x7d, 0x1f, 0xcf, 0x39, 0xbc, 0x0e, 0x2a, 0x9e, 0x06, 0x1e, 0x3f, 0xb1, 0x9b,
	0xbd, 0x30, 0xe0, 0x01, 0xab, 0xc9, 0x52, 0x15, 0x4a, 0xf8, 0xba, 0x2c, 0x15, 0xcb, 0x9d, 0x20,
	0xe8, 0x78, 0xb4, 0x66, 0xf7, 0xdc, 0x9a, 0xed, 0xfb, 0x01, 0xb7, 0xb9, 0x1b, 0xf8, 0x4c, 0xb6,
	0x2a, 0x96, 0x94, 0x15, 0x4a, 0xad, 0xfe, 0x71, 0x8d, 0x76, 0x7b, 0xfc, 0x9d, 0x32, 0x0e, 0xc1,
	0xb7, 0x83, 0x6e, 0x37, 0xf0, 0x93, 0x6d, 0x27, 0xd4, 0xf6, 0xf8, 0x89, 0xb2, 0x11, 0xd3, 0xe6,
	0x05, 0x1d, 0xb7, 0x6d, 0x7b, 0x4d, 0x87, 0x9e, 0xba, 0x6d, 0x9a, 0xdc, 0xdf, 0xb0, 0x95, 0x4c,
	0x9b, 0xed, 0xd8, 0x3d, 0x4e, 0x43, 0x65, 0x5c, 0x31, 0x8d, 0x41, 0x8f, 0xfa, 0xc7, 0x5e, 0x70,
	0xd6, 0x7c, 0xb4, 0x91, 0x8c, 0x4c, 0x4f, 0xa9, 0xcf, 0xf5, 0x70, 0x97, 0x87, 0x6c, 0x6f, 0x39,
	0xf5, 0x59, 0xc4, 0x1d, 0xc3, 0xe0, 0xdd, 0xb6, 0xdb, 0xec, 0xba, 0xad, 0xa6, 0xd3, 0x52, 0x0d,
	0xd6, 0x12, 0x1a, 0xd8, 0x9e, 0x1d, 0x76, 0x2f, 0x9a, 0x2c, 0x25, 0x34, 0xe1, 0x94, 0x71, 0x69,
	0x26, 0x6f, 0x50, 0x66, 0x2b, 0x08, 0xe9, 0xbe, 0xcf, 0xb8, 0xed, 0xb7, 0x29, 0x5e, 0x41, 0x93,
	0xae, 0xfa, 0xbf, 0xe9, 0x3a, 0x05, 0x6b, 0xd5, 0x5a, 0xbf, 0x55, 0x47, 0xba, 0x6a, 0xdf, 0xc1,
	0xf7, 0xd1, 0x75, 0xe9, 0xdd, 0xc2, 0xc4, 0xaa, 0xb5, 0x3e, 0xf9, 0x78, 0xb6, 0xaa, 0x9c, 0xfd,
	0x4b, 0xf8, 0x69, 0x70, 0x9b, 0xf7, 0x59, 0x5d, 0xb5, 0x21, 0x5f, 0xa2, 0x6c, 0x14, 0x9e, 0xe1,
	0x0a, 0xfa, 0xc4, 0xe5, 0xb4, 0xcb, 0x0a, 0xd6, 0xea, 0x35, 0xe8, 0xad, 0xb2, 0x24, 0xda, 0xaa,
	0x2e, 0x9b, 0x90, 0x7f, 0x5e, 0x43, 0xd7, 0x8f, 0xc0, 0x8c, 0x0b, 0xe8, 0xc6, 0x29, 0x0d, 0x85,
	0x6f, 0x94, 0x24, 0x5d, 0xc4, 0xf7, 0xd1, 0x4d, 0x15, 0x11, 0x56, 0x98, 0x00, 0xcc, 0x99, 0xaa,
	0x0e, 0xd1, 0xa6, 0xfc, 0xad, 0x0f, 0x5a, 0xe0, 0x5d, 0x34, 0x6d, 0xc6, 0x9f, 0x15, 0xae, 0x41,
	0xa7, 0xa5, 0xea, 0x50, 0x5e, 0x3c, 0x97, 0xc5, 0x6d, 0x28, 0xd5, 0xa7, 0xbc, 0x68, 0x91, 0xe1,
	0x75, 0x74, 0x43, 0xf7, 0xff, 0x18, 0xfa, 0x4f, 0x55, 0x55, 0x3f, 0xd5, 0x41, 0x9b, 0xf1, 0x53,
	0x94, 0x91, 0xff, 0x36, 0xf9, 0xbb, 0x1e, 0x65, 0x85, 0x4f, 0xa0, 0x39, 0x36, 0x9b, 0xbf, 0x7c,
	0xd7, 0xa3, 0xf5, 0x49, 0x67, 0xf0, 0x3f, 0xc3, 0x3f, 0x41, 0x59, 0x48, 0x95, 0xe6, 0xb1, 0xeb,
	0xc1, 0xd8, 0x6e, 0xa8, 0x7e, 0x50, 0x5b, 0xdd, 0x11, 0x7f, 0x77, 0xc1, 0x54, 0xcf, 0xd0, 0x8b,
	0x02, 0xc3, 0xbf, 0x40, 0xb9, 0x8b, 0x3c, 0xb1, 0xb9, 0xdd, 0xb2, 0x19, 0x2d, 0x94, 0xa1, 0x73,
	0xbe, 0x2a, 0x2c, 0xd5, 0x17, 0x6e, 0x4b, 0xb2, 0x6e, 0xdb, 0xdc, 0xae, 0x4f, 0x8b, 0x3a, 0x51,
	0xa5, 0xda, 0xe2, 0x1d, 0x94, 0x8f, 0xe6, 0x91, 0x86, 0x58, 0x02, 0x88, 0x39, 0x09, 0xb1, 0x29,
	0x6c, 0x11, 0x10, 0xa0, 0x94, 0x95, 0xaa, 0xfd, 0x37, 0x1f, 0xdf, 0xbc, 0x3e, 0x73, 0xe3, 0xf1,
	0xbf, 0x36, 0x50, 0x56, 0x86, 0xb0, 0x41, 0x43, 0xd1, 0x1c, 0x6f, 0xa3, 0x5b, 0x7b, 0x94, 0xab,
	0xb0, 0xce, 0x57, 0xe5, 0x84, 0xaf, 0xea, 0x09, 0x5f, 0xdd, 0x11, 0x13, 0xbe, 0x38, 0xa5, 0xd3,
	0x42, 0xb6, 0x23, 0xd3, 0x7f, 0xf8, 0xf7, 0x7f, 0x7e, 0x98, 0xb8, 0x85, 0x6f, 0xc0, 0xba, 0x71,
	0xfa, 0x08, 0xbf, 0x41, 0xb9, 0xe7, 0x2e, 0xe3, 0x66, 0x6e, 0xa5, 0xa1, 0xcd, 0x25, 0x25, 0x19,
	0x23, 0x8b, 0x00, 0x9a, 0xc7, 0x39, 0x05, 0x5a, 0x73, 0x07, 0x48, 0x0d, 0x34, 0xbd, 0x47, 0x0d,
	0x74, 0x8c, 0xaa, 0x6a, 0xc1, 0xd9, 0xdf, 0x2e, 0x26, 0x66, 0x2d, 0x59, 0x06, 0xbc, 0x02, 0x9e,
	0x8f, 0xe1, 0xd5, 0xce, 0x5d, 0xe7, 0x7b, 0xdc, 0x40, 0x19, 0xa1, 0x79, 0x53, 0xe7, 0x62, 0x9a,
	0xdc, 0xdc, 0x70, 0xfe, 0x32, 0x52, 0x00, 0x68, 0x8c, 0x67, 0x34, 0xf4, 0x20, 0xa1, 0xbb, 0x08,
	0x0b, 0xd0, 0xe7, 0x66, 0x7a, 0xa6, 0x41, 0x2f, 0x8f, 0xcc, 0x72, 0x46, 0x56, 0x80, 0x67, 0x11,
	0x2f, 0x68, 0x9e, 0xa1, 0xc9, 0x82, 0xdb, 0x68, 0x66, 0x8f, 0x9a, 0x6c, 0x86, 0x67, 0x46, 0x4f,
	0x23, 0x72, 0x07, 0xf0, 0x97, 0x71, 0x39, 0x05, 0x5f, 0x3a, 0xca, 0x47, 0xf3, 0xb1, 0x31, 0x1d,
	0x06, 0x21, 0x67, 0x06, 0x55, 0x39, 0x85, 0x0a, 0x5a, 0x92, 0x0a, 0x30, 0xdd, 0xc1, 0x64, 0x14,
	0x53, 0xad, 0x07, 0xa8, 0xef, 0x2d, 0x34, 0x3b, 0x3c, 0x2a, 0x81, 0x82, 0x97, 0x46, 0x50, 0xec,
	0x3b, 0xc5, 0xd2, 0x08, 0x33, 0x79, 0x02, 0x02, 0xaa, 0xf8, 0xfe, 0xe5, 0x02, 0x6a, 0xe7, 0xe2,
	0xa7, 0x29, 0x86, 0xfe, 0x37, 0x0b, 0x2d, 0xec, 0xf8, 0x76, 0xcb, 0xa3, 0x63, 0xab, 0x49, 0x89,
	0x39, 0xf9, 0x12, 0x84, 0x3c, 0x25, 0x1b, 0xe3, 0x08, 0xa9, 0x51, 0x10, 0x81, 0xff, 0x6e, 0xa1,
	0xc2, 0xb6, 0xcb, 0x7e, 0x54, 0x41, 0x3f, 0x07, 0x41, 0x5f, 0x90, 0x27, 0x63, 0x09, 0x72, 0xa4,
	0x0a, 0xec, 0x24, 0x24, 0xc7, 0xae, 0x17, 0x9c, 0x99, 0xc9, 0x81, 0xab, 0xd1, 0x9d, 0x18, 0xec,
	0x57, 0x4c, 0x89, 0x63, 0xc0, 0xfa, 0xa3, 0x85, 0xca, 0xaf, 0x7a, 0x8e, 0xcd, 0x69, 0x8c, 0xe8,
	0x25, 0xc8, 0x28, 0xc7, 0x08, 0xa0, 0x5e, 0xf6, 0x49, 0x1d, 0xfa, 0x03, 0x90, 0xf0, 0x19, 0xb9,
	0x82, 0x84, 0x67, 0x56, 0x05, 0xff, 0xc9, 0x42, 0x4b, 0x09, 0x2a, 0x5e, 0x50, 0x4e, 0x43, 0x29,
	0xa3, 0x64, 0xc8, 0x00, 0xc3, 0x8b, 0xc0, 0xb9, 0x44, 0x45, 0x15, 0x54, 0xac, 0x93, 0xdb, 0x23,
	0x55, 0x74, 0x05, 0x18, 0xc8, 0xe8, 0xa0, 0x85, 0x98, 0xcb, 0x81, 0xca, 0xf4, 0x79, 0x3e, 0xae,
	0x85, 0x91, 0x7b, 0xc0, 0xf5, 0x29, 0xbe, 0x0a, 0x17, 0xe6, 0xa8, 0x94, 0x18, 0xdb, 0xbd, 0x30,
	0xe8, 0xf7, 0x4c, 0xb2, 0x85, 0x98, 0xff, 0x65, 0x23, 0xf2, 0x10, 0x08, 0x2b, 0x78, 0xfd, 0x52,
	0x17, 0x37, 0x3b, 0x12, 0xf6, 0x07, 0x0b, 0xad, 0xa5, 0xc4, 0x1a, 0x30, 0xa5, 0xa7, 0xd7, 0x92,
	0x09, 0xaf, 0x12, 0xf5, 0x0d, 0x90, 0xf4, 0x80, 0x5c, 0x59, 0x92, 0x70, 0xfa, 0x01, 0x9a, 0x14,
	0xbe, 0xb8, 0x6c, 0x45, 0x9f, 0x36, 0x0f, 0x12, 0x8c, 0x2c, 0x00, 0x59, 0x0e, 0x4f, 0x6b, 0x32,
	0xbd, 0x74, 0x1f, 0xa0, 0xec, 0x05, 0xe0, 0xbe, 0x93, 0x0e, 0x39, 0x79, 0xe1, 0xe6, 0x84, 0x4d,
	0x52, 0xc2, 0xb9, 0x0e, 0xc3, 0xaf, 0xd0, 0x4c, 0x9d, 0xb6, 0x03, 0xbf, 0xed, 0x7a, 0x54, 0xcb,
	0x8c, 0xf6, 0x4d, 0xf5, 0x47, 0x19, 0x30, 0xe7, 0x49, 0x1c, 0x53, 0x0c, 0x7c, 0x07, 0x0e, 0x08,
	0x09, 0x7b, 0xcb, 0xd0, 0x11, 0x4b, 0xc3, 0xe0, 0xd9, 0xa1, 0x91, 0xca, 0x4d, 0xe4, 0x1b, 0x94,
	0xd9, 0x0a, 0xa9, 0xcd, 0x95, 0x34, 0x3c, 0xd4, 0x3b, 0x86, 0x56, 0x04, 0xb4, 0x59, 0x32, 0xec,
	0x37, 0x21, 0xe9, 0x35, 0xca, 0xc8, 0x45, 0x39, 0x41, 0x55, 0xda, 0x20, 0x6f, 0x03, 0xde, 0x12,
	0x29, 0x25, 0xa9, 0xd3, 0xcb, 0xeb, 0x6f, 0x50, 0x56, 0xad, 0xae, 0x63, 0x20, 0xab, 0x4d, 0x94,
	0x94, 0x13, 0x91, 0xf5, 0x3a, 0xf9, 0x1a, 0x65, 0xea, 0xb4, 0x15, 0x04, 0xfc, 0x47, 0xd3, 0x1c,
	0x02, 0x9c, 0x00, 0xde, 0xa6, 0x1e, 0xe5, 0x1f, 0xe0, 0x8c, 0x4a, 0x32, 0xb0, 0x03, 0x70, 0xb8,
	0x85, 0x72, 0xbb, 0x41, 0xd8, 0xa6, 0x63, 0xa3, 0x7f, 0x0e, 0xe8, 0xb7, 0x2b, 0x6b, 0x89, 0xe8,
	0xc7, 0x02, 0xb3, 0xa9, 0x38, 0xde, 0xa2, 0xec, 0x76, 0x70, 0xe6, 0x7b, 0x81, 0xed, 0xec, 0x77,
	0xed, 0x0e, 0xc5, 0x73, 0x3a, 0x0d, 0xa0, 0xa8, 0x6d, 0xc5, 0x39, 0x4d, 0x7b, 0xd0, 0xa3, 0x21,
	0x5c, 0x51, 0xeb, 0x94, 0xf5, 0xc8, 0xcf, 0x80, 0xe9, 0x21, 0xb9, 0x97, 0xc8, 0xe4, 0x0a, 0x88,
	0xa6, 0xa3, 0x30, 0x58, 0xed, 0xdc, 0xb7, 0xbb, 0xf4, 0xfb, 0x67, 0x56, 0xe5, 0xfd, 0x84, 0x85,
	0xff, 0x6c, 0xa1, 0xf9, 0x3d, 0xca, 0x0d, 0x1a, 0x79, 0x59, 0x4a, 0xd7, 0x90, 0x54, 0x4d, 0xbe,
	0x02, 0x0d, 0x4f, 0xf0, 0xe3, 0x31, 0x34, 0xd4, 0x18, 0x30, 0x09, 0x1d, 0x6f, 0xe1, 0x04, 0x67,
	0x40, 0x8e, 0x29, 0xe0, 0x0b, 0xb9, 0x9c, 0xe1, 0x71, 0x9c, 0x20, 0x98, 0x5d, 0x79, 0x54, 0x35,
	0xc0, 0xd8, 0x50, 0x80, 0x93, 0x08, 0x19, 0xa9, 0x01, 0xe3, 0x5d, 0x7c, 0xe7, 0x2a, 0x8c, 0x82,
	0xea, 0x1c, 0xe5, 0xb7, 0xc4, 0xc9, 0xdb, 0xbb, 0xe2, 0x38, 0x13, 0x83, 0xad, 0xc6, 0x59, 0x19,
	0x77, 0x9c, 0x7f, 0xb5, 0x50, 0x7e, 0xb3, 0xcd, 0xdd, 0x53, 0x9b, 0x53, 0x20, 0x92, 0xdb, 0xc3,
	0x98, 0xec, 0xbb, 0xc0, 0xfe, 0x15, 0xf9, 0xe9, 0x38, 0x61, 0x96, 0xd5, 0x7d, 0xe0, 0x53, 0x79,
	0xf7, 0x17, 0x0b, 0xe5, 0xea, 0xf4, 0x94, 0x86, 0xfc, 0xff, 0xa2, 0x25, 0x04, 0x6a, 0xa5, 0xe5,
	0xbd, 0x85, 0xe6, 0x8c, 0xe9, 0xf7, 0x32, 0x50, 0xd3, 0x9c, 0x98, 0xab, 0xb1, 0xa1, 0xaa, 0x4e,
	0x7f, 0xdf, 0xa7, 0x8c, 0x17, 0x4b, 0x09, 0x6d, 0x84, 0xbc, 0xc0, 0x67, 0x54, 0x9f, 0x69, 0xf0,
	0xdd, 0x61, 0x89, 0x20, 0x83, 0xd5, 0xb4, 0xbc, 0xa6, 0x2c, 0xe3, 0x33, 0x34, 0xa5, 0xa7, 0x81,
	0x9a, 0x85, 0xc5, 0x44, 0xf8, 0x2b, 0x50, 0xdf, 0x4f, 0xcb, 0x4e, 0x45, 0x2d, 0x7f, 0x9a, 0x72,
	0x0a, 0x8a, 0x78, 0x2c, 0x6e, 0xb6, 0x82, 0x41, 0x38, 0x3a, 0xa1, 0xed, 0x5c, 0xf8, 0xe1, 0x83,
	0x45, 0x6c, 0xa4, 0x4d, 0x4a, 0x25, 0xc2, 0x16, 0x94, 0xcd, 0xbe, 0xa4, 0xd3, 0x4e, 0x38, 0x42,
	0x99, 0x3d, 0xca, 0x0f, 0xfc, 0xfe, 0xbe, 0x2c, 0x47, 0xe7, 0x62, 0x4e, 0xb3, 0x0d, 0xcc, 0xe4,
	0x33, 0xe0, 0x58, 0xc3, 0x2b, 0x89, 0x69, 0x10, 0xf8, 0x7d, 0x8d, 0x7b, 0x8e, 0xb2, 0xc6, 0x04,
	0xf8, 0xf0, 0x61, 0x3d, 0x02, 0xca, 0x7b, 0x24, 0x2d, 0xac, 0xb6, 0xa2, 0x51, 0xcc, 0x62, 0xb3,
	0x3e, 0x43, 0x93, 0x5b, 0x41, 0xb7, 0xeb, 0xf2, 0xff, 0x91, 0x5a, 0x2e, 0x3a, 0x9f, 0x93, 0xb4,
	0xb0, 0xb6, 0x81, 0x24, 0x42, 0x7c, 0x88, 0xa6, 0x2f, 0x0e, 0x58, 0xf1, 0xfb, 0x6a, 0x56, 0x93,
	0xc9, 0x0b, 0x2a, 0x01, 0xf8, 0x32, 0x2e, 0x26, 0x3a, 0x53, 0x5e, 0x4c, 0xdf, 0xa0, 0x7c, 0x04,
	0xb1, 0xbb, 0x15, 0xf8, 0xc7, 0x6e, 0x27, 0x25, 0x4c, 0x03, 0xf3, 0x25, 0x61, 0xea, 0x75, 0x9b,
	0x6d, 0x85, 0xe3, 0xa3, 0x39, 0xb9, 0x1c, 0x0c, 0x13, 0xc4, 0x41, 0x53, 0xf7, 0x5e, 0x75, 0xa9,
	0x22, 0x97, 0x91, 0x09, 0x07, 0xbd, 0x8a, 0x3a, 0xe8, 0x6a, 0x77, 0xb6, 0xd1, 0x5e, 0x92, 0x77,
	0x35, 0x8a, 0x66, 0x4d, 0xd8, 0x71, 0xae, 0x0b, 0xeb, 0x40, 0x40, 0xf0, 0x6a, 0x2a, 0x81, 0xbe,
	0x26, 0x7c, 0x1b, 0x55, 0x2f, 0x1f, 0xe9, 0xd2, 0x4e, 0xd0, 0xf9, 0xf8, 0xeb, 0x1e, 0x4b, 0x3b,
	0xae, 0xca, 0x67, 0x41, 0x5c, 0x47, 0xd9, 0xc1, 0xa9, 0x57, 0xb4, 0x1f, 0xf2, 0x4c, 0x0c, 0x8f,
	0xac, 0x01, 0x5c, 0x09, 0x2f, 0x26, 0xc1, 0xc9, 0x23, 0xf0, 0x2e, 0x9a, 0x69, 0xf0, 0x90, 0xda,
	0xdd, 0x43, 0xbb, 0xfd, 0x3b, 0xca, 0xd9, 0x41, 0x9f, 0xe3, 0x79, 0xc3, 0x11, 0xd2, 0x70, 0xd0,
	0xe7, 0xa9, 0xf1, 0xfd, 0x68, 0xdd, 0xc2, 0x3b, 0x70, 0xd0, 0xa7, 0xee, 0x29, 0x55, 0x40, 0xfb,
	0xfe, 0x88, 0xb7, 0xb6, 0x38, 0xfe, 0xbe, 0x4f, 0x3e, 0x7a, 0x68, 0xe1, 0x5f, 0xa1, 0xbc, 0x82,
	0xd9, 0x3a, 0xb1, 0xfd, 0x0e, 0x85, 0x37, 0xcc, 0x74, 0x27, 0x16, 0x0c, 0xa4, 0x48, 0x17, 0x00,
	0x7b, 0x83, 0x72, 0xf2, 0x78, 0x1f, 0x79, 0x09, 0xc5, 0x09, 0xaf, 0xa3, 0xc5, 0x84, 0x3a, 0xb2,
	0x0a, 0xbe, 0x2b, 0x92, 0x39, 0xed, 0x3b, 0xe3, 0xa9, 0x55, 0xa6, 0xaa, 0xd8, 0x1e, 0xa2, 0xd8,
	0xe6, 0x4d, 0x37, 0x86, 0x99, 0x90, 0xaa, 0x06, 0xa8, 0x8c, 0x48, 0x0b, 0xe5, 0xe4, 0x8c, 0xfb,
	0x10, 0xd5, 0x9f, 0x02, 0xc1, 0x4a, 0x71, 0x04, 0x81, 0x90, 0xde, 0x46, 0x39, 0x79, 0x82, 0xbe,
	0x8c, 0x23, 0x2d, 0xe4, 0x6a, 0x20, 0x95, 0x51, 0x03, 0xf9, 0x0e, 0xcd, 0x88, 0xc9, 0x10, 0x75,
	0xc0, 0x88, 0xd9, 0x90, 0xe0, 0xad, 0x25, 0x20, 0x59, 0xc0, 0xc9, 0x21, 0xc0, 0xcf, 0xe1, 0x12,
	0x98, 0xb0, 0x2d, 0x4d, 0x19, 0x07, 0x17, 0xa6, 0x6f, 0x16, 0xb8, 0x94, 0x7e, 0x34, 0x61, 0xf8,
	0xd7, 0xe8, 0x66, 0x83, 0x7a, 0xc7, 0x2f, 0x29, 0xe3, 0x06, 0x58, 0x41, 0x83, 0x69, 0xeb, 0x60,
	0xf1, 0xbf, 0x0b, 0xb0, 0xab, 0x64, 0x39, 0x11, 0x96, 0x51, 0xef, 0x18, 0x3e, 0xa2, 0xe0, 0x23,
	0x38, 0x4d, 0x1b, 0x2f, 0xea, 0xc3, 0x6f, 0x22, 0xb1, 0x27, 0xf7, 0xf8, 0xd4, 0x15, 0x89, 0x2e,
	0xda, 0xa9, 0xc7, 0x10, 0xb7, 0x85, 0xbf, 0x45, 0x78, 0x8f, 0xf2, 0xa1, 0x67, 0x76, 0x03, 0x39,
	0xf9, 0x25, 0x3e, 0xee, 0x0f, 0x13, 0x1b, 0x1e, 0xf5, 0x31, 0x43, 0xd9, 0x86, 0xdb, 0xed, 0x7b,
	0x36, 0xa7, 0xd0, 0x1f, 0x97, 0x07, 0x8e, 0x88, 0x56, 0xeb, 0x6d, 0x32, 0xe5, 0x54, 0x18, 0x7b,
	0xcc, 0x32, 0x7d, 0xa4, 0x90, 0x9a, 0x02, 0x49, 0xe4, 0xe5, 0x0b, 0x84, 0xe4, 0x25, 0x1a, 0xde,
	0x0e, 0x33, 0xd1, 0xdd, 0x30, 0x35, 0x15, 0xd5, 0xeb, 0x03, 0x99, 0x12, 0xf0, 0x17, 0xbd, 0xd5,
	0xfb, 0x88, 0xba, 0x3a, 0x8f, 0x81, 0x77, 0x71, 0xc9, 0x3f, 0x7d, 0x54, 0x8b, 0x74, 0x17, 0x80,
	0xdf, 0xa1, 0x49, 0x31, 0xe5, 0xdf, 0xf2, 0x23, 0xdb, 0xeb, 0x53, 0xbc, 0x58, 0x1d, 0x7c, 0x8e,
	0xab, 0x42, 0x4d, 0xa3, 0x47, 0xdb, 0xee, 0xb1, 0x4b, 0xc3, 0xe2, 0x42, 0xc4, 0x54, 0xa7, 0xbc,
	0x1f, 0xfa, 0xd0, 0x80, 0x91, 0x12, 0xc0, 0xcf, 0xe1, 0xbc, 0xf6, 0x48, 0x14, 0xf0, 0x35, 0x9a,
	0x6c, 0x44, 0x8a, 0xf9, 0x18, 0x3e, 0x4d, 0xd7, 0x1d, 0x03, 0x8e, 0x22, 0x39, 0x28, 0xdf, 0xe0,
	0x76, 0xc8, 0x0f, 0xba, 0x6d, 0x57, 0x24, 0xb1, 0x38, 0x7a, 0x05, 0x3e, 0x56, 0x09, 0xa2, 0x6b,
	0x75, 0x30, 0xb1, 0xac, 0x36, 0xb2, 0x5d, 0xcd, 0x78, 0x32, 0x78, 0xf6, 0x67, 0x02, 0xaf, 0x39,
	0xf8, 0x56, 0xf8, 0xcc, 0xaa, 0x7c, 0xed, 0xa1, 0x7c, 0x10, 0x76, 0x60, 0x4d, 0x6e, 0x07, 0xa1,
	0xa3, 0xbe, 0x80, 0x7c, 0x9d, 0x91, 0x5f, 0x68, 0x0e, 0xe1, 0xeb, 0xe2, 0x6f, 0xab, 0x1d, 0x97,
	0x9f, 0xf4, 0x5b, 0x22, 0x5f, 0x6a, 0xba, 0xa5, 0xfa, 0x0e, 0xfc, 0x40, 0x7f, 0x15, 0x7e, 0x5a,
	0xeb, 0x04, 0xaa, 0xee, 0x1f, 0x13, 0xf3, 0x07, 0x1a, 0xef, 0x28, 0xfa, 0xc1, 0xe7, 0x70, 0xa2,
	0x75, 0x1d, 0xda, 0x6f, 0xfc, 0x37, 0x00, 0x00, 0xff, 0xff, 0x37, 0x95, 0xcc, 0x79, 0x55, 0x1e,
	0x00, 0x00,
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// VolthaServiceClient is the client API for VolthaService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type VolthaServiceClient interface {
	// Get high level information on the Voltha cluster
	GetVoltha(ctx context.Context, in *empty.Empty, opts ...grpc.CallOption) (*Voltha, error)
	// List all Voltha cluster core instances
	ListCoreInstances(ctx context.Context, in *empty.Empty, opts ...grpc.CallOption) (*CoreInstances, error)
	// Get details on a Voltha cluster instance
	GetCoreInstance(ctx context.Context, in *common.ID, opts ...grpc.CallOption) (*CoreInstance, error)
	// List all active adapters (plugins) in the Voltha cluster
	ListAdapters(ctx context.Context, in *empty.Empty, opts ...grpc.CallOption) (*Adapters, error)
	// List all logical devices managed by the Voltha cluster
	ListLogicalDevices(ctx context.Context, in *empty.Empty, opts ...grpc.CallOption) (*LogicalDevices, error)
	// Get additional information on a given logical device
	GetLogicalDevice(ctx context.Context, in *common.ID, opts ...grpc.CallOption) (*LogicalDevice, error)
	// List ports of a logical device
	ListLogicalDevicePorts(ctx context.Context, in *common.ID, opts ...grpc.CallOption) (*LogicalPorts, error)
	// Gets a logical device port
	GetLogicalDevicePort(ctx context.Context, in *LogicalPortId, opts ...grpc.CallOption) (*LogicalPort, error)
	// Enables a logical device port
	EnableLogicalDevicePort(ctx context.Context, in *LogicalPortId, opts ...grpc.CallOption) (*empty.Empty, error)
	// Disables a logical device port
	DisableLogicalDevicePort(ctx context.Context, in *LogicalPortId, opts ...grpc.CallOption) (*empty.Empty, error)
	// List all flows of a logical device
	ListLogicalDeviceFlows(ctx context.Context, in *common.ID, opts ...grpc.CallOption) (*openflow_13.Flows, error)
	// Update flow table for logical device
	UpdateLogicalDeviceFlowTable(ctx context.Context, in *openflow_13.FlowTableUpdate, opts ...grpc.CallOption) (*empty.Empty, error)
	// Update meter table for logical device
	UpdateLogicalDeviceMeterTable(ctx context.Context, in *openflow_13.MeterModUpdate, opts ...grpc.CallOption) (*empty.Empty, error)
	// List all meters of a logical device
	ListLogicalDeviceMeters(ctx context.Context, in *common.ID, opts ...grpc.CallOption) (*openflow_13.Meters, error)
	// List all flow groups of a logical device
	ListLogicalDeviceFlowGroups(ctx context.Context, in *common.ID, opts ...grpc.CallOption) (*openflow_13.FlowGroups, error)
	// Update group table for device
	UpdateLogicalDeviceFlowGroupTable(ctx context.Context, in *openflow_13.FlowGroupTableUpdate, opts ...grpc.CallOption) (*empty.Empty, error)
	// List all physical devices controlled by the Voltha cluster
	ListDevices(ctx context.Context, in *empty.Empty, opts ...grpc.CallOption) (*Devices, error)
	// List all physical devices IDs controlled by the Voltha cluster
	ListDeviceIds(ctx context.Context, in *empty.Empty, opts ...grpc.CallOption) (*common.IDs, error)
	// Request to a voltha Core to reconcile a set of devices based on their IDs
	ReconcileDevices(ctx context.Context, in *common.IDs, opts ...grpc.CallOption) (*empty.Empty, error)
	// Get more information on a given physical device
	GetDevice(ctx context.Context, in *common.ID, opts ...grpc.CallOption) (*Device, error)
	// Pre-provision a new physical device
	CreateDevice(ctx context.Context, in *Device, opts ...grpc.CallOption) (*Device, error)
	// Enable a device.  If the device was in pre-provisioned state then it
	// will transition to ENABLED state.  If it was is DISABLED state then it
	// will transition to ENABLED state as well.
	EnableDevice(ctx context.Context, in *common.ID, opts ...grpc.CallOption) (*empty.Empty, error)
	// Disable a device
	DisableDevice(ctx context.Context, in *common.ID, opts ...grpc.CallOption) (*empty.Empty, error)
	// Reboot a device
	RebootDevice(ctx context.Context, in *common.ID, opts ...grpc.CallOption) (*empty.Empty, error)
	// Delete a device
	DeleteDevice(ctx context.Context, in *common.ID, opts ...grpc.CallOption) (*empty.Empty, error)
	// Forcefully delete a device
	ForceDeleteDevice(ctx context.Context, in *common.ID, opts ...grpc.CallOption) (*empty.Empty, error)
	// Request an image download to the standby partition
	// of a device.
	// Note that the call is expected to be non-blocking.
	DownloadImage(ctx context.Context, in *ImageDownload, opts ...grpc.CallOption) (*common.OperationResp, error)
	// Get image download status on a device
	// The request retrieves progress on device and updates db record
	// Deprecated in voltha 2.8, will be removed
	GetImageDownloadStatus(ctx context.Context, in *ImageDownload, opts ...grpc.CallOption) (*ImageDownload, error)
	// Get image download db record
	// Deprecated in voltha 2.8, will be removed
	GetImageDownload(ctx context.Context, in *ImageDownload, opts ...grpc.CallOption) (*ImageDownload, error)
	// List image download db records for a given device
	// Deprecated in voltha 2.8, will be removed
	ListImageDownloads(ctx context.Context, in *common.ID, opts ...grpc.CallOption) (*ImageDownloads, error)
	// Cancel an existing image download process on a device
	// Deprecated in voltha 2.8, will be removed
	CancelImageDownload(ctx context.Context, in *ImageDownload, opts ...grpc.CallOption) (*common.OperationResp, error)
	// Activate the specified image at a standby partition
	// to active partition.
	// Depending on the device implementation, this call
	// may or may not cause device reboot.
	// If no reboot, then a reboot is required to make the
	// activated image running on device
	// Note that the call is expected to be non-blocking.
	// Deprecated in voltha 2.8, will be removed
	ActivateImageUpdate(ctx context.Context, in *ImageDownload, opts ...grpc.CallOption) (*common.OperationResp, error)
	// Revert the specified image at standby partition
	// to active partition, and revert to previous image
	// Depending on the device implementation, this call
	// may or may not cause device reboot.
	// If no reboot, then a reboot is required to make the
	// previous image running on device
	// Note that the call is expected to be non-blocking.
	// Deprecated in voltha 2.8, will be removed
	RevertImageUpdate(ctx context.Context, in *ImageDownload, opts ...grpc.CallOption) (*common.OperationResp, error)
	// Downloads a certain image to the standby partition of the devices
	// Note that the call is expected to be non-blocking.
	DownloadImageToDevice(ctx context.Context, in *DeviceImageDownloadRequest, opts ...grpc.CallOption) (*DeviceImageResponse, error)
	// Get image status on a number of devices devices
	// Polled from northbound systems to get state of download/activate/commit
	GetImageStatus(ctx context.Context, in *DeviceImageRequest, opts ...grpc.CallOption) (*DeviceImageResponse, error)
	// Aborts the upgrade of an image on a device
	// To be used carefully, stops any further operations for the Image on the given devices
	// Might also stop if possible existing work, but no guarantees are given,
	// depends on implementation and procedure status.
	AbortImageUpgradeToDevice(ctx context.Context, in *DeviceImageRequest, opts ...grpc.CallOption) (*DeviceImageResponse, error)
	// Get Both Active and Standby image for a given device
	GetOnuImages(ctx context.Context, in *common.ID, opts ...grpc.CallOption) (*OnuImages, error)
	// Activate the specified image from a standby partition
	// to active partition.
	// Depending on the device implementation, this call
	// may or may not cause device reboot.
	// If no reboot, then a reboot is required to make the
	// activated image running on device
	// Note that the call is expected to be non-blocking.
	ActivateImage(ctx context.Context, in *DeviceImageRequest, opts ...grpc.CallOption) (*DeviceImageResponse, error)
	// Commit the specified image to be default.
	// Depending on the device implementation, this call
	// may or may not cause device reboot.
	// If no reboot, then a reboot is required to make the
	// activated image running on device upon next reboot
	// Note that the call is expected to be non-blocking.
	CommitImage(ctx context.Context, in *DeviceImageRequest, opts ...grpc.CallOption) (*DeviceImageResponse, error)
	// List ports of a device
	ListDevicePorts(ctx context.Context, in *common.ID, opts ...grpc.CallOption) (*Ports, error)
	// List pm config of a device
	ListDevicePmConfigs(ctx context.Context, in *common.ID, opts ...grpc.CallOption) (*PmConfigs, error)
	// Update the pm config of a device
	UpdateDevicePmConfigs(ctx context.Context, in *PmConfigs, opts ...grpc.CallOption) (*empty.Empty, error)
	// List all flows of a device
	ListDeviceFlows(ctx context.Context, in *common.ID, opts ...grpc.CallOption) (*openflow_13.Flows, error)
	// List all flow groups of a device
	ListDeviceFlowGroups(ctx context.Context, in *common.ID, opts ...grpc.CallOption) (*openflow_13.FlowGroups, error)
	// List device types known to Voltha
	ListDeviceTypes(ctx context.Context, in *empty.Empty, opts ...grpc.CallOption) (*DeviceTypes, error)
	// Get additional information on a device type
	GetDeviceType(ctx context.Context, in *common.ID, opts ...grpc.CallOption) (*DeviceType, error)
	// Stream control packets to the dataplane
	StreamPacketsOut(ctx context.Context, opts ...grpc.CallOption) (VolthaService_StreamPacketsOutClient, error)
	// Receive control packet stream
	ReceivePacketsIn(ctx context.Context, in *empty.Empty, opts ...grpc.CallOption) (VolthaService_ReceivePacketsInClient, error)
	ReceiveChangeEvents(ctx context.Context, in *empty.Empty, opts ...grpc.CallOption) (VolthaService_ReceiveChangeEventsClient, error)
	CreateEventFilter(ctx context.Context, in *EventFilter, opts ...grpc.CallOption) (*EventFilter, error)
	// Get all filters present for a device
	GetEventFilter(ctx context.Context, in *common.ID, opts ...grpc.CallOption) (*EventFilters, error)
	UpdateEventFilter(ctx context.Context, in *EventFilter, opts ...grpc.CallOption) (*EventFilter, error)
	DeleteEventFilter(ctx context.Context, in *EventFilter, opts ...grpc.CallOption) (*empty.Empty, error)
	// Get all the filters present
	ListEventFilters(ctx context.Context, in *empty.Empty, opts ...grpc.CallOption) (*EventFilters, error)
	GetImages(ctx context.Context, in *common.ID, opts ...grpc.CallOption) (*Images, error)
	SelfTest(ctx context.Context, in *common.ID, opts ...grpc.CallOption) (*SelfTestResponse, error)
	// OpenOMCI MIB information
	GetMibDeviceData(ctx context.Context, in *common.ID, opts ...grpc.CallOption) (*omci.MibDeviceData, error)
	// OpenOMCI ALARM information
	GetAlarmDeviceData(ctx context.Context, in *common.ID, opts ...grpc.CallOption) (*omci.AlarmDeviceData, error)
	// Simulate an Alarm
	SimulateAlarm(ctx context.Context, in *SimulateAlarmRequest, opts ...grpc.CallOption) (*common.OperationResp, error)
	EnablePort(ctx context.Context, in *Port, opts ...grpc.CallOption) (*empty.Empty, error)
	DisablePort(ctx context.Context, in *Port, opts ...grpc.CallOption) (*empty.Empty, error)
	GetExtValue(ctx context.Context, in *extension.ValueSpecifier, opts ...grpc.CallOption) (*extension.ReturnValues, error)
	SetExtValue(ctx context.Context, in *extension.ValueSet, opts ...grpc.CallOption) (*empty.Empty, error)
	// omci start and stop cli implementation
	StartOmciTestAction(ctx context.Context, in *omci.OmciTestRequest, opts ...grpc.CallOption) (*omci.TestResponse, error)
}

type volthaServiceClient struct {
	cc *grpc.ClientConn
}

func NewVolthaServiceClient(cc *grpc.ClientConn) VolthaServiceClient {
	return &volthaServiceClient{cc}
}

func (c *volthaServiceClient) GetVoltha(ctx context.Context, in *empty.Empty, opts ...grpc.CallOption) (*Voltha, error) {
	out := new(Voltha)
	err := c.cc.Invoke(ctx, "/voltha.VolthaService/GetVoltha", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *volthaServiceClient) ListCoreInstances(ctx context.Context, in *empty.Empty, opts ...grpc.CallOption) (*CoreInstances, error) {
	out := new(CoreInstances)
	err := c.cc.Invoke(ctx, "/voltha.VolthaService/ListCoreInstances", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *volthaServiceClient) GetCoreInstance(ctx context.Context, in *common.ID, opts ...grpc.CallOption) (*CoreInstance, error) {
	out := new(CoreInstance)
	err := c.cc.Invoke(ctx, "/voltha.VolthaService/GetCoreInstance", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *volthaServiceClient) ListAdapters(ctx context.Context, in *empty.Empty, opts ...grpc.CallOption) (*Adapters, error) {
	out := new(Adapters)
	err := c.cc.Invoke(ctx, "/voltha.VolthaService/ListAdapters", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *volthaServiceClient) ListLogicalDevices(ctx context.Context, in *empty.Empty, opts ...grpc.CallOption) (*LogicalDevices, error) {
	out := new(LogicalDevices)
	err := c.cc.Invoke(ctx, "/voltha.VolthaService/ListLogicalDevices", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *volthaServiceClient) GetLogicalDevice(ctx context.Context, in *common.ID, opts ...grpc.CallOption) (*LogicalDevice, error) {
	out := new(LogicalDevice)
	err := c.cc.Invoke(ctx, "/voltha.VolthaService/GetLogicalDevice", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *volthaServiceClient) ListLogicalDevicePorts(ctx context.Context, in *common.ID, opts ...grpc.CallOption) (*LogicalPorts, error) {
	out := new(LogicalPorts)
	err := c.cc.Invoke(ctx, "/voltha.VolthaService/ListLogicalDevicePorts", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *volthaServiceClient) GetLogicalDevicePort(ctx context.Context, in *LogicalPortId, opts ...grpc.CallOption) (*LogicalPort, error) {
	out := new(LogicalPort)
	err := c.cc.Invoke(ctx, "/voltha.VolthaService/GetLogicalDevicePort", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *volthaServiceClient) EnableLogicalDevicePort(ctx context.Context, in *LogicalPortId, opts ...grpc.CallOption) (*empty.Empty, error) {
	out := new(empty.Empty)
	err := c.cc.Invoke(ctx, "/voltha.VolthaService/EnableLogicalDevicePort", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *volthaServiceClient) DisableLogicalDevicePort(ctx context.Context, in *LogicalPortId, opts ...grpc.CallOption) (*empty.Empty, error) {
	out := new(empty.Empty)
	err := c.cc.Invoke(ctx, "/voltha.VolthaService/DisableLogicalDevicePort", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *volthaServiceClient) ListLogicalDeviceFlows(ctx context.Context, in *common.ID, opts ...grpc.CallOption) (*openflow_13.Flows, error) {
	out := new(openflow_13.Flows)
	err := c.cc.Invoke(ctx, "/voltha.VolthaService/ListLogicalDeviceFlows", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *volthaServiceClient) UpdateLogicalDeviceFlowTable(ctx context.Context, in *openflow_13.FlowTableUpdate, opts ...grpc.CallOption) (*empty.Empty, error) {
	out := new(empty.Empty)
	err := c.cc.Invoke(ctx, "/voltha.VolthaService/UpdateLogicalDeviceFlowTable", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *volthaServiceClient) UpdateLogicalDeviceMeterTable(ctx context.Context, in *openflow_13.MeterModUpdate, opts ...grpc.CallOption) (*empty.Empty, error) {
	out := new(empty.Empty)
	err := c.cc.Invoke(ctx, "/voltha.VolthaService/UpdateLogicalDeviceMeterTable", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *volthaServiceClient) ListLogicalDeviceMeters(ctx context.Context, in *common.ID, opts ...grpc.CallOption) (*openflow_13.Meters, error) {
	out := new(openflow_13.Meters)
	err := c.cc.Invoke(ctx, "/voltha.VolthaService/ListLogicalDeviceMeters", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *volthaServiceClient) ListLogicalDeviceFlowGroups(ctx context.Context, in *common.ID, opts ...grpc.CallOption) (*openflow_13.FlowGroups, error) {
	out := new(openflow_13.FlowGroups)
	err := c.cc.Invoke(ctx, "/voltha.VolthaService/ListLogicalDeviceFlowGroups", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *volthaServiceClient) UpdateLogicalDeviceFlowGroupTable(ctx context.Context, in *openflow_13.FlowGroupTableUpdate, opts ...grpc.CallOption) (*empty.Empty, error) {
	out := new(empty.Empty)
	err := c.cc.Invoke(ctx, "/voltha.VolthaService/UpdateLogicalDeviceFlowGroupTable", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *volthaServiceClient) ListDevices(ctx context.Context, in *empty.Empty, opts ...grpc.CallOption) (*Devices, error) {
	out := new(Devices)
	err := c.cc.Invoke(ctx, "/voltha.VolthaService/ListDevices", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *volthaServiceClient) ListDeviceIds(ctx context.Context, in *empty.Empty, opts ...grpc.CallOption) (*common.IDs, error) {
	out := new(common.IDs)
	err := c.cc.Invoke(ctx, "/voltha.VolthaService/ListDeviceIds", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *volthaServiceClient) ReconcileDevices(ctx context.Context, in *common.IDs, opts ...grpc.CallOption) (*empty.Empty, error) {
	out := new(empty.Empty)
	err := c.cc.Invoke(ctx, "/voltha.VolthaService/ReconcileDevices", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *volthaServiceClient) GetDevice(ctx context.Context, in *common.ID, opts ...grpc.CallOption) (*Device, error) {
	out := new(Device)
	err := c.cc.Invoke(ctx, "/voltha.VolthaService/GetDevice", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *volthaServiceClient) CreateDevice(ctx context.Context, in *Device, opts ...grpc.CallOption) (*Device, error) {
	out := new(Device)
	err := c.cc.Invoke(ctx, "/voltha.VolthaService/CreateDevice", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *volthaServiceClient) EnableDevice(ctx context.Context, in *common.ID, opts ...grpc.CallOption) (*empty.Empty, error) {
	out := new(empty.Empty)
	err := c.cc.Invoke(ctx, "/voltha.VolthaService/EnableDevice", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *volthaServiceClient) DisableDevice(ctx context.Context, in *common.ID, opts ...grpc.CallOption) (*empty.Empty, error) {
	out := new(empty.Empty)
	err := c.cc.Invoke(ctx, "/voltha.VolthaService/DisableDevice", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *volthaServiceClient) RebootDevice(ctx context.Context, in *common.ID, opts ...grpc.CallOption) (*empty.Empty, error) {
	out := new(empty.Empty)
	err := c.cc.Invoke(ctx, "/voltha.VolthaService/RebootDevice", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *volthaServiceClient) DeleteDevice(ctx context.Context, in *common.ID, opts ...grpc.CallOption) (*empty.Empty, error) {
	out := new(empty.Empty)
	err := c.cc.Invoke(ctx, "/voltha.VolthaService/DeleteDevice", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *volthaServiceClient) ForceDeleteDevice(ctx context.Context, in *common.ID, opts ...grpc.CallOption) (*empty.Empty, error) {
	out := new(empty.Empty)
	err := c.cc.Invoke(ctx, "/voltha.VolthaService/ForceDeleteDevice", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// Deprecated: Do not use.
func (c *volthaServiceClient) DownloadImage(ctx context.Context, in *ImageDownload, opts ...grpc.CallOption) (*common.OperationResp, error) {
	out := new(common.OperationResp)
	err := c.cc.Invoke(ctx, "/voltha.VolthaService/DownloadImage", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// Deprecated: Do not use.
func (c *volthaServiceClient) GetImageDownloadStatus(ctx context.Context, in *ImageDownload, opts ...grpc.CallOption) (*ImageDownload, error) {
	out := new(ImageDownload)
	err := c.cc.Invoke(ctx, "/voltha.VolthaService/GetImageDownloadStatus", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// Deprecated: Do not use.
func (c *volthaServiceClient) GetImageDownload(ctx context.Context, in *ImageDownload, opts ...grpc.CallOption) (*ImageDownload, error) {
	out := new(ImageDownload)
	err := c.cc.Invoke(ctx, "/voltha.VolthaService/GetImageDownload", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// Deprecated: Do not use.
func (c *volthaServiceClient) ListImageDownloads(ctx context.Context, in *common.ID, opts ...grpc.CallOption) (*ImageDownloads, error) {
	out := new(ImageDownloads)
	err := c.cc.Invoke(ctx, "/voltha.VolthaService/ListImageDownloads", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// Deprecated: Do not use.
func (c *volthaServiceClient) CancelImageDownload(ctx context.Context, in *ImageDownload, opts ...grpc.CallOption) (*common.OperationResp, error) {
	out := new(common.OperationResp)
	err := c.cc.Invoke(ctx, "/voltha.VolthaService/CancelImageDownload", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// Deprecated: Do not use.
func (c *volthaServiceClient) ActivateImageUpdate(ctx context.Context, in *ImageDownload, opts ...grpc.CallOption) (*common.OperationResp, error) {
	out := new(common.OperationResp)
	err := c.cc.Invoke(ctx, "/voltha.VolthaService/ActivateImageUpdate", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// Deprecated: Do not use.
func (c *volthaServiceClient) RevertImageUpdate(ctx context.Context, in *ImageDownload, opts ...grpc.CallOption) (*common.OperationResp, error) {
	out := new(common.OperationResp)
	err := c.cc.Invoke(ctx, "/voltha.VolthaService/RevertImageUpdate", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *volthaServiceClient) DownloadImageToDevice(ctx context.Context, in *DeviceImageDownloadRequest, opts ...grpc.CallOption) (*DeviceImageResponse, error) {
	out := new(DeviceImageResponse)
	err := c.cc.Invoke(ctx, "/voltha.VolthaService/DownloadImageToDevice", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *volthaServiceClient) GetImageStatus(ctx context.Context, in *DeviceImageRequest, opts ...grpc.CallOption) (*DeviceImageResponse, error) {
	out := new(DeviceImageResponse)
	err := c.cc.Invoke(ctx, "/voltha.VolthaService/GetImageStatus", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *volthaServiceClient) AbortImageUpgradeToDevice(ctx context.Context, in *DeviceImageRequest, opts ...grpc.CallOption) (*DeviceImageResponse, error) {
	out := new(DeviceImageResponse)
	err := c.cc.Invoke(ctx, "/voltha.VolthaService/AbortImageUpgradeToDevice", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *volthaServiceClient) GetOnuImages(ctx context.Context, in *common.ID, opts ...grpc.CallOption) (*OnuImages, error) {
	out := new(OnuImages)
	err := c.cc.Invoke(ctx, "/voltha.VolthaService/GetOnuImages", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *volthaServiceClient) ActivateImage(ctx context.Context, in *DeviceImageRequest, opts ...grpc.CallOption) (*DeviceImageResponse, error) {
	out := new(DeviceImageResponse)
	err := c.cc.Invoke(ctx, "/voltha.VolthaService/ActivateImage", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *volthaServiceClient) CommitImage(ctx context.Context, in *DeviceImageRequest, opts ...grpc.CallOption) (*DeviceImageResponse, error) {
	out := new(DeviceImageResponse)
	err := c.cc.Invoke(ctx, "/voltha.VolthaService/CommitImage", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *volthaServiceClient) ListDevicePorts(ctx context.Context, in *common.ID, opts ...grpc.CallOption) (*Ports, error) {
	out := new(Ports)
	err := c.cc.Invoke(ctx, "/voltha.VolthaService/ListDevicePorts", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *volthaServiceClient) ListDevicePmConfigs(ctx context.Context, in *common.ID, opts ...grpc.CallOption) (*PmConfigs, error) {
	out := new(PmConfigs)
	err := c.cc.Invoke(ctx, "/voltha.VolthaService/ListDevicePmConfigs", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *volthaServiceClient) UpdateDevicePmConfigs(ctx context.Context, in *PmConfigs, opts ...grpc.CallOption) (*empty.Empty, error) {
	out := new(empty.Empty)
	err := c.cc.Invoke(ctx, "/voltha.VolthaService/UpdateDevicePmConfigs", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *volthaServiceClient) ListDeviceFlows(ctx context.Context, in *common.ID, opts ...grpc.CallOption) (*openflow_13.Flows, error) {
	out := new(openflow_13.Flows)
	err := c.cc.Invoke(ctx, "/voltha.VolthaService/ListDeviceFlows", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *volthaServiceClient) ListDeviceFlowGroups(ctx context.Context, in *common.ID, opts ...grpc.CallOption) (*openflow_13.FlowGroups, error) {
	out := new(openflow_13.FlowGroups)
	err := c.cc.Invoke(ctx, "/voltha.VolthaService/ListDeviceFlowGroups", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *volthaServiceClient) ListDeviceTypes(ctx context.Context, in *empty.Empty, opts ...grpc.CallOption) (*DeviceTypes, error) {
	out := new(DeviceTypes)
	err := c.cc.Invoke(ctx, "/voltha.VolthaService/ListDeviceTypes", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *volthaServiceClient) GetDeviceType(ctx context.Context, in *common.ID, opts ...grpc.CallOption) (*DeviceType, error) {
	out := new(DeviceType)
	err := c.cc.Invoke(ctx, "/voltha.VolthaService/GetDeviceType", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *volthaServiceClient) StreamPacketsOut(ctx context.Context, opts ...grpc.CallOption) (VolthaService_StreamPacketsOutClient, error) {
	stream, err := c.cc.NewStream(ctx, &_VolthaService_serviceDesc.Streams[0], "/voltha.VolthaService/StreamPacketsOut", opts...)
	if err != nil {
		return nil, err
	}
	x := &volthaServiceStreamPacketsOutClient{stream}
	return x, nil
}

type VolthaService_StreamPacketsOutClient interface {
	Send(*openflow_13.PacketOut) error
	CloseAndRecv() (*empty.Empty, error)
	grpc.ClientStream
}

type volthaServiceStreamPacketsOutClient struct {
	grpc.ClientStream
}

func (x *volthaServiceStreamPacketsOutClient) Send(m *openflow_13.PacketOut) error {
	return x.ClientStream.SendMsg(m)
}

func (x *volthaServiceStreamPacketsOutClient) CloseAndRecv() (*empty.Empty, error) {
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	m := new(empty.Empty)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *volthaServiceClient) ReceivePacketsIn(ctx context.Context, in *empty.Empty, opts ...grpc.CallOption) (VolthaService_ReceivePacketsInClient, error) {
	stream, err := c.cc.NewStream(ctx, &_VolthaService_serviceDesc.Streams[1], "/voltha.VolthaService/ReceivePacketsIn", opts...)
	if err != nil {
		return nil, err
	}
	x := &volthaServiceReceivePacketsInClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type VolthaService_ReceivePacketsInClient interface {
	Recv() (*openflow_13.PacketIn, error)
	grpc.ClientStream
}

type volthaServiceReceivePacketsInClient struct {
	grpc.ClientStream
}

func (x *volthaServiceReceivePacketsInClient) Recv() (*openflow_13.PacketIn, error) {
	m := new(openflow_13.PacketIn)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *volthaServiceClient) ReceiveChangeEvents(ctx context.Context, in *empty.Empty, opts ...grpc.CallOption) (VolthaService_ReceiveChangeEventsClient, error) {
	stream, err := c.cc.NewStream(ctx, &_VolthaService_serviceDesc.Streams[2], "/voltha.VolthaService/ReceiveChangeEvents", opts...)
	if err != nil {
		return nil, err
	}
	x := &volthaServiceReceiveChangeEventsClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type VolthaService_ReceiveChangeEventsClient interface {
	Recv() (*openflow_13.ChangeEvent, error)
	grpc.ClientStream
}

type volthaServiceReceiveChangeEventsClient struct {
	grpc.ClientStream
}

func (x *volthaServiceReceiveChangeEventsClient) Recv() (*openflow_13.ChangeEvent, error) {
	m := new(openflow_13.ChangeEvent)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *volthaServiceClient) CreateEventFilter(ctx context.Context, in *EventFilter, opts ...grpc.CallOption) (*EventFilter, error) {
	out := new(EventFilter)
	err := c.cc.Invoke(ctx, "/voltha.VolthaService/CreateEventFilter", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *volthaServiceClient) GetEventFilter(ctx context.Context, in *common.ID, opts ...grpc.CallOption) (*EventFilters, error) {
	out := new(EventFilters)
	err := c.cc.Invoke(ctx, "/voltha.VolthaService/GetEventFilter", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *volthaServiceClient) UpdateEventFilter(ctx context.Context, in *EventFilter, opts ...grpc.CallOption) (*EventFilter, error) {
	out := new(EventFilter)
	err := c.cc.Invoke(ctx, "/voltha.VolthaService/UpdateEventFilter", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *volthaServiceClient) DeleteEventFilter(ctx context.Context, in *EventFilter, opts ...grpc.CallOption) (*empty.Empty, error) {
	out := new(empty.Empty)
	err := c.cc.Invoke(ctx, "/voltha.VolthaService/DeleteEventFilter", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *volthaServiceClient) ListEventFilters(ctx context.Context, in *empty.Empty, opts ...grpc.CallOption) (*EventFilters, error) {
	out := new(EventFilters)
	err := c.cc.Invoke(ctx, "/voltha.VolthaService/ListEventFilters", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *volthaServiceClient) GetImages(ctx context.Context, in *common.ID, opts ...grpc.CallOption) (*Images, error) {
	out := new(Images)
	err := c.cc.Invoke(ctx, "/voltha.VolthaService/GetImages", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *volthaServiceClient) SelfTest(ctx context.Context, in *common.ID, opts ...grpc.CallOption) (*SelfTestResponse, error) {
	out := new(SelfTestResponse)
	err := c.cc.Invoke(ctx, "/voltha.VolthaService/SelfTest", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *volthaServiceClient) GetMibDeviceData(ctx context.Context, in *common.ID, opts ...grpc.CallOption) (*omci.MibDeviceData, error) {
	out := new(omci.MibDeviceData)
	err := c.cc.Invoke(ctx, "/voltha.VolthaService/GetMibDeviceData", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *volthaServiceClient) GetAlarmDeviceData(ctx context.Context, in *common.ID, opts ...grpc.CallOption) (*omci.AlarmDeviceData, error) {
	out := new(omci.AlarmDeviceData)
	err := c.cc.Invoke(ctx, "/voltha.VolthaService/GetAlarmDeviceData", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *volthaServiceClient) SimulateAlarm(ctx context.Context, in *SimulateAlarmRequest, opts ...grpc.CallOption) (*common.OperationResp, error) {
	out := new(common.OperationResp)
	err := c.cc.Invoke(ctx, "/voltha.VolthaService/SimulateAlarm", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *volthaServiceClient) EnablePort(ctx context.Context, in *Port, opts ...grpc.CallOption) (*empty.Empty, error) {
	out := new(empty.Empty)
	err := c.cc.Invoke(ctx, "/voltha.VolthaService/EnablePort", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *volthaServiceClient) DisablePort(ctx context.Context, in *Port, opts ...grpc.CallOption) (*empty.Empty, error) {
	out := new(empty.Empty)
	err := c.cc.Invoke(ctx, "/voltha.VolthaService/DisablePort", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *volthaServiceClient) GetExtValue(ctx context.Context, in *extension.ValueSpecifier, opts ...grpc.CallOption) (*extension.ReturnValues, error) {
	out := new(extension.ReturnValues)
	err := c.cc.Invoke(ctx, "/voltha.VolthaService/GetExtValue", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *volthaServiceClient) SetExtValue(ctx context.Context, in *extension.ValueSet, opts ...grpc.CallOption) (*empty.Empty, error) {
	out := new(empty.Empty)
	err := c.cc.Invoke(ctx, "/voltha.VolthaService/SetExtValue", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *volthaServiceClient) StartOmciTestAction(ctx context.Context, in *omci.OmciTestRequest, opts ...grpc.CallOption) (*omci.TestResponse, error) {
	out := new(omci.TestResponse)
	err := c.cc.Invoke(ctx, "/voltha.VolthaService/StartOmciTestAction", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// VolthaServiceServer is the server API for VolthaService service.
type VolthaServiceServer interface {
	// Get high level information on the Voltha cluster
	GetVoltha(context.Context, *empty.Empty) (*Voltha, error)
	// List all Voltha cluster core instances
	ListCoreInstances(context.Context, *empty.Empty) (*CoreInstances, error)
	// Get details on a Voltha cluster instance
	GetCoreInstance(context.Context, *common.ID) (*CoreInstance, error)
	// List all active adapters (plugins) in the Voltha cluster
	ListAdapters(context.Context, *empty.Empty) (*Adapters, error)
	// List all logical devices managed by the Voltha cluster
	ListLogicalDevices(context.Context, *empty.Empty) (*LogicalDevices, error)
	// Get additional information on a given logical device
	GetLogicalDevice(context.Context, *common.ID) (*LogicalDevice, error)
	// List ports of a logical device
	ListLogicalDevicePorts(context.Context, *common.ID) (*LogicalPorts, error)
	// Gets a logical device port
	GetLogicalDevicePort(context.Context, *LogicalPortId) (*LogicalPort, error)
	// Enables a logical device port
	EnableLogicalDevicePort(context.Context, *LogicalPortId) (*empty.Empty, error)
	// Disables a logical device port
	DisableLogicalDevicePort(context.Context, *LogicalPortId) (*empty.Empty, error)
	// List all flows of a logical device
	ListLogicalDeviceFlows(context.Context, *common.ID) (*openflow_13.Flows, error)
	// Update flow table for logical device
	UpdateLogicalDeviceFlowTable(context.Context, *openflow_13.FlowTableUpdate) (*empty.Empty, error)
	// Update meter table for logical device
	UpdateLogicalDeviceMeterTable(context.Context, *openflow_13.MeterModUpdate) (*empty.Empty, error)
	// List all meters of a logical device
	ListLogicalDeviceMeters(context.Context, *common.ID) (*openflow_13.Meters, error)
	// List all flow groups of a logical device
	ListLogicalDeviceFlowGroups(context.Context, *common.ID) (*openflow_13.FlowGroups, error)
	// Update group table for device
	UpdateLogicalDeviceFlowGroupTable(context.Context, *openflow_13.FlowGroupTableUpdate) (*empty.Empty, error)
	// List all physical devices controlled by the Voltha cluster
	ListDevices(context.Context, *empty.Empty) (*Devices, error)
	// List all physical devices IDs controlled by the Voltha cluster
	ListDeviceIds(context.Context, *empty.Empty) (*common.IDs, error)
	// Request to a voltha Core to reconcile a set of devices based on their IDs
	ReconcileDevices(context.Context, *common.IDs) (*empty.Empty, error)
	// Get more information on a given physical device
	GetDevice(context.Context, *common.ID) (*Device, error)
	// Pre-provision a new physical device
	CreateDevice(context.Context, *Device) (*Device, error)
	// Enable a device.  If the device was in pre-provisioned state then it
	// will transition to ENABLED state.  If it was is DISABLED state then it
	// will transition to ENABLED state as well.
	EnableDevice(context.Context, *common.ID) (*empty.Empty, error)
	// Disable a device
	DisableDevice(context.Context, *common.ID) (*empty.Empty, error)
	// Reboot a device
	RebootDevice(context.Context, *common.ID) (*empty.Empty, error)
	// Delete a device
	DeleteDevice(context.Context, *common.ID) (*empty.Empty, error)
	// Forcefully delete a device
	ForceDeleteDevice(context.Context, *common.ID) (*empty.Empty, error)
	// Request an image download to the standby partition
	// of a device.
	// Note that the call is expected to be non-blocking.
	DownloadImage(context.Context, *ImageDownload) (*common.OperationResp, error)
	// Get image download status on a device
	// The request retrieves progress on device and updates db record
	// Deprecated in voltha 2.8, will be removed
	GetImageDownloadStatus(context.Context, *ImageDownload) (*ImageDownload, error)
	// Get image download db record
	// Deprecated in voltha 2.8, will be removed
	GetImageDownload(context.Context, *ImageDownload) (*ImageDownload, error)
	// List image download db records for a given device
	// Deprecated in voltha 2.8, will be removed
	ListImageDownloads(context.Context, *common.ID) (*ImageDownloads, error)
	// Cancel an existing image download process on a device
	// Deprecated in voltha 2.8, will be removed
	CancelImageDownload(context.Context, *ImageDownload) (*common.OperationResp, error)
	// Activate the specified image at a standby partition
	// to active partition.
	// Depending on the device implementation, this call
	// may or may not cause device reboot.
	// If no reboot, then a reboot is required to make the
	// activated image running on device
	// Note that the call is expected to be non-blocking.
	// Deprecated in voltha 2.8, will be removed
	ActivateImageUpdate(context.Context, *ImageDownload) (*common.OperationResp, error)
	// Revert the specified image at standby partition
	// to active partition, and revert to previous image
	// Depending on the device implementation, this call
	// may or may not cause device reboot.
	// If no reboot, then a reboot is required to make the
	// previous image running on device
	// Note that the call is expected to be non-blocking.
	// Deprecated in voltha 2.8, will be removed
	RevertImageUpdate(context.Context, *ImageDownload) (*common.OperationResp, error)
	// Downloads a certain image to the standby partition of the devices
	// Note that the call is expected to be non-blocking.
	DownloadImageToDevice(context.Context, *DeviceImageDownloadRequest) (*DeviceImageResponse, error)
	// Get image status on a number of devices devices
	// Polled from northbound systems to get state of download/activate/commit
	GetImageStatus(context.Context, *DeviceImageRequest) (*DeviceImageResponse, error)
	// Aborts the upgrade of an image on a device
	// To be used carefully, stops any further operations for the Image on the given devices
	// Might also stop if possible existing work, but no guarantees are given,
	// depends on implementation and procedure status.
	AbortImageUpgradeToDevice(context.Context, *DeviceImageRequest) (*DeviceImageResponse, error)
	// Get Both Active and Standby image for a given device
	GetOnuImages(context.Context, *common.ID) (*OnuImages, error)
	// Activate the specified image from a standby partition
	// to active partition.
	// Depending on the device implementation, this call
	// may or may not cause device reboot.
	// If no reboot, then a reboot is required to make the
	// activated image running on device
	// Note that the call is expected to be non-blocking.
	ActivateImage(context.Context, *DeviceImageRequest) (*DeviceImageResponse, error)
	// Commit the specified image to be default.
	// Depending on the device implementation, this call
	// may or may not cause device reboot.
	// If no reboot, then a reboot is required to make the
	// activated image running on device upon next reboot
	// Note that the call is expected to be non-blocking.
	CommitImage(context.Context, *DeviceImageRequest) (*DeviceImageResponse, error)
	// List ports of a device
	ListDevicePorts(context.Context, *common.ID) (*Ports, error)
	// List pm config of a device
	ListDevicePmConfigs(context.Context, *common.ID) (*PmConfigs, error)
	// Update the pm config of a device
	UpdateDevicePmConfigs(context.Context, *PmConfigs) (*empty.Empty, error)
	// List all flows of a device
	ListDeviceFlows(context.Context, *common.ID) (*openflow_13.Flows, error)
	// List all flow groups of a device
	ListDeviceFlowGroups(context.Context, *common.ID) (*openflow_13.FlowGroups, error)
	// List device types known to Voltha
	ListDeviceTypes(context.Context, *empty.Empty) (*DeviceTypes, error)
	// Get additional information on a device type
	GetDeviceType(context.Context, *common.ID) (*DeviceType, error)
	// Stream control packets to the dataplane
	StreamPacketsOut(VolthaService_StreamPacketsOutServer) error
	// Receive control packet stream
	ReceivePacketsIn(*empty.Empty, VolthaService_ReceivePacketsInServer) error
	ReceiveChangeEvents(*empty.Empty, VolthaService_ReceiveChangeEventsServer) error
	CreateEventFilter(context.Context, *EventFilter) (*EventFilter, error)
	// Get all filters present for a device
	GetEventFilter(context.Context, *common.ID) (*EventFilters, error)
	UpdateEventFilter(context.Context, *EventFilter) (*EventFilter, error)
	DeleteEventFilter(context.Context, *EventFilter) (*empty.Empty, error)
	// Get all the filters present
	ListEventFilters(context.Context, *empty.Empty) (*EventFilters, error)
	GetImages(context.Context, *common.ID) (*Images, error)
	SelfTest(context.Context, *common.ID) (*SelfTestResponse, error)
	// OpenOMCI MIB information
	GetMibDeviceData(context.Context, *common.ID) (*omci.MibDeviceData, error)
	// OpenOMCI ALARM information
	GetAlarmDeviceData(context.Context, *common.ID) (*omci.AlarmDeviceData, error)
	// Simulate an Alarm
	SimulateAlarm(context.Context, *SimulateAlarmRequest) (*common.OperationResp, error)
	EnablePort(context.Context, *Port) (*empty.Empty, error)
	DisablePort(context.Context, *Port) (*empty.Empty, error)
	GetExtValue(context.Context, *extension.ValueSpecifier) (*extension.ReturnValues, error)
	SetExtValue(context.Context, *extension.ValueSet) (*empty.Empty, error)
	// omci start and stop cli implementation
	StartOmciTestAction(context.Context, *omci.OmciTestRequest) (*omci.TestResponse, error)
}

// UnimplementedVolthaServiceServer can be embedded to have forward compatible implementations.
type UnimplementedVolthaServiceServer struct {
}

func (*UnimplementedVolthaServiceServer) GetVoltha(ctx context.Context, req *empty.Empty) (*Voltha, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetVoltha not implemented")
}
func (*UnimplementedVolthaServiceServer) ListCoreInstances(ctx context.Context, req *empty.Empty) (*CoreInstances, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListCoreInstances not implemented")
}
func (*UnimplementedVolthaServiceServer) GetCoreInstance(ctx context.Context, req *common.ID) (*CoreInstance, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetCoreInstance not implemented")
}
func (*UnimplementedVolthaServiceServer) ListAdapters(ctx context.Context, req *empty.Empty) (*Adapters, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListAdapters not implemented")
}
func (*UnimplementedVolthaServiceServer) ListLogicalDevices(ctx context.Context, req *empty.Empty) (*LogicalDevices, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListLogicalDevices not implemented")
}
func (*UnimplementedVolthaServiceServer) GetLogicalDevice(ctx context.Context, req *common.ID) (*LogicalDevice, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetLogicalDevice not implemented")
}
func (*UnimplementedVolthaServiceServer) ListLogicalDevicePorts(ctx context.Context, req *common.ID) (*LogicalPorts, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListLogicalDevicePorts not implemented")
}
func (*UnimplementedVolthaServiceServer) GetLogicalDevicePort(ctx context.Context, req *LogicalPortId) (*LogicalPort, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetLogicalDevicePort not implemented")
}
func (*UnimplementedVolthaServiceServer) EnableLogicalDevicePort(ctx context.Context, req *LogicalPortId) (*empty.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method EnableLogicalDevicePort not implemented")
}
func (*UnimplementedVolthaServiceServer) DisableLogicalDevicePort(ctx context.Context, req *LogicalPortId) (*empty.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DisableLogicalDevicePort not implemented")
}
func (*UnimplementedVolthaServiceServer) ListLogicalDeviceFlows(ctx context.Context, req *common.ID) (*openflow_13.Flows, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListLogicalDeviceFlows not implemented")
}
func (*UnimplementedVolthaServiceServer) UpdateLogicalDeviceFlowTable(ctx context.Context, req *openflow_13.FlowTableUpdate) (*empty.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateLogicalDeviceFlowTable not implemented")
}
func (*UnimplementedVolthaServiceServer) UpdateLogicalDeviceMeterTable(ctx context.Context, req *openflow_13.MeterModUpdate) (*empty.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateLogicalDeviceMeterTable not implemented")
}
func (*UnimplementedVolthaServiceServer) ListLogicalDeviceMeters(ctx context.Context, req *common.ID) (*openflow_13.Meters, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListLogicalDeviceMeters not implemented")
}
func (*UnimplementedVolthaServiceServer) ListLogicalDeviceFlowGroups(ctx context.Context, req *common.ID) (*openflow_13.FlowGroups, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListLogicalDeviceFlowGroups not implemented")
}
func (*UnimplementedVolthaServiceServer) UpdateLogicalDeviceFlowGroupTable(ctx context.Context, req *openflow_13.FlowGroupTableUpdate) (*empty.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateLogicalDeviceFlowGroupTable not implemented")
}
func (*UnimplementedVolthaServiceServer) ListDevices(ctx context.Context, req *empty.Empty) (*Devices, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListDevices not implemented")
}
func (*UnimplementedVolthaServiceServer) ListDeviceIds(ctx context.Context, req *empty.Empty) (*common.IDs, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListDeviceIds not implemented")
}
func (*UnimplementedVolthaServiceServer) ReconcileDevices(ctx context.Context, req *common.IDs) (*empty.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ReconcileDevices not implemented")
}
func (*UnimplementedVolthaServiceServer) GetDevice(ctx context.Context, req *common.ID) (*Device, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetDevice not implemented")
}
func (*UnimplementedVolthaServiceServer) CreateDevice(ctx context.Context, req *Device) (*Device, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateDevice not implemented")
}
func (*UnimplementedVolthaServiceServer) EnableDevice(ctx context.Context, req *common.ID) (*empty.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method EnableDevice not implemented")
}
func (*UnimplementedVolthaServiceServer) DisableDevice(ctx context.Context, req *common.ID) (*empty.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DisableDevice not implemented")
}
func (*UnimplementedVolthaServiceServer) RebootDevice(ctx context.Context, req *common.ID) (*empty.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method RebootDevice not implemented")
}
func (*UnimplementedVolthaServiceServer) DeleteDevice(ctx context.Context, req *common.ID) (*empty.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteDevice not implemented")
}
func (*UnimplementedVolthaServiceServer) ForceDeleteDevice(ctx context.Context, req *common.ID) (*empty.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ForceDeleteDevice not implemented")
}
func (*UnimplementedVolthaServiceServer) DownloadImage(ctx context.Context, req *ImageDownload) (*common.OperationResp, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DownloadImage not implemented")
}
func (*UnimplementedVolthaServiceServer) GetImageDownloadStatus(ctx context.Context, req *ImageDownload) (*ImageDownload, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetImageDownloadStatus not implemented")
}
func (*UnimplementedVolthaServiceServer) GetImageDownload(ctx context.Context, req *ImageDownload) (*ImageDownload, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetImageDownload not implemented")
}
func (*UnimplementedVolthaServiceServer) ListImageDownloads(ctx context.Context, req *common.ID) (*ImageDownloads, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListImageDownloads not implemented")
}
func (*UnimplementedVolthaServiceServer) CancelImageDownload(ctx context.Context, req *ImageDownload) (*common.OperationResp, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CancelImageDownload not implemented")
}
func (*UnimplementedVolthaServiceServer) ActivateImageUpdate(ctx context.Context, req *ImageDownload) (*common.OperationResp, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ActivateImageUpdate not implemented")
}
func (*UnimplementedVolthaServiceServer) RevertImageUpdate(ctx context.Context, req *ImageDownload) (*common.OperationResp, error) {
	return nil, status.Errorf(codes.Unimplemented, "method RevertImageUpdate not implemented")
}
func (*UnimplementedVolthaServiceServer) DownloadImageToDevice(ctx context.Context, req *DeviceImageDownloadRequest) (*DeviceImageResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DownloadImageToDevice not implemented")
}
func (*UnimplementedVolthaServiceServer) GetImageStatus(ctx context.Context, req *DeviceImageRequest) (*DeviceImageResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetImageStatus not implemented")
}
func (*UnimplementedVolthaServiceServer) AbortImageUpgradeToDevice(ctx context.Context, req *DeviceImageRequest) (*DeviceImageResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method AbortImageUpgradeToDevice not implemented")
}
func (*UnimplementedVolthaServiceServer) GetOnuImages(ctx context.Context, req *common.ID) (*OnuImages, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetOnuImages not implemented")
}
func (*UnimplementedVolthaServiceServer) ActivateImage(ctx context.Context, req *DeviceImageRequest) (*DeviceImageResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ActivateImage not implemented")
}
func (*UnimplementedVolthaServiceServer) CommitImage(ctx context.Context, req *DeviceImageRequest) (*DeviceImageResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CommitImage not implemented")
}
func (*UnimplementedVolthaServiceServer) ListDevicePorts(ctx context.Context, req *common.ID) (*Ports, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListDevicePorts not implemented")
}
func (*UnimplementedVolthaServiceServer) ListDevicePmConfigs(ctx context.Context, req *common.ID) (*PmConfigs, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListDevicePmConfigs not implemented")
}
func (*UnimplementedVolthaServiceServer) UpdateDevicePmConfigs(ctx context.Context, req *PmConfigs) (*empty.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateDevicePmConfigs not implemented")
}
func (*UnimplementedVolthaServiceServer) ListDeviceFlows(ctx context.Context, req *common.ID) (*openflow_13.Flows, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListDeviceFlows not implemented")
}
func (*UnimplementedVolthaServiceServer) ListDeviceFlowGroups(ctx context.Context, req *common.ID) (*openflow_13.FlowGroups, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListDeviceFlowGroups not implemented")
}
func (*UnimplementedVolthaServiceServer) ListDeviceTypes(ctx context.Context, req *empty.Empty) (*DeviceTypes, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListDeviceTypes not implemented")
}
func (*UnimplementedVolthaServiceServer) GetDeviceType(ctx context.Context, req *common.ID) (*DeviceType, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetDeviceType not implemented")
}
func (*UnimplementedVolthaServiceServer) StreamPacketsOut(srv VolthaService_StreamPacketsOutServer) error {
	return status.Errorf(codes.Unimplemented, "method StreamPacketsOut not implemented")
}
func (*UnimplementedVolthaServiceServer) ReceivePacketsIn(req *empty.Empty, srv VolthaService_ReceivePacketsInServer) error {
	return status.Errorf(codes.Unimplemented, "method ReceivePacketsIn not implemented")
}
func (*UnimplementedVolthaServiceServer) ReceiveChangeEvents(req *empty.Empty, srv VolthaService_ReceiveChangeEventsServer) error {
	return status.Errorf(codes.Unimplemented, "method ReceiveChangeEvents not implemented")
}
func (*UnimplementedVolthaServiceServer) CreateEventFilter(ctx context.Context, req *EventFilter) (*EventFilter, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateEventFilter not implemented")
}
func (*UnimplementedVolthaServiceServer) GetEventFilter(ctx context.Context, req *common.ID) (*EventFilters, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetEventFilter not implemented")
}
func (*UnimplementedVolthaServiceServer) UpdateEventFilter(ctx context.Context, req *EventFilter) (*EventFilter, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateEventFilter not implemented")
}
func (*UnimplementedVolthaServiceServer) DeleteEventFilter(ctx context.Context, req *EventFilter) (*empty.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteEventFilter not implemented")
}
func (*UnimplementedVolthaServiceServer) ListEventFilters(ctx context.Context, req *empty.Empty) (*EventFilters, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListEventFilters not implemented")
}
func (*UnimplementedVolthaServiceServer) GetImages(ctx context.Context, req *common.ID) (*Images, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetImages not implemented")
}
func (*UnimplementedVolthaServiceServer) SelfTest(ctx context.Context, req *common.ID) (*SelfTestResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SelfTest not implemented")
}
func (*UnimplementedVolthaServiceServer) GetMibDeviceData(ctx context.Context, req *common.ID) (*omci.MibDeviceData, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetMibDeviceData not implemented")
}
func (*UnimplementedVolthaServiceServer) GetAlarmDeviceData(ctx context.Context, req *common.ID) (*omci.AlarmDeviceData, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetAlarmDeviceData not implemented")
}
func (*UnimplementedVolthaServiceServer) SimulateAlarm(ctx context.Context, req *SimulateAlarmRequest) (*common.OperationResp, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SimulateAlarm not implemented")
}
func (*UnimplementedVolthaServiceServer) EnablePort(ctx context.Context, req *Port) (*empty.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method EnablePort not implemented")
}
func (*UnimplementedVolthaServiceServer) DisablePort(ctx context.Context, req *Port) (*empty.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DisablePort not implemented")
}
func (*UnimplementedVolthaServiceServer) GetExtValue(ctx context.Context, req *extension.ValueSpecifier) (*extension.ReturnValues, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetExtValue not implemented")
}
func (*UnimplementedVolthaServiceServer) SetExtValue(ctx context.Context, req *extension.ValueSet) (*empty.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SetExtValue not implemented")
}
func (*UnimplementedVolthaServiceServer) StartOmciTestAction(ctx context.Context, req *omci.OmciTestRequest) (*omci.TestResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method StartOmciTestAction not implemented")
}

func RegisterVolthaServiceServer(s *grpc.Server, srv VolthaServiceServer) {
	s.RegisterService(&_VolthaService_serviceDesc, srv)
}

func _VolthaService_GetVoltha_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(empty.Empty)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VolthaServiceServer).GetVoltha(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/voltha.VolthaService/GetVoltha",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VolthaServiceServer).GetVoltha(ctx, req.(*empty.Empty))
	}
	return interceptor(ctx, in, info, handler)
}

func _VolthaService_ListCoreInstances_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(empty.Empty)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VolthaServiceServer).ListCoreInstances(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/voltha.VolthaService/ListCoreInstances",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VolthaServiceServer).ListCoreInstances(ctx, req.(*empty.Empty))
	}
	return interceptor(ctx, in, info, handler)
}

func _VolthaService_GetCoreInstance_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(common.ID)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VolthaServiceServer).GetCoreInstance(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/voltha.VolthaService/GetCoreInstance",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VolthaServiceServer).GetCoreInstance(ctx, req.(*common.ID))
	}
	return interceptor(ctx, in, info, handler)
}

func _VolthaService_ListAdapters_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(empty.Empty)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VolthaServiceServer).ListAdapters(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/voltha.VolthaService/ListAdapters",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VolthaServiceServer).ListAdapters(ctx, req.(*empty.Empty))
	}
	return interceptor(ctx, in, info, handler)
}

func _VolthaService_ListLogicalDevices_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(empty.Empty)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VolthaServiceServer).ListLogicalDevices(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/voltha.VolthaService/ListLogicalDevices",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VolthaServiceServer).ListLogicalDevices(ctx, req.(*empty.Empty))
	}
	return interceptor(ctx, in, info, handler)
}

func _VolthaService_GetLogicalDevice_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(common.ID)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VolthaServiceServer).GetLogicalDevice(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/voltha.VolthaService/GetLogicalDevice",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VolthaServiceServer).GetLogicalDevice(ctx, req.(*common.ID))
	}
	return interceptor(ctx, in, info, handler)
}

func _VolthaService_ListLogicalDevicePorts_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(common.ID)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VolthaServiceServer).ListLogicalDevicePorts(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/voltha.VolthaService/ListLogicalDevicePorts",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VolthaServiceServer).ListLogicalDevicePorts(ctx, req.(*common.ID))
	}
	return interceptor(ctx, in, info, handler)
}

func _VolthaService_GetLogicalDevicePort_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(LogicalPortId)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VolthaServiceServer).GetLogicalDevicePort(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/voltha.VolthaService/GetLogicalDevicePort",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VolthaServiceServer).GetLogicalDevicePort(ctx, req.(*LogicalPortId))
	}
	return interceptor(ctx, in, info, handler)
}

func _VolthaService_EnableLogicalDevicePort_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(LogicalPortId)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VolthaServiceServer).EnableLogicalDevicePort(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/voltha.VolthaService/EnableLogicalDevicePort",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VolthaServiceServer).EnableLogicalDevicePort(ctx, req.(*LogicalPortId))
	}
	return interceptor(ctx, in, info, handler)
}

func _VolthaService_DisableLogicalDevicePort_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(LogicalPortId)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VolthaServiceServer).DisableLogicalDevicePort(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/voltha.VolthaService/DisableLogicalDevicePort",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VolthaServiceServer).DisableLogicalDevicePort(ctx, req.(*LogicalPortId))
	}
	return interceptor(ctx, in, info, handler)
}

func _VolthaService_ListLogicalDeviceFlows_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(common.ID)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VolthaServiceServer).ListLogicalDeviceFlows(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/voltha.VolthaService/ListLogicalDeviceFlows",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VolthaServiceServer).ListLogicalDeviceFlows(ctx, req.(*common.ID))
	}
	return interceptor(ctx, in, info, handler)
}

func _VolthaService_UpdateLogicalDeviceFlowTable_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(openflow_13.FlowTableUpdate)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VolthaServiceServer).UpdateLogicalDeviceFlowTable(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/voltha.VolthaService/UpdateLogicalDeviceFlowTable",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VolthaServiceServer).UpdateLogicalDeviceFlowTable(ctx, req.(*openflow_13.FlowTableUpdate))
	}
	return interceptor(ctx, in, info, handler)
}

func _VolthaService_UpdateLogicalDeviceMeterTable_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(openflow_13.MeterModUpdate)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VolthaServiceServer).UpdateLogicalDeviceMeterTable(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/voltha.VolthaService/UpdateLogicalDeviceMeterTable",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VolthaServiceServer).UpdateLogicalDeviceMeterTable(ctx, req.(*openflow_13.MeterModUpdate))
	}
	return interceptor(ctx, in, info, handler)
}

func _VolthaService_ListLogicalDeviceMeters_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(common.ID)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VolthaServiceServer).ListLogicalDeviceMeters(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/voltha.VolthaService/ListLogicalDeviceMeters",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VolthaServiceServer).ListLogicalDeviceMeters(ctx, req.(*common.ID))
	}
	return interceptor(ctx, in, info, handler)
}

func _VolthaService_ListLogicalDeviceFlowGroups_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(common.ID)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VolthaServiceServer).ListLogicalDeviceFlowGroups(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/voltha.VolthaService/ListLogicalDeviceFlowGroups",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VolthaServiceServer).ListLogicalDeviceFlowGroups(ctx, req.(*common.ID))
	}
	return interceptor(ctx, in, info, handler)
}

func _VolthaService_UpdateLogicalDeviceFlowGroupTable_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(openflow_13.FlowGroupTableUpdate)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VolthaServiceServer).UpdateLogicalDeviceFlowGroupTable(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/voltha.VolthaService/UpdateLogicalDeviceFlowGroupTable",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VolthaServiceServer).UpdateLogicalDeviceFlowGroupTable(ctx, req.(*openflow_13.FlowGroupTableUpdate))
	}
	return interceptor(ctx, in, info, handler)
}

func _VolthaService_ListDevices_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(empty.Empty)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VolthaServiceServer).ListDevices(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/voltha.VolthaService/ListDevices",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VolthaServiceServer).ListDevices(ctx, req.(*empty.Empty))
	}
	return interceptor(ctx, in, info, handler)
}

func _VolthaService_ListDeviceIds_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(empty.Empty)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VolthaServiceServer).ListDeviceIds(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/voltha.VolthaService/ListDeviceIds",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VolthaServiceServer).ListDeviceIds(ctx, req.(*empty.Empty))
	}
	return interceptor(ctx, in, info, handler)
}

func _VolthaService_ReconcileDevices_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(common.IDs)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VolthaServiceServer).ReconcileDevices(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/voltha.VolthaService/ReconcileDevices",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VolthaServiceServer).ReconcileDevices(ctx, req.(*common.IDs))
	}
	return interceptor(ctx, in, info, handler)
}

func _VolthaService_GetDevice_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(common.ID)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VolthaServiceServer).GetDevice(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/voltha.VolthaService/GetDevice",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VolthaServiceServer).GetDevice(ctx, req.(*common.ID))
	}
	return interceptor(ctx, in, info, handler)
}

func _VolthaService_CreateDevice_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(Device)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VolthaServiceServer).CreateDevice(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/voltha.VolthaService/CreateDevice",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VolthaServiceServer).CreateDevice(ctx, req.(*Device))
	}
	return interceptor(ctx, in, info, handler)
}

func _VolthaService_EnableDevice_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(common.ID)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VolthaServiceServer).EnableDevice(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/voltha.VolthaService/EnableDevice",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VolthaServiceServer).EnableDevice(ctx, req.(*common.ID))
	}
	return interceptor(ctx, in, info, handler)
}

func _VolthaService_DisableDevice_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(common.ID)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VolthaServiceServer).DisableDevice(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/voltha.VolthaService/DisableDevice",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VolthaServiceServer).DisableDevice(ctx, req.(*common.ID))
	}
	return interceptor(ctx, in, info, handler)
}

func _VolthaService_RebootDevice_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(common.ID)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VolthaServiceServer).RebootDevice(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/voltha.VolthaService/RebootDevice",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VolthaServiceServer).RebootDevice(ctx, req.(*common.ID))
	}
	return interceptor(ctx, in, info, handler)
}

func _VolthaService_DeleteDevice_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(common.ID)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VolthaServiceServer).DeleteDevice(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/voltha.VolthaService/DeleteDevice",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VolthaServiceServer).DeleteDevice(ctx, req.(*common.ID))
	}
	return interceptor(ctx, in, info, handler)
}

func _VolthaService_ForceDeleteDevice_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(common.ID)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VolthaServiceServer).ForceDeleteDevice(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/voltha.VolthaService/ForceDeleteDevice",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VolthaServiceServer).ForceDeleteDevice(ctx, req.(*common.ID))
	}
	return interceptor(ctx, in, info, handler)
}

func _VolthaService_DownloadImage_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ImageDownload)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VolthaServiceServer).DownloadImage(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/voltha.VolthaService/DownloadImage",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VolthaServiceServer).DownloadImage(ctx, req.(*ImageDownload))
	}
	return interceptor(ctx, in, info, handler)
}

func _VolthaService_GetImageDownloadStatus_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ImageDownload)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VolthaServiceServer).GetImageDownloadStatus(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/voltha.VolthaService/GetImageDownloadStatus",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VolthaServiceServer).GetImageDownloadStatus(ctx, req.(*ImageDownload))
	}
	return interceptor(ctx, in, info, handler)
}

func _VolthaService_GetImageDownload_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ImageDownload)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VolthaServiceServer).GetImageDownload(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/voltha.VolthaService/GetImageDownload",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VolthaServiceServer).GetImageDownload(ctx, req.(*ImageDownload))
	}
	return interceptor(ctx, in, info, handler)
}

func _VolthaService_ListImageDownloads_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(common.ID)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VolthaServiceServer).ListImageDownloads(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/voltha.VolthaService/ListImageDownloads",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VolthaServiceServer).ListImageDownloads(ctx, req.(*common.ID))
	}
	return interceptor(ctx, in, info, handler)
}

func _VolthaService_CancelImageDownload_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ImageDownload)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VolthaServiceServer).CancelImageDownload(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/voltha.VolthaService/CancelImageDownload",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VolthaServiceServer).CancelImageDownload(ctx, req.(*ImageDownload))
	}
	return interceptor(ctx, in, info, handler)
}

func _VolthaService_ActivateImageUpdate_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ImageDownload)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VolthaServiceServer).ActivateImageUpdate(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/voltha.VolthaService/ActivateImageUpdate",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VolthaServiceServer).ActivateImageUpdate(ctx, req.(*ImageDownload))
	}
	return interceptor(ctx, in, info, handler)
}

func _VolthaService_RevertImageUpdate_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ImageDownload)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VolthaServiceServer).RevertImageUpdate(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/voltha.VolthaService/RevertImageUpdate",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VolthaServiceServer).RevertImageUpdate(ctx, req.(*ImageDownload))
	}
	return interceptor(ctx, in, info, handler)
}

func _VolthaService_DownloadImageToDevice_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeviceImageDownloadRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VolthaServiceServer).DownloadImageToDevice(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/voltha.VolthaService/DownloadImageToDevice",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VolthaServiceServer).DownloadImageToDevice(ctx, req.(*DeviceImageDownloadRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VolthaService_GetImageStatus_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeviceImageRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VolthaServiceServer).GetImageStatus(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/voltha.VolthaService/GetImageStatus",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VolthaServiceServer).GetImageStatus(ctx, req.(*DeviceImageRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VolthaService_AbortImageUpgradeToDevice_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeviceImageRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VolthaServiceServer).AbortImageUpgradeToDevice(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/voltha.VolthaService/AbortImageUpgradeToDevice",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VolthaServiceServer).AbortImageUpgradeToDevice(ctx, req.(*DeviceImageRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VolthaService_GetOnuImages_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(common.ID)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VolthaServiceServer).GetOnuImages(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/voltha.VolthaService/GetOnuImages",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VolthaServiceServer).GetOnuImages(ctx, req.(*common.ID))
	}
	return interceptor(ctx, in, info, handler)
}

func _VolthaService_ActivateImage_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeviceImageRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VolthaServiceServer).ActivateImage(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/voltha.VolthaService/ActivateImage",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VolthaServiceServer).ActivateImage(ctx, req.(*DeviceImageRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VolthaService_CommitImage_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeviceImageRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VolthaServiceServer).CommitImage(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/voltha.VolthaService/CommitImage",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VolthaServiceServer).CommitImage(ctx, req.(*DeviceImageRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VolthaService_ListDevicePorts_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(common.ID)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VolthaServiceServer).ListDevicePorts(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/voltha.VolthaService/ListDevicePorts",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VolthaServiceServer).ListDevicePorts(ctx, req.(*common.ID))
	}
	return interceptor(ctx, in, info, handler)
}

func _VolthaService_ListDevicePmConfigs_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(common.ID)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VolthaServiceServer).ListDevicePmConfigs(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/voltha.VolthaService/ListDevicePmConfigs",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VolthaServiceServer).ListDevicePmConfigs(ctx, req.(*common.ID))
	}
	return interceptor(ctx, in, info, handler)
}

func _VolthaService_UpdateDevicePmConfigs_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(PmConfigs)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VolthaServiceServer).UpdateDevicePmConfigs(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/voltha.VolthaService/UpdateDevicePmConfigs",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VolthaServiceServer).UpdateDevicePmConfigs(ctx, req.(*PmConfigs))
	}
	return interceptor(ctx, in, info, handler)
}

func _VolthaService_ListDeviceFlows_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(common.ID)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VolthaServiceServer).ListDeviceFlows(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/voltha.VolthaService/ListDeviceFlows",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VolthaServiceServer).ListDeviceFlows(ctx, req.(*common.ID))
	}
	return interceptor(ctx, in, info, handler)
}

func _VolthaService_ListDeviceFlowGroups_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(common.ID)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VolthaServiceServer).ListDeviceFlowGroups(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/voltha.VolthaService/ListDeviceFlowGroups",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VolthaServiceServer).ListDeviceFlowGroups(ctx, req.(*common.ID))
	}
	return interceptor(ctx, in, info, handler)
}

func _VolthaService_ListDeviceTypes_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(empty.Empty)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VolthaServiceServer).ListDeviceTypes(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/voltha.VolthaService/ListDeviceTypes",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VolthaServiceServer).ListDeviceTypes(ctx, req.(*empty.Empty))
	}
	return interceptor(ctx, in, info, handler)
}

func _VolthaService_GetDeviceType_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(common.ID)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VolthaServiceServer).GetDeviceType(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/voltha.VolthaService/GetDeviceType",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VolthaServiceServer).GetDeviceType(ctx, req.(*common.ID))
	}
	return interceptor(ctx, in, info, handler)
}

func _VolthaService_StreamPacketsOut_Handler(srv interface{}, stream grpc.ServerStream) error {
	return srv.(VolthaServiceServer).StreamPacketsOut(&volthaServiceStreamPacketsOutServer{stream})
}

type VolthaService_StreamPacketsOutServer interface {
	SendAndClose(*empty.Empty) error
	Recv() (*openflow_13.PacketOut, error)
	grpc.ServerStream
}

type volthaServiceStreamPacketsOutServer struct {
	grpc.ServerStream
}

func (x *volthaServiceStreamPacketsOutServer) SendAndClose(m *empty.Empty) error {
	return x.ServerStream.SendMsg(m)
}

func (x *volthaServiceStreamPacketsOutServer) Recv() (*openflow_13.PacketOut, error) {
	m := new(openflow_13.PacketOut)
	if err := x.ServerStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func _VolthaService_ReceivePacketsIn_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(empty.Empty)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(VolthaServiceServer).ReceivePacketsIn(m, &volthaServiceReceivePacketsInServer{stream})
}

type VolthaService_ReceivePacketsInServer interface {
	Send(*openflow_13.PacketIn) error
	grpc.ServerStream
}

type volthaServiceReceivePacketsInServer struct {
	grpc.ServerStream
}

func (x *volthaServiceReceivePacketsInServer) Send(m *openflow_13.PacketIn) error {
	return x.ServerStream.SendMsg(m)
}

func _VolthaService_ReceiveChangeEvents_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(empty.Empty)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(VolthaServiceServer).ReceiveChangeEvents(m, &volthaServiceReceiveChangeEventsServer{stream})
}

type VolthaService_ReceiveChangeEventsServer interface {
	Send(*openflow_13.ChangeEvent) error
	grpc.ServerStream
}

type volthaServiceReceiveChangeEventsServer struct {
	grpc.ServerStream
}

func (x *volthaServiceReceiveChangeEventsServer) Send(m *openflow_13.ChangeEvent) error {
	return x.ServerStream.SendMsg(m)
}

func _VolthaService_CreateEventFilter_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(EventFilter)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VolthaServiceServer).CreateEventFilter(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/voltha.VolthaService/CreateEventFilter",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VolthaServiceServer).CreateEventFilter(ctx, req.(*EventFilter))
	}
	return interceptor(ctx, in, info, handler)
}

func _VolthaService_GetEventFilter_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(common.ID)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VolthaServiceServer).GetEventFilter(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/voltha.VolthaService/GetEventFilter",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VolthaServiceServer).GetEventFilter(ctx, req.(*common.ID))
	}
	return interceptor(ctx, in, info, handler)
}

func _VolthaService_UpdateEventFilter_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(EventFilter)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VolthaServiceServer).UpdateEventFilter(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/voltha.VolthaService/UpdateEventFilter",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VolthaServiceServer).UpdateEventFilter(ctx, req.(*EventFilter))
	}
	return interceptor(ctx, in, info, handler)
}

func _VolthaService_DeleteEventFilter_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(EventFilter)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VolthaServiceServer).DeleteEventFilter(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/voltha.VolthaService/DeleteEventFilter",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VolthaServiceServer).DeleteEventFilter(ctx, req.(*EventFilter))
	}
	return interceptor(ctx, in, info, handler)
}

func _VolthaService_ListEventFilters_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(empty.Empty)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VolthaServiceServer).ListEventFilters(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/voltha.VolthaService/ListEventFilters",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VolthaServiceServer).ListEventFilters(ctx, req.(*empty.Empty))
	}
	return interceptor(ctx, in, info, handler)
}

func _VolthaService_GetImages_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(common.ID)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VolthaServiceServer).GetImages(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/voltha.VolthaService/GetImages",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VolthaServiceServer).GetImages(ctx, req.(*common.ID))
	}
	return interceptor(ctx, in, info, handler)
}

func _VolthaService_SelfTest_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(common.ID)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VolthaServiceServer).SelfTest(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/voltha.VolthaService/SelfTest",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VolthaServiceServer).SelfTest(ctx, req.(*common.ID))
	}
	return interceptor(ctx, in, info, handler)
}

func _VolthaService_GetMibDeviceData_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(common.ID)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VolthaServiceServer).GetMibDeviceData(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/voltha.VolthaService/GetMibDeviceData",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VolthaServiceServer).GetMibDeviceData(ctx, req.(*common.ID))
	}
	return interceptor(ctx, in, info, handler)
}

func _VolthaService_GetAlarmDeviceData_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(common.ID)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VolthaServiceServer).GetAlarmDeviceData(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/voltha.VolthaService/GetAlarmDeviceData",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VolthaServiceServer).GetAlarmDeviceData(ctx, req.(*common.ID))
	}
	return interceptor(ctx, in, info, handler)
}

func _VolthaService_SimulateAlarm_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SimulateAlarmRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VolthaServiceServer).SimulateAlarm(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/voltha.VolthaService/SimulateAlarm",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VolthaServiceServer).SimulateAlarm(ctx, req.(*SimulateAlarmRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VolthaService_EnablePort_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(Port)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VolthaServiceServer).EnablePort(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/voltha.VolthaService/EnablePort",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VolthaServiceServer).EnablePort(ctx, req.(*Port))
	}
	return interceptor(ctx, in, info, handler)
}

func _VolthaService_DisablePort_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(Port)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VolthaServiceServer).DisablePort(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/voltha.VolthaService/DisablePort",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VolthaServiceServer).DisablePort(ctx, req.(*Port))
	}
	return interceptor(ctx, in, info, handler)
}

func _VolthaService_GetExtValue_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(extension.ValueSpecifier)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VolthaServiceServer).GetExtValue(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/voltha.VolthaService/GetExtValue",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VolthaServiceServer).GetExtValue(ctx, req.(*extension.ValueSpecifier))
	}
	return interceptor(ctx, in, info, handler)
}

func _VolthaService_SetExtValue_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(extension.ValueSet)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VolthaServiceServer).SetExtValue(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/voltha.VolthaService/SetExtValue",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VolthaServiceServer).SetExtValue(ctx, req.(*extension.ValueSet))
	}
	return interceptor(ctx, in, info, handler)
}

func _VolthaService_StartOmciTestAction_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(omci.OmciTestRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VolthaServiceServer).StartOmciTestAction(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/voltha.VolthaService/StartOmciTestAction",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VolthaServiceServer).StartOmciTestAction(ctx, req.(*omci.OmciTestRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _VolthaService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "voltha.VolthaService",
	HandlerType: (*VolthaServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "GetVoltha",
			Handler:    _VolthaService_GetVoltha_Handler,
		},
		{
			MethodName: "ListCoreInstances",
			Handler:    _VolthaService_ListCoreInstances_Handler,
		},
		{
			MethodName: "GetCoreInstance",
			Handler:    _VolthaService_GetCoreInstance_Handler,
		},
		{
			MethodName: "ListAdapters",
			Handler:    _VolthaService_ListAdapters_Handler,
		},
		{
			MethodName: "ListLogicalDevices",
			Handler:    _VolthaService_ListLogicalDevices_Handler,
		},
		{
			MethodName: "GetLogicalDevice",
			Handler:    _VolthaService_GetLogicalDevice_Handler,
		},
		{
			MethodName: "ListLogicalDevicePorts",
			Handler:    _VolthaService_ListLogicalDevicePorts_Handler,
		},
		{
			MethodName: "GetLogicalDevicePort",
			Handler:    _VolthaService_GetLogicalDevicePort_Handler,
		},
		{
			MethodName: "EnableLogicalDevicePort",
			Handler:    _VolthaService_EnableLogicalDevicePort_Handler,
		},
		{
			MethodName: "DisableLogicalDevicePort",
			Handler:    _VolthaService_DisableLogicalDevicePort_Handler,
		},
		{
			MethodName: "ListLogicalDeviceFlows",
			Handler:    _VolthaService_ListLogicalDeviceFlows_Handler,
		},
		{
			MethodName: "UpdateLogicalDeviceFlowTable",
			Handler:    _VolthaService_UpdateLogicalDeviceFlowTable_Handler,
		},
		{
			MethodName: "UpdateLogicalDeviceMeterTable",
			Handler:    _VolthaService_UpdateLogicalDeviceMeterTable_Handler,
		},
		{
			MethodName: "ListLogicalDeviceMeters",
			Handler:    _VolthaService_ListLogicalDeviceMeters_Handler,
		},
		{
			MethodName: "ListLogicalDeviceFlowGroups",
			Handler:    _VolthaService_ListLogicalDeviceFlowGroups_Handler,
		},
		{
			MethodName: "UpdateLogicalDeviceFlowGroupTable",
			Handler:    _VolthaService_UpdateLogicalDeviceFlowGroupTable_Handler,
		},
		{
			MethodName: "ListDevices",
			Handler:    _VolthaService_ListDevices_Handler,
		},
		{
			MethodName: "ListDeviceIds",
			Handler:    _VolthaService_ListDeviceIds_Handler,
		},
		{
			MethodName: "ReconcileDevices",
			Handler:    _VolthaService_ReconcileDevices_Handler,
		},
		{
			MethodName: "GetDevice",
			Handler:    _VolthaService_GetDevice_Handler,
		},
		{
			MethodName: "CreateDevice",
			Handler:    _VolthaService_CreateDevice_Handler,
		},
		{
			MethodName: "EnableDevice",
			Handler:    _VolthaService_EnableDevice_Handler,
		},
		{
			MethodName: "DisableDevice",
			Handler:    _VolthaService_DisableDevice_Handler,
		},
		{
			MethodName: "RebootDevice",
			Handler:    _VolthaService_RebootDevice_Handler,
		},
		{
			MethodName: "DeleteDevice",
			Handler:    _VolthaService_DeleteDevice_Handler,
		},
		{
			MethodName: "ForceDeleteDevice",
			Handler:    _VolthaService_ForceDeleteDevice_Handler,
		},
		{
			MethodName: "DownloadImage",
			Handler:    _VolthaService_DownloadImage_Handler,
		},
		{
			MethodName: "GetImageDownloadStatus",
			Handler:    _VolthaService_GetImageDownloadStatus_Handler,
		},
		{
			MethodName: "GetImageDownload",
			Handler:    _VolthaService_GetImageDownload_Handler,
		},
		{
			MethodName: "ListImageDownloads",
			Handler:    _VolthaService_ListImageDownloads_Handler,
		},
		{
			MethodName: "CancelImageDownload",
			Handler:    _VolthaService_CancelImageDownload_Handler,
		},
		{
			MethodName: "ActivateImageUpdate",
			Handler:    _VolthaService_ActivateImageUpdate_Handler,
		},
		{
			MethodName: "RevertImageUpdate",
			Handler:    _VolthaService_RevertImageUpdate_Handler,
		},
		{
			MethodName: "DownloadImageToDevice",
			Handler:    _VolthaService_DownloadImageToDevice_Handler,
		},
		{
			MethodName: "GetImageStatus",
			Handler:    _VolthaService_GetImageStatus_Handler,
		},
		{
			MethodName: "AbortImageUpgradeToDevice",
			Handler:    _VolthaService_AbortImageUpgradeToDevice_Handler,
		},
		{
			MethodName: "GetOnuImages",
			Handler:    _VolthaService_GetOnuImages_Handler,
		},
		{
			MethodName: "ActivateImage",
			Handler:    _VolthaService_ActivateImage_Handler,
		},
		{
			MethodName: "CommitImage",
			Handler:    _VolthaService_CommitImage_Handler,
		},
		{
			MethodName: "ListDevicePorts",
			Handler:    _VolthaService_ListDevicePorts_Handler,
		},
		{
			MethodName: "ListDevicePmConfigs",
			Handler:    _VolthaService_ListDevicePmConfigs_Handler,
		},
		{
			MethodName: "UpdateDevicePmConfigs",
			Handler:    _VolthaService_UpdateDevicePmConfigs_Handler,
		},
		{
			MethodName: "ListDeviceFlows",
			Handler:    _VolthaService_ListDeviceFlows_Handler,
		},
		{
			MethodName: "ListDeviceFlowGroups",
			Handler:    _VolthaService_ListDeviceFlowGroups_Handler,
		},
		{
			MethodName: "ListDeviceTypes",
			Handler:    _VolthaService_ListDeviceTypes_Handler,
		},
		{
			MethodName: "GetDeviceType",
			Handler:    _VolthaService_GetDeviceType_Handler,
		},
		{
			MethodName: "CreateEventFilter",
			Handler:    _VolthaService_CreateEventFilter_Handler,
		},
		{
			MethodName: "GetEventFilter",
			Handler:    _VolthaService_GetEventFilter_Handler,
		},
		{
			MethodName: "UpdateEventFilter",
			Handler:    _VolthaService_UpdateEventFilter_Handler,
		},
		{
			MethodName: "DeleteEventFilter",
			Handler:    _VolthaService_DeleteEventFilter_Handler,
		},
		{
			MethodName: "ListEventFilters",
			Handler:    _VolthaService_ListEventFilters_Handler,
		},
		{
			MethodName: "GetImages",
			Handler:    _VolthaService_GetImages_Handler,
		},
		{
			MethodName: "SelfTest",
			Handler:    _VolthaService_SelfTest_Handler,
		},
		{
			MethodName: "GetMibDeviceData",
			Handler:    _VolthaService_GetMibDeviceData_Handler,
		},
		{
			MethodName: "GetAlarmDeviceData",
			Handler:    _VolthaService_GetAlarmDeviceData_Handler,
		},
		{
			MethodName: "SimulateAlarm",
			Handler:    _VolthaService_SimulateAlarm_Handler,
		},
		{
			MethodName: "EnablePort",
			Handler:    _VolthaService_EnablePort_Handler,
		},
		{
			MethodName: "DisablePort",
			Handler:    _VolthaService_DisablePort_Handler,
		},
		{
			MethodName: "GetExtValue",
			Handler:    _VolthaService_GetExtValue_Handler,
		},
		{
			MethodName: "SetExtValue",
			Handler:    _VolthaService_SetExtValue_Handler,
		},
		{
			MethodName: "StartOmciTestAction",
			Handler:    _VolthaService_StartOmciTestAction_Handler,
		},
	},
	Streams: []grpc.StreamDesc{
		{
			StreamName:    "StreamPacketsOut",
			Handler:       _VolthaService_StreamPacketsOut_Handler,
			ClientStreams: true,
		},
		{
			StreamName:    "ReceivePacketsIn",
			Handler:       _VolthaService_ReceivePacketsIn_Handler,
			ServerStreams: true,
		},
		{
			StreamName:    "ReceiveChangeEvents",
			Handler:       _VolthaService_ReceiveChangeEvents_Handler,
			ServerStreams: true,
		},
	},
	Metadata: "voltha_protos/voltha.proto",
}
