# XOS UI Development

This configuration launches the XOS GUI and database in separate containers
using docker-compose.  The Synchronizer is not started and there is no openstack backend connected for XOS.  This configuration is intended for developing the XOS GUI.

## Getting Started

- Navigate to `/service-profile/configurations/frontend` folder
- Run `make` command

You'll be able to visit XOS at `0.0.0.0:9000` and the `xos/core/xoslib` folder is shared with the container. This means that any update to that folder is automatically reported in the container.

### Working on the Django Application
If you need to work on the Django application itself:
- comment out the `sleep 86400` command for the `xos_bootstrap_ui` container in `docker-compose-bootstrap.yml`
- comment the `python /opt/xos/manage.py runserver 0.0.0.0:9998 --insecure --makemigrations` in the same file
- run `make containers`.
- run `make`

You'll notice that the `make` command will hang on to `Waiting for XOS to start listening on port 9998`, so in another shell:
- run `make enter-bootstrap-ui`, this will bring you inside the running bootstrap container
- from inside the bootstrap container run `python /opt/xos/manage.py runserver 0.0.0.0:9998 --insecure --makemigrations`

As this command finish his execution you'll notice that the `make` command will resume and end. Once it has endend your development environment is up and running. 

If you are working on core files (not involving services) you can use the `bootstrap_ui` container as target, so connect to port `9998`. To simplify the development `xos/core` and `xos/api/utility` folders are shared between the host filesystem and the container, so you don't have to manually copy file inside the the running `bootstrap_ui` container.

If instead you are working on services or services API your target container should be the `ui` container, so connect to port `9999`. Note that the `ui` container can be rebuilt from the `synchronizer` container, and it will pull the container in the docker registry, not your local one.

> _NOTE:
> Please be careful and do not commit migrations, private keys or other autogenerated files._


### Using Vagrant

Vagrant environment is provided with a ubuntu_14.04 box (ubuntu/trusty64). 

It will run xos on the following address `192.168.46.100:9999`. 
It will also share the `service-profile` and `xos` folder with the vagrant box. These two directory are intended to be side by side.

How to set it up:
- Start the Vagrant box: `vagrant up`
- Enter Vagrant box: `vagrant ssh`
- Start XOS: `cd /opt/service-profile/frontend` and run `make`

### Docker Helpers

Stop the containers: `make stop`

Restart the containers: `make stop; make`

Delete the containers and relaunch them: `make rm; make`

Build the containers from scratch using the local XOS source tree: `make containers`

View logs: `make showlogs`

See what containers are running: `make ps`

Open a shell on the XOS container: `make enter-xos`

## Docs

You can find a Swagger documentation for endpoint at: `http://0.0.0.0:9000/docs/`

## Populate the Data Model with custom data

Sometimes while developing the GUI is usefull to have control over the DataModel. Sample `tosca` recipes for different configuration are defined in the `mocks` folder, and corresponding `make` commands are provided.

- Bring up the **CORD** data model: `make mock-cord`
- - Bring up the **M-CORD** data model: `make mock-mcord`

## JS Styleguide

This project is following [Google JavaScript Style Guide](https://google.github.io/styleguide/javascriptguide.xml). To contribute please install [Eslint](http://eslint.org/) in your editor and run `npm run eslint` before commit.

> _NOTE_:
> Many of the already present file were not Style compliant. Linting for them has been disabled as it was to time consuming fix all of them. If **you are going to work** on that files, please **start fixing style issues**, and then **remove the `/* eslint-disable */`** comment
