{{/* vim: set filetype=mustache: */}}
{{/*
SPDX-FileCopyrightText: 2020-present Open Networking Foundation <info@opennetworking.org>
SPDX-License-Identifier: Apache-2.0

Expand the name of the chart.
*/}}
{{- define "aether.name" -}}
{{- default .Chart.Name .Values.nameOverride | trunc 63 | trimSuffix "-" -}}
{{- end -}}

{{/*
Create a default fully qualified app name.
We truncate at 63 chars because some Kubernetes name fields are limited to this (by the DNS naming spec).
If release name contains chart name it will be used as a full name.
*/}}
{{- define "aether.fullname" -}}
{{- if contains "config-model-aether" .Release.Name -}}
{{- printf "%s-%s" .Release.Name .Chart.AppVersion | trunc 63 | trimSuffix "-" -}}
{{- else -}}
{{- printf "%s-%s-config-model-aether" .Release.Name .Chart.AppVersion | trunc 63 | trimSuffix "-" -}}
{{- end -}}
{{- end -}}

{{/*
Create chart name and version as used by the chart label.
*/}}
{{- define "aether.chart" -}}
{{- printf "%s-%s" .Chart.Name .Chart.Version | replace "+" "_" | trunc 63 | trimSuffix "-" -}}
{{- end -}}


{{/*
Common labels
*/}}
{{- define "aether.labels" -}}
helm.sh/chart: {{ include "aether.chart" . }}
{{ include "aether.selectorLabels" . }}
{{- if .Chart.AppVersion }}
app.kubernetes.io/version: {{ .Chart.AppVersion | quote }}
{{- end }}
app.kubernetes.io/managed-by: {{ .Release.Service }}
{{- end -}}

{{/*
Selector labels
*/}}
{{- define "aether.selectorLabels" -}}
app.kubernetes.io/name: {{ include "aether.name" . }}
app.kubernetes.io/instance: {{ .Release.Name }}
{{- end -}}
}
