# Copyright 2017-present Open Networking Foundation
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
# http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# -*- coding: utf-8 -*-
# Generated by Django 1.11.11 on 2019-02-21 01:31
from __future__ import unicode_literals

import core.models.xosbase_header
from django.conf import settings
import django.core.validators
from django.db import migrations, models
import django.db.models.deletion
import django.utils.timezone


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        ('core', '0002_initial_data'),
    ]

    operations = [
        migrations.CreateModel(
            name='RCORDIpAddress_decl',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', models.DateTimeField(auto_now_add=True, help_text=b'Time this model was created')),
                ('updated', models.DateTimeField(default=django.utils.timezone.now, help_text=b'Time this model was changed by a non-synchronizer')),
                ('enacted', models.DateTimeField(blank=True, default=None, help_text=b'When synced, set to the timestamp of the data that was synced', null=True)),
                ('policed', models.DateTimeField(blank=True, default=None, help_text=b'When policed, set to the timestamp of the data that was policed', null=True)),
                ('backend_register', models.CharField(blank=True, default=b'{}', max_length=1024, null=True)),
                ('backend_need_delete', models.BooleanField(default=False)),
                ('backend_need_reap', models.BooleanField(default=False)),
                ('backend_status', models.CharField(default=b'Provisioning in progress', max_length=1024, null=True)),
                ('backend_code', models.IntegerField(default=0)),
                ('deleted', models.BooleanField(default=False)),
                ('write_protect', models.BooleanField(default=False)),
                ('lazy_blocked', models.BooleanField(default=False)),
                ('no_sync', models.BooleanField(default=False)),
                ('no_policy', models.BooleanField(default=False)),
                ('policy_status', models.CharField(blank=True, default=b'Policy in process', max_length=1024, null=True)),
                ('policy_code', models.IntegerField(blank=True, default=0, null=True)),
                ('leaf_model_name', models.CharField(help_text=b'The most specialized model in this chain of inheritance, often defined by a service developer', max_length=1024)),
                ('backend_need_delete_policy', models.BooleanField(default=False, help_text=b'True if delete model_policy must be run before object can be reaped')),
                ('xos_managed', models.BooleanField(default=True, help_text=b'True if xos is responsible for creating/deleting this object')),
                ('backend_handle', models.CharField(blank=True, help_text=b'Handle used by the backend to track this object', max_length=1024, null=True)),
                ('changed_by_step', models.DateTimeField(blank=True, default=None, help_text=b'Time this model was changed by a sync step', null=True)),
                ('changed_by_policy', models.DateTimeField(blank=True, default=None, help_text=b'Time this model was changed by a model policy', null=True)),
                ('ip', models.CharField(help_text=b'The unique IP address (either IPv4 or IPv6 / netmask)', max_length=52)),
                ('description', models.CharField(blank=True, help_text=b'A short description of the IP address', max_length=254, null=True)),
            ],
            options={
                'verbose_name': 'IP address',
            },
            bases=(models.Model, core.models.xosbase_header.PlModelMixIn),
        ),
        migrations.CreateModel(
            name='RCORDService_decl',
            fields=[
                ('service_decl_ptr', models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True, primary_key=True, serialize=False, to='core.Service_decl')),
                ('access', models.CharField(choices=[(b'voltha', b'VOLTHA'), (b'unknown', b'Unknown')], default=b'voltha', help_text=b'Name of service that is managing the Access Network', max_length=30)),
            ],
            options={
                'verbose_name': 'RCORD Service',
            },
            bases=('core.service',),
        ),
        migrations.CreateModel(
            name='RCORDSubscriber_decl',
            fields=[
                ('serviceinstance_decl_ptr', models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True, primary_key=True, serialize=False, to='core.ServiceInstance_decl')),
                ('status', core.models.xosbase_header.StrippedCharField(blank=True, choices=[(b'enabled', b'Enabled'), (b'disabled', b'Disabled'), (b'pre-provisioned', b'Pre Provisioned'), (b'awaiting-auth', b'Awaiting Authentication'), (b'auth-failed', b'Authentication Failed')], default=b'enabled', help_text=b'Status of subscriber provisioning and authentication', max_length=30, null=True)),
                ('c_tag', models.IntegerField(blank=True, help_text=b"Customer VLAN Tag, one half of the double-tag that identifies this subscriber's traffic", null=True, validators=[django.core.validators.MaxValueValidator(4096), django.core.validators.MinValueValidator(0)])),
                ('s_tag', models.IntegerField(blank=True, help_text=b"Service VLAN Tag, one half of the double-tag that identifies this subscriber's traffic", null=True, validators=[django.core.validators.MaxValueValidator(4096), django.core.validators.MinValueValidator(0)])),
                ('onu_device', models.TextField(help_text=b'ONUDevice serial number')),
                ('mac_address', models.TextField(blank=True, help_text=b'Subscriber MAC Address', null=True)),
                ('nas_port_id', models.TextField(blank=True, help_text=b'NAS Port ID used in Radius to identify physical interface used to authenticate subscriber', null=True)),
                ('circuit_id', models.TextField(blank=True, help_text=b'Option 82 Circuit ID for DHCP relay agent', null=True)),
                ('remote_id', models.TextField(blank=True, help_text=b'Option 82 Remote ID for DHCP relay agent', null=True)),
                ('creator', models.ForeignKey(blank=True, help_text=b'User who created this RCORDSubscriber object', null=True, on_delete=django.db.models.deletion.CASCADE, related_name='created_rcord_subscribers', to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'verbose_name': 'RCORD Subscriber',
            },
            bases=('core.serviceinstance',),
        ),
        migrations.AddField(
            model_name='rcordipaddress_decl',
            name='subscriber',
            field=models.ForeignKey(help_text=b'The subscriber the IP address belongs to', on_delete=django.db.models.deletion.CASCADE, related_name='ips', to='rcord.RCORDSubscriber_decl'),
        ),
        migrations.CreateModel(
            name='RCORDIpAddress',
            fields=[
            ],
            options={
                'proxy': True,
                'indexes': [],
            },
            bases=('rcord.rcordipaddress_decl',),
        ),
        migrations.CreateModel(
            name='RCORDService',
            fields=[
            ],
            options={
                'proxy': True,
                'indexes': [],
            },
            bases=('rcord.rcordservice_decl',),
        ),
        migrations.CreateModel(
            name='RCORDSubscriber',
            fields=[
            ],
            options={
                'proxy': True,
                'indexes': [],
            },
            bases=('rcord.rcordsubscriber_decl',),
        ),
        migrations.AlterUniqueTogether(
            name='rcordipaddress_decl',
            unique_together=set([('subscriber', 'ip')]),
        ),
    ]
