/*
 * Copyright 2021-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */
package org.opencord.pppoeagent.impl;

import com.google.common.collect.ImmutableSet;

import java.util.Set;

/**
 * Represents PPPoE agent counters type.
 */
public enum PppoeAgentCounterNames {
    /**
     * Number of PADI messages received from client.
     */
    PADI,
    /**
     * Number of PADO messages received from server.
     */
    PADO,
    /**
     * Number of PADR messages received from client.
     */
    PADR,
    /**
     * Number of PADS messages received from server.
     */
    PADS,
    /**
     * Number of PADT messages received from server.
     */
    PADT_FROM_SERVER,
    /**
     * Number of PADT messages received from client.
     */
    PADT_FROM_CLIENT,
    /**
     * Number of PPPoED messages sent to server.
     */
    PPPOED_PACKETS_TO_SERVER,
    /**
     * Number  of PPPoED messages received from server.
     */
    PPPOED_PACKETS_FROM_SERVER,
    /**
     * Number of MTU Exceeded errors generated by the PPPoED agent.
     */
    MTU_EXCEEDED,
    /**
     * Number of Generic Errors received from server.
     */
    GENERIC_ERROR_FROM_SERVER,
    /**
     * Number of Generic Errors received from client.
     */
    GENERIC_ERROR_FROM_CLIENT,
    /**
     * Number of ServiceName Errors received from server.
     */
    SERVICE_NAME_ERROR,
    /**
     * Number of AC-System Errors received from server.
     */
    AC_SYSTEM_ERROR;

    /**
     * Supported types of PPPoED agent counters.
     */
    public  static final Set<PppoeAgentCounterNames> SUPPORTED_COUNTERS = ImmutableSet.of(
            PppoeAgentCounterNames.PADI, PppoeAgentCounterNames.PADO,
            PppoeAgentCounterNames.PADR, PppoeAgentCounterNames.PADS,
            PppoeAgentCounterNames.PADT_FROM_SERVER, PppoeAgentCounterNames.PADT_FROM_CLIENT,
            PppoeAgentCounterNames.PPPOED_PACKETS_TO_SERVER, PppoeAgentCounterNames.PPPOED_PACKETS_FROM_SERVER,
            PppoeAgentCounterNames.MTU_EXCEEDED, PppoeAgentCounterNames.GENERIC_ERROR_FROM_SERVER,
            PppoeAgentCounterNames.GENERIC_ERROR_FROM_CLIENT, PppoeAgentCounterNames.SERVICE_NAME_ERROR,
            PppoeAgentCounterNames.AC_SYSTEM_ERROR);
}