/*-
 * ============LICENSE_START=======================================================
 * OSAM
 * ================================================================================
 * Copyright (C) 2018 AT&T
 * ================================================================================
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * ============LICENSE_END=========================================================
 */



package org.onap.osam.roles;

import org.junit.Test;
import org.onap.osam.mso.rest.RequestDetails;

public class RoleValidatorTest {

    private RoleValidator createTestSubject() {
        return new RoleValidator(null);
    }

    @Test
    public void testIsMsoRequestValid() throws Exception {
        RoleValidator testSubject;
        RequestDetails mso_request = null;
        boolean result;

        // default test
        testSubject = createTestSubject();
        result = testSubject.isMsoRequestValid(mso_request);
    }

    @Test
    public void testIsServicePermitted() throws Exception {
        RoleValidator testSubject;
        String subscriberName = "";
        String serviceType = "";
        boolean result;

        // default test
        testSubject = createTestSubject();
        result = testSubject.isServicePermitted(subscriberName, serviceType);
    }

    @Test
    public void testIsSubscriberPermitted() throws Exception {
        RoleValidator testSubject;
        String subscriberName = "";
        boolean result;

        // default test
        testSubject = createTestSubject();
        result = testSubject.isSubscriberPermitted(subscriberName);
    }

    @Test
    public void testIsTenantPermitted() throws Exception {
        RoleValidator testSubject;
        String globalCustomerId = "";
        String serviceType = "";
        String tenantName = "";
        boolean result;

        // default test
        testSubject = createTestSubject();
        result = testSubject.isTenantPermitted(globalCustomerId, serviceType, tenantName);
    }

}
