/*-
 * ============LICENSE_START=======================================================
 * OSAM
 * ================================================================================
 * Copyright (C) 2018 AT&T
 * ================================================================================
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * ============LICENSE_END=========================================================
 */



package org.onap.osam.model.probes;

import org.springframework.http.HttpMethod;

public class HttpRequestMetadata extends StatusMetadata {
    private final HttpMethod httpMethod;
    private final int httpCode;
    private final String url;
    private final String rawData;

    public HttpRequestMetadata(HttpMethod httpMethod, int httpCode, String url, String rawData, String description, long duration) {
        super(description, duration);
        this.httpMethod = httpMethod;
        this.url = url;
        this.httpCode = httpCode;
        this.rawData = rawData;
    }

    public HttpMethod getHttpMethod() {
        return httpMethod;
    }

    public int getHttpCode() {
        return httpCode;
    }

    public String getUrl() {
        return url;
    }

    public String getRawData() {
        return rawData;
    }
}
