/*-
 * ============LICENSE_START=======================================================
 * OSAM
 * ================================================================================
 * Copyright (C) 2018 AT&T
 * ================================================================================
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * ============LICENSE_END=========================================================
 */



package org.onap.osam.controllers;

import org.onap.osam.exceptions.GenericUncheckedException;
import org.onap.osam.model.ExceptionResponse;
import org.onap.osam.model.JobBulk;
import org.onap.osam.model.JobModel;
import org.onap.osam.services.IBulkInstantiationService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;

import javax.ws.rs.WebApplicationException;
import java.util.Map;
import java.util.UUID;

import static org.springframework.http.HttpStatus.BAD_REQUEST;

@RestController
@RequestMapping("asyncForTests")
public class AsyncControllerForTests extends OsamCoreRestrictedBaseController {

    private IBulkInstantiationService bulkInstantiationService;

    @Autowired
    public AsyncControllerForTests(IBulkInstantiationService bulkInstantiationService) {
        this.bulkInstantiationService = bulkInstantiationService;
    }

    @RequestMapping(method = RequestMethod.POST)
    public JobBulk createAsyncJob(@RequestBody Map<String, Object> body) {
        return bulkInstantiationService.saveBulk(body);
    }

    @RequestMapping(value = "/job/{uuid}", method = RequestMethod.GET)
    public JobModel getJob(@PathVariable UUID uuid) {
        return bulkInstantiationService.getJob(uuid);
    }

    @RequestMapping(value = "/error", method = RequestMethod.GET)
    public void throwError() {
        throw new GenericUncheckedException("dummy error");
    }

    @ExceptionHandler({IllegalArgumentException.class})
    @ResponseStatus(value=BAD_REQUEST)
    private ExceptionResponse exceptionHandlerBadRequest(Exception e) {
        return ControllersUtils.handleException(e, LOGGER);
    }

    @ExceptionHandler(WebApplicationException.class)
    private ResponseEntity webApplicationExceptionHandler(WebApplicationException e) {
        return ControllersUtils.handleWebApplicationException(e, LOGGER);
    }

}
