/*-
 * ============LICENSE_START=======================================================
 * OSAM
 * ================================================================================
 * Copyright (C) 2018 AT&T
 * ================================================================================
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * ============LICENSE_END=========================================================
 */



package org.onap.osam.mso.rest;

import org.onap.osam.mso.RestObject;

import javax.ws.rs.core.MultivaluedHashMap;

public interface RestInterface {

    MultivaluedHashMap<String, Object> initMsoClient();

    /**
     * Gets the.
     *
     * @param <T> the generic type
     * @param t the t
     * @param sourceId the source id
     * @param path the path
     * @param restObject the rest object
     * @throws Exception the exception
     */
    <T> void Get (T t, String sourceId, String path, RestObject<T> restObject );

    /**
     * Delete.
     *
     * @param <T> the generic type
     * @param t the t
     * @param r the r
     * @param sourceID the source ID
     * @param path the path
     * @param restObject the rest object
     * @throws Exception the exception
     */
    <T> void Delete(T t, Object r, String sourceID, String path, RestObject<T> restObject);

    /**
     * Post.
     *
     * @param <T> the generic type
     * @param t the t
     * @param r the r
     * @param sourceID the source ID
     * @param path the path
     * @param restObject the rest object
     * @throws Exception the exception
     */
    <T> void Post(T t, Object r, String sourceID, String path, RestObject<T> restObject);

    /**
     * Put.
     *
     * @param <T> the generic type
     * @param t the t
     * @param r the r
     * @param sourceID the source ID
     * @param path the path
     * @param restObject the rest object
     * @throws Exception the exception
     */
    <T> void Put(T t, RequestDetailsWrapper r, String sourceID, String path, RestObject<T> restObject);

}
