/*-
 * ============LICENSE_START=======================================================
 * OSAM
 * ================================================================================
 * Copyright (C) 2018 AT&T
 * ================================================================================
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * ============LICENSE_END=========================================================
 */



package org.onap.osam.job;

import org.onap.osam.model.JobBulk;
import org.onap.osam.model.JobModel;

import java.util.List;
import java.util.Map;
import java.util.UUID;

public interface JobAdapter {
    JobModel toModel(Job job);

    JobBulk toModelBulk(List<Job> jobList);

    List<Job> createBulkOfJobs(Map<String, Object> bulkRequest);

    Job createJob(JobType jobType, AsyncJobRequest request, UUID templateId, String userId, Integer indexInBulk);

    // Marks types that are an AsyncJob payload
    public interface AsyncJobRequest {
    }

}
