/*-
 * ============LICENSE_START=======================================================
 * OSAM
 * ================================================================================
 * Copyright (C) 2018 AT&T
 * ================================================================================
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * ============LICENSE_END=========================================================
 */



package org.onap.osam.aai.model;


import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;

@JsonIgnoreProperties(ignoreUnknown = true)
public class Properties {

    private final String interfaceName;
    private final String interfaceId;
    private final Boolean isPortMirrored;

    public Properties(
            @JsonProperty("interface-name") String interfaceName,
            @JsonProperty("interface-id") String interfaceId,
            @JsonProperty("is-port-mirrored") Boolean isPortMirrored) {
        this.interfaceName = interfaceName;
        this.interfaceId = interfaceId;
        this.isPortMirrored = isPortMirrored;
    }

    public String getInterfaceName() {
        return interfaceName;
    }

    public String getInterfaceId() {
        return interfaceId;
    }

    public Boolean getIsPortMirrored() {
        return isPortMirrored;
    }
}
