/*-
 * ============LICENSE_START=======================================================
 * OSAM
 * ================================================================================
 * Copyright (C) 2018 AT&T
 * ================================================================================
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * ============LICENSE_END=========================================================
 */



package org.onap.osam.aai.model;


import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;

@JsonIgnoreProperties(ignoreUnknown = true)
public class Model {

        @JsonProperty("model-invariant-id")
        private String modelInvariantId;
        @JsonProperty("model-type")
        private String modelType;
        @JsonProperty("resource-version")
        private String resourceVersion;
        @JsonProperty("model-vers")
        private ModelVers modelVers;

        @JsonProperty("model-invariant-id")
        public String getModelInvariantId() {
            return modelInvariantId;
        }

        @JsonProperty("model-invariant-id")
        public void setModelInvariantId(String modelInvariantId) {
            this.modelInvariantId = modelInvariantId;
        }

        @JsonProperty("model-type")
        public String getModelType() {
            return modelType;
        }

        @JsonProperty("model-type")
        public void setModelType(String modelType) {
            this.modelType = modelType;
        }

        @JsonProperty("resource-version")
        public String getResourceVersion() {
            return resourceVersion;
        }

        @JsonProperty("resource-version")
        public void setResourceVersion(String resourceVersion) {
            this.resourceVersion = resourceVersion;
        }

        @JsonProperty("model-vers")
        public ModelVers getModelVers() {
            return modelVers;
        }

        @JsonProperty("model-vers")
        public void setModelVers(ModelVers modelVers) {
            this.modelVers = modelVers;
        }

}
