/*-
 * ============LICENSE_START=======================================================
 * OSAM
 * ================================================================================
 * Copyright (C) 2018 AT&T
 * ================================================================================
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * ============LICENSE_END=========================================================
 */



package org.onap.osam.aai.model.AaiGetTenatns;


import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;

@JsonIgnoreProperties(ignoreUnknown = true)
public class GetTenantsResponse {

    @JsonProperty("cloudRegionID")
    public String cloudRegionId;

    @JsonProperty("cloudOwner")
    public String cloudOwner;
    
    @JsonProperty("tenantName")
    public String tenantName;

    @JsonProperty("tenantID")
    public String tenantID;

    @JsonProperty("is-permitted")
    public boolean isPermitted;

    public GetTenantsResponse() {
    }

    public GetTenantsResponse(String cloudRegionId, String cloudOwner, String tenantName, String tenantID, boolean isPermitted) {
        this.cloudRegionId = cloudRegionId;
        this.cloudOwner = cloudOwner;
        this.tenantName = tenantName;
        this.tenantID = tenantID;
        this.isPermitted = isPermitted;
    }
}
