/*-
 * ============LICENSE_START=======================================================
 * OSAM Core
 * ================================================================================
 * Copyright (C) 2018 Netsia
 * ================================================================================
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * ============LICENSE_END=========================================================
 */

package org.onap.osam.external.grpc;

import lombok.extern.slf4j.Slf4j;
import org.onap.osam.grpc.AddOntFullMessage;
import org.onap.osam.grpc.AddOntMessage;
import org.onap.osam.grpc.PreProvisionOntMessage;
import org.onap.osam.model.dao.Chassis;
import org.onap.osam.model.dao.OLTPort;
import org.onap.osam.model.dao.OLTSlot;
import org.onap.osam.model.dao.ONTDevice;

@Slf4j
public class OntMessageFactory {

    public static PreProvisionOntMessage getPreProvisionOntMessage (ONTDevice ontDevice) {

        OLTPort oltPort = ontDevice.getOLTPort();
            OLTSlot oltSlot = oltPort.getOltSlot();
            Chassis chassis = oltSlot.getChassis();
            String clli = chassis.getClli();
            String serialNumber = ontDevice.getSerialNumber();
            int slotNumber = oltSlot.getNumber();
            int portNumber = oltPort.getPortNumber();
            int ontNumber = ontDevice.getNumber();
            int stag = ontDevice.getSTag();
            int ctag = ontDevice.getCTag();
            String nasPortID = ontDevice.getNasPortId();
            String circuitId = ontDevice.getCircuitId();
            log.info("getPreProvisionOntMessage, clli: {}, serialNumber: {}, slotNumber: {}, portNumber:{}, ontNumber:{}, sTag:{}, cTag:{}, nasPortId:{}, circuitId:{}", clli, serialNumber, slotNumber, portNumber, ontNumber, stag, ctag,nasPortID, circuitId);

            PreProvisionOntMessage preProvisionOntMessage = PreProvisionOntMessage.newBuilder()
                    .setCLLI(clli)
                    .setSlotNumber(slotNumber)
                    .setPortNumber(portNumber)
                    .setOntNumber(ontNumber)
                    .setSTag(stag)
                    .setCTag(ctag)
                    .setNasPortID(nasPortID)
                    .setCircuitID(circuitId)
                    .build();
            //TODO Handle technology and speed profiles later
            log.info("PreProvisionOntMessage is {}", preProvisionOntMessage);
            return  preProvisionOntMessage;

    }


    public static AddOntFullMessage getOntFullMessage (ONTDevice ontDevice) {

        OLTPort oltPort = ontDevice.getOLTPort();
        OLTSlot oltSlot = oltPort.getOltSlot();
        Chassis chassis = oltSlot.getChassis();
        String clli = chassis.getClli();
        String serialNumber = ontDevice.getSerialNumber();
        int slotNumber = oltSlot.getNumber();
        int portNumber = oltPort.getPortNumber();
        int ontNumber = ontDevice.getNumber();
        int stag = ontDevice.getSTag();
        int ctag = ontDevice.getCTag();
        String nasPortID = ontDevice.getNasPortId();
        String circuitId = ontDevice.getCircuitId();
        log.info("getOntFullMessage, clli: {}, serialNumber: {}, slotNumber: {}, portNumber:{}, ontNumber:{}, sTag:{}, cTag:{}, nasPortId:{}, circuitId:{}", clli, serialNumber, slotNumber, portNumber, ontNumber, stag, ctag,nasPortID, circuitId);

        AddOntFullMessage addOntFullMessage = AddOntFullMessage.newBuilder()
                .setCLLI(clli)
                .setSerialNumber(serialNumber)
                .setSlotNumber(slotNumber)
                .setPortNumber(portNumber)
                .setOntNumber(ontNumber)
                .setSTag(stag)
                .setCTag(ctag)
                .setNasPortID(nasPortID)
                .setCircuitID(circuitId)
                .build();
        log.info("AddOntFullMessage is {}", addOntFullMessage);
        return  addOntFullMessage;

    }

    public static AddOntMessage getOntMessage (ONTDevice ontDevice) {

        OLTPort oltPort = ontDevice.getOLTPort();
        OLTSlot oltSlot = oltPort.getOltSlot();
        Chassis chassis = oltSlot.getChassis();
        String clli = chassis.getClli();
        String serialNumber = ontDevice.getSerialNumber();
        int slotNumber = oltSlot.getNumber();
        int portNumber = oltPort.getPortNumber();
        int ontNumber = ontDevice.getNumber();
        log.info("getOntFullMessage, clli: {}, serialNumber: {}, slotNumber: {}, portNumber:{}, ontNumber:{}", clli, serialNumber, slotNumber, portNumber, ontNumber);

        AddOntMessage addOntMessage = AddOntMessage.newBuilder()
                .setCLLI(clli)
                .setSerialNumber(serialNumber)
                .setSlotNumber(slotNumber)
                .setPortNumber(portNumber)
                .setOntNumber(ontNumber)
                .build();
        log.info("AddOntMessage is {}", addOntMessage);
        return  addOntMessage;

    }
}
