/*-
 * ============LICENSE_START=======================================================
 * OSAM
 * ================================================================================
 * Copyright (C) 2018 AT&T
 * ================================================================================
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * ============LICENSE_END=========================================================
 */



package org.onap.osam.properties;

import org.apache.commons.lang3.StringUtils;
import org.springframework.context.ApplicationListener;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;
import org.togglz.core.manager.FeatureManager;
import org.togglz.core.manager.FeatureManagerBuilder;
import org.togglz.core.repository.file.FileBasedStateRepository;
import org.togglz.spring.listener.TogglzApplicationContextBinderApplicationListener;

import javax.servlet.ServletContext;
import java.io.File;

@Configuration
public class FeaturesTogglingConfiguration {
    @Bean
    public ApplicationListener getApplicationListener() {
        return new TogglzApplicationContextBinderApplicationListener();
    }

    @Bean
    public FeatureManager featureManager(ServletContext servletContext, Environment environment) {
        final String defaultFilename = "features.properties";

        String filename = environment.getProperty("featureFlags.filename");

        if (StringUtils.isBlank(filename)) {
            filename = defaultFilename;
        }

        return new FeatureManagerBuilder()
                .featureEnum(Features.class)
                .stateRepository(new FileBasedStateRepository(
                        new File(servletContext.getRealPath("/WEB-INF/conf/" + filename))
                ))
                .build();
    }
}
