/*-
 * ============LICENSE_START=======================================================
 * OSAM
 * ================================================================================
 * Copyright (C) 2018 AT&T
 * ================================================================================
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * ============LICENSE_END=========================================================
 */



package org.onap.osam.model;

public class MsoExceptionResponse {

    public static class ServiceException {

        public ServiceException(String messageId, String text) {
            this.messageId = messageId;
            this.text = text;
        }

        public ServiceException() {
        }

        public String messageId;
        public String text;
    }

    public ServiceException serviceException;

    public MsoExceptionResponse() {
    }

    public MsoExceptionResponse(String messageId, String text) {
        this.serviceException = new ServiceException(messageId, text);
    }

    public MsoExceptionResponse(Exception exception) {
        ExceptionResponse exceptionResponse = new ExceptionResponse(exception);
        this.serviceException = new ServiceException(exceptionResponse.getException(), exceptionResponse.getMessage());
    }
}
