/*-
 * ============LICENSE_START=======================================================
 * OSAM
 * ================================================================================
 * Copyright (C) 2018 AT&T
 * ================================================================================
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * ============LICENSE_END=========================================================
 */



package org.onap.osam.aai.model;

import com.fasterxml.jackson.annotation.JsonCreator;

import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum ResourceType {

    SERVICE_INSTANCE("service-instance", "service-instance-name"),
    GENERIC_VNF("generic-vnf", "vnf-name"),
    VF_MODULE("vf-module", "vf-module-name"),
    VOLUME_GROUP("volume-group", "volume-group-name");

    private static Map<String, ResourceType> AAI_FORMAT_MAP = Stream
            .of(ResourceType.values())
            .collect(Collectors.toMap(s -> s.aaiFormat, Function.identity()));

    private final String aaiFormat;
    private final String nameFilter;

    ResourceType(String formatted, String nameFilter) {
        this.aaiFormat = formatted;
        this.nameFilter = nameFilter;
    }

    public String getAaiFormat() {
        return aaiFormat;
    }

    public String getNameFilter() {
        return nameFilter;
    }

    @JsonCreator
    public static ResourceType fromString(String string) {
        return Optional
                .ofNullable(AAI_FORMAT_MAP.get(string))
                .orElseThrow(() -> new IllegalArgumentException(string));
    }
}
