/*-
 * ============LICENSE_START=======================================================
 * OSAM
 * ================================================================================
 * Copyright (C) 2018 AT&T
 * ================================================================================
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * ============LICENSE_END=========================================================
 */


package org.onap.osam.controllers;

import com.fasterxml.jackson.databind.ObjectMapper;
import org.onap.portalsdk.core.util.SystemProperties;

import org.onap.osam.client.SyncRestClient;
import org.onap.osam.factories.MsoRequestFactory;
import org.onap.osam.mso.MsoBusinessLogic;
import org.onap.osam.mso.MsoBusinessLogicImpl;
import org.onap.osam.mso.MsoInterface;
import org.onap.osam.mso.MsoProperties;
import org.onap.osam.mso.rest.MsoRestClientNew;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.togglz.core.manager.FeatureManager;


@Configuration
public class MsoConfig {

    @Bean
    public ObjectMapper getObjectMapper() {
        return new ObjectMapper();
    }

    @Bean
    public MsoRequestFactory createRequestDetailsFactory(){
        return new MsoRequestFactory();
    }

    @Bean
    public MsoInterface getMsoClient(){
        return new MsoRestClientNew(new SyncRestClient(MsoInterface.objectMapper()), SystemProperties.getProperty(
            MsoProperties.MSO_SERVER_URL));
    }

    @Bean
    public MsoBusinessLogic getMsoBusinessLogic(MsoInterface msoClient, FeatureManager featureManager){
        return new MsoBusinessLogicImpl(msoClient, featureManager);
    }


}
