/*-
 * ============LICENSE_START=======================================================
 * OSAM
 * ================================================================================
 * Copyright (C) 2018 AT&T
 * ================================================================================
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * ============LICENSE_END=========================================================
 */



package org.onap.osam.utils;

import java.util.List;
import java.util.stream.Collectors;

public class Intersection<T> {
    public List<T> intersectMultipileArray(List<List<T>> lists) {
        if (lists.size() == 1) {
            return lists.get(0);
        } else {
            List<T> intersectResult = intersectTwoArrays(lists.get(0),lists.get(1));

            lists.remove(0);
            lists.remove(0);
            lists.add(0,intersectResult);
            return intersectMultipileArray(lists);
        }

    }

    public List<T> intersectTwoArrays(List<T> list1, List<T> list2) {

        List<T> intersect = list1.stream()
                .filter(list2::contains)
                .collect(Collectors.toList());
        return intersect;
    }
}
