/*-
 * ============LICENSE_START=======================================================
 * OSAM
 * ================================================================================
 * Copyright (C) 2018 AT&T
 * ================================================================================
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * ============LICENSE_END=========================================================
 */



package org.onap.osam.policy;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import org.apache.commons.lang.builder.ToStringBuilder;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
	    "status",
	    "entity"
})

public class PolicyResponseWrapper {
	
	@JsonProperty("status")
	private int status;

	@JsonProperty("entity")
	private String entity;

	@JsonProperty("entity")
    public String getEntity() {
        return entity;
    }
	
	@JsonProperty("status")
    public int getStatus() {
        return status;
    }	
	
	@JsonProperty("status")
    public void setStatus(int v) {
        this.status = v;
    }

	@JsonProperty("entity")
    public void setEntity(String v) {
        this.entity = v;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }

    public String getResponse () {
    	
    	StringBuilder b = new StringBuilder ("{ \"status\": ");
        b.append(getStatus()).append(", \"entity\": " ).append(this.getEntity()).append("}");
        return (b.toString());
    }
}
