/*-
 * ============LICENSE_START=======================================================
 * OSAM
 * ================================================================================
 * Copyright (C) 2018 AT&T
 * ================================================================================
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * ============LICENSE_END=========================================================
 */



package org.onap.osam.mso;

import org.onap.osam.mso.rest.Request;
import org.onap.osam.mso.rest.RequestDetails;
import org.onap.osam.mso.rest.RequestDetailsWrapper;
import org.onap.osam.mso.rest.Task;

import java.util.List;

public interface MsoBusinessLogic {

    // this function should get params from tosca and send them to instance at mso, then return success response.
    MsoResponseWrapper createSvcInstance(RequestDetails msoRequest);

    MsoResponseWrapper createE2eSvcInstance(Object msoRequest);
    
    MsoResponseWrapper deleteE2eSvcInstance(Object requestDetails, String serviceInstanceId);
    
    MsoResponseWrapper createVnf(RequestDetails requestDetails, String serviceInstanceId);

    MsoResponseWrapper createNwInstance(RequestDetails requestDetails, String serviceInstanceId);

    MsoResponseWrapper createVolumeGroupInstance(RequestDetails requestDetails, String serviceInstanceId, String vnfInstanceId);

    MsoResponseWrapper createVfModuleInstance(RequestDetails requestDetails, String serviceInstanceId, String vnfInstanceId);

    MsoResponseWrapper scaleOutVfModuleInstance(RequestDetails requestDetails, String serviceInstanceId, String vnfInstanceId);

    MsoResponseWrapper createConfigurationInstance(org.onap.osam.mso.rest.RequestDetailsWrapper requestDetailsWrapper, String serviceInstanceId);

    MsoResponseWrapper deleteSvcInstance(RequestDetails requestDetails, String serviceInstanceId, String serviceStatus);

    MsoResponseWrapper deleteVnf(RequestDetails requestDetails, String serviceInstanceId, String vnfInstanceId);

    MsoResponseWrapper deleteVfModule(RequestDetails requestDetails, String serviceInstanceId, String vnfInstanceId, String vfModuleId);

    MsoResponseWrapper deleteVolumeGroupInstance(RequestDetails requestDetails, String serviceInstanceId, String vnfInstanceId, String volumeGroupId);

    MsoResponseWrapper deleteNwInstance(RequestDetails requestDetails, String serviceInstanceId, String networkInstanceId);

    MsoResponseWrapper getOrchestrationRequest(String requestId);

    MsoResponseWrapper getOrchestrationRequests(String filterString);

    List<Request> getOrchestrationRequestsForDashboard();

    List<Task> getManualTasksByRequestId(String originalRequestId);

    MsoResponseWrapper completeManualTask(RequestDetails requestDetails, String taskId);

    MsoResponseWrapper activateServiceInstance(RequestDetails requestDetails, String serviceInstanceId);

    //MsoResponseWrapperInterface updateVnf(RequestDetails requestDetails, String serviceInstanceId, String vnfInstanceId);

    //MsoResponseWrapperInterface replaceVnf(RequestDetails requestDetails, String serviceInstanceId, String vnfInstanceId);

    MsoResponseWrapperInterface updateVnfSoftware(RequestDetails requestDetails, String serviceInstanceId, String vnfInstanceId);

    MsoResponseWrapperInterface updateVnfConfig(RequestDetails requestDetails, String serviceInstanceId, String vnfInstanceId);

    MsoResponseWrapper deleteConfiguration(
            org.onap.osam.mso.rest.RequestDetailsWrapper requestDetailsWrapper,
            String serviceInstanceId,
            String configurationId);

    MsoResponseWrapper setConfigurationActiveStatus(
            RequestDetails requestDetails,
            String serviceInstanceId,
            String configurationId,
            boolean isActivate);

    MsoResponseWrapper setPortOnConfigurationStatus(
            RequestDetails requestDetails,
            String serviceInstanceId,
            String configurationId,
            boolean isEnable);

    String getCloudResourcesRequestsStatusPath(String requestId);

    MsoResponseWrapper removeRelationshipFromServiceInstance(RequestDetails requestDetails, String serviceInstanceId);

    MsoResponseWrapper addRelationshipToServiceInstance(RequestDetails requestDetails, String serviceInstanceId);

    MsoResponseWrapper setServiceInstanceStatus(RequestDetails requestDetails , String serviceInstanceId, boolean isActivate);

    RequestDetailsWrapper generateInPlaceMsoRequest(RequestDetails requestDetails);

    RequestDetailsWrapper generateConfigMsoRequest(RequestDetails requestDetails);
}
