/*-
 * ============LICENSE_START=======================================================
 * OSAM
 * ================================================================================
 * Copyright (C) 2018 AT&T
 * ================================================================================
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * ============LICENSE_END=========================================================
 */



package org.onap.osam.job;

import org.onap.osam.job.command.*;

import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum JobType {

    HttpCall(HttpCallCommand.class),
    AggregateState(AggregateStateCommand.class),
    InProgressStatus(InProgressStatusCommand.class),
    NoOp(NoOpCommand.class),
    ServiceInstantiation(ServiceInstantiationCommand.class);

    private static final Map<Class, JobType> REVERSE_MAP = Stream.of(values()).collect(Collectors.toMap(t -> t.getCommandClass(), t -> t));

    private final Class commandClass;

    <T extends JobCommand> JobType(Class<T> commandClass) {
        this.commandClass = commandClass;
    }

    public Class getCommandClass() {
        return commandClass;
    }
    static JobType jobTypeOf(Class commandClass) {
        return REVERSE_MAP.get(commandClass);
    }
}
