/*-
 * ============LICENSE_START=======================================================
 * OSAM Core
 * ================================================================================
 * Copyright (C) 2018 Netsia
 * ================================================================================
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * ============LICENSE_END=========================================================
 */



package org.onap.osam.external.aai.model;

import com.google.gson.annotations.SerializedName;
import lombok.Getter;
import lombok.Setter;

/**
 * Created by cemturker on 26.09.2018.
 */
@Setter
@Getter
public class PNF {
    @SerializedName("pnf-id")
    private String pnfId;
    @SerializedName("pnf-name")
    private String pnfName;
    @SerializedName("ipaddress-v4-oam")
    private String ipaddressV4Oam;

    @Override
    public String toString() {
        final StringBuilder sb = new StringBuilder("PNF{");
        sb.append("pnfName='").append(pnfName).append('\'');
        sb.append(", pnfId='").append(pnfId).append('\'');
        sb.append(", ipaddressV4Oam='").append(ipaddressV4Oam).append('\'');
        sb.append('}');
        return sb.toString();
    }
}
