/*-
 * ============LICENSE_START=======================================================
 * OSAM
 * ================================================================================
 * Copyright (C) 2018 AT&T
 * ================================================================================
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * ============LICENSE_END=========================================================
 */



package org.onap.osam.services;

import org.onap.osam.aai.model.ResourceType;
import org.onap.osam.job.Job;
import org.onap.osam.model.JobAuditStatus;
import org.onap.osam.model.ServiceInfo;
import org.onap.osam.model.serviceInstantiation.ServiceInstantiation;
import org.onap.osam.mso.rest.AsyncRequestStatus;

import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import java.util.function.Consumer;

public interface IAsyncInstantiationBusinessLogic {

    List<String> PARAMS_TO_IGNORE = Arrays.asList("vnf_name", "vf_module_name");

    List<ServiceInfo> getAllServicesInfo();

    List<UUID> pushBulkJob(ServiceInstantiation request, String userId);

    String getServiceInstantiationPath(ServiceInstantiation serviceInstantiationRequest);

    String getOrchestrationRequestsPath();

    ServiceInfo getServiceInfoByJobId(UUID jobUUID);

    List<JobAuditStatus> getAuditStatuses(UUID jobUUID, JobAuditStatus.SourceStatus source);

    ServiceInfo updateServiceInfo(UUID jobUUID, Consumer<ServiceInfo> serviceUpdater);

    ServiceInfo updateServiceInfoAndAuditStatus(UUID jobUuid, Job.JobStatus jobStatus);

    void auditVidStatus(UUID jobUUID, Job.JobStatus jobStatus);

    void auditMsoStatus(UUID jobUUID, AsyncRequestStatus.Request msoRequestStatus);

    void auditMsoStatus(UUID jobUUID, String jobStatus, String requestId, String additionalInfo);

    Job.JobStatus calcStatus(AsyncRequestStatus asyncRequestStatus);

    void handleFailedInstantiation(UUID jobUUID);

    void deleteJob(UUID jobId);

    void hideServiceInfo(UUID jobUUID);

    int getCounterForName(String name);

    int getMaxRetriesGettingFreeNameFromAai();

    void setMaxRetriesGettingFreeNameFromAai(int maxRetriesGettingFreeNameFromAai);

    String getUniqueName(String name, ResourceType resourceType);
}
