/*-
 * ============LICENSE_START=======================================================
 * OSAM
 * ================================================================================
 * Copyright (C) 2018 AT&T
 * ================================================================================
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * ============LICENSE_END=========================================================
 */



package org.onap.osam.mso.rest;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.onap.osam.domain.mso.UserParam;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "subscriptionServiceType",
    "userParams"
})
public class RequestParameters {

    @JsonProperty("subscriptionServiceType")
    private String subscriptionServiceType;
    @JsonProperty("userParams")
    private List<UserParam> userParams = new ArrayList<UserParam>();
    @JsonIgnore
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();

    @JsonProperty("subscriptionServiceType")
    public String getSubscriptionServiceType() {
        return subscriptionServiceType;
    }

    @JsonProperty("subscriptionServiceType")
    public void setSubscriptionServiceType(String subscriptionServiceType) {
        this.subscriptionServiceType = subscriptionServiceType;
    }

    /**
     * 
     * @return
     *     The userParams
     */
    @JsonProperty("userParams")
    public List<UserParam> getUserParams() {
        return userParams;
    }

    /**
     * 
     * @param userParams
     *     The userParams
     */
    @JsonProperty("userParams")
    public void setUserParams(List<UserParam> userParams) {
        this.userParams = userParams;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder().append(subscriptionServiceType).append(userParams).append(additionalProperties).toHashCode();
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof RequestParameters) == false) {
            return false;
        }
        RequestParameters rhs = ((RequestParameters) other);
        return new EqualsBuilder().append(subscriptionServiceType, rhs.subscriptionServiceType).append(userParams, rhs.userParams).append(additionalProperties, rhs.additionalProperties).isEquals();
    }

}
