/*-
 * ============LICENSE_START=======================================================
 * OSAM Core
 * ================================================================================
 * Copyright (C) 2018 Netsia
 * ================================================================================
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * ============LICENSE_END=========================================================
 */



package org.onap.osam.model.dao;

import lombok.Getter;
import lombok.Setter;

import javax.persistence.*;
import java.util.Set;

/**
 * Created by cemturker on 18.09.2018.
 */
@Entity
@Setter
@Getter
public class Subscriber extends BaseEntity {

    @Column(unique = true)
    private String userIdentifier;
    private Integer cTag;
    private Integer sTag;
    @ManyToMany
    @JoinTable(name = "subscriber_service", joinColumns = @JoinColumn(name = "subscriber_id"),
    inverseJoinColumns = @JoinColumn(name = "service_id"))
    private Set<Service> services;

    //TODO Configurations such as NAS and DHCP!
    @Override
    public String toString() {
        final StringBuilder sb = new StringBuilder("Subscriber{");
        sb.append("userIdentifier='").append(userIdentifier).append('\'');
        sb.append(", cTag=").append(cTag);
        sb.append(", sTag=").append(sTag);
        sb.append(", services=").append(services);
        sb.append('}');
        return sb.toString();
    }
}
