/*-
 * ============LICENSE_START=======================================================
 * OSAM Core
 * ================================================================================
 * Copyright (C) 2018 Netsia
 * ================================================================================
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * ============LICENSE_END=========================================================
 */



package org.onap.osam.model.dao;

import lombok.Getter;
import lombok.Setter;

import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;

/**
 * Created by cemturker on 18.09.2018.
 */
@Entity
@Getter
@Setter
public class SpeedProfile extends BaseEntity {

    @Enumerated(value = EnumType.STRING)
    private StreamDirection streamDirection;
    private String name;
    private String data;

    @Override
    public String toString() {
        final StringBuilder sb = new StringBuilder("SpeedProfile{");
        sb.append("streamDirection=").append(streamDirection);
        sb.append(", name='").append(name).append('\'');
        sb.append(", data='").append(data).append('\'');
        sb.append(", id=").append(id);
        sb.append('}');
        return sb.toString();
    }
}
