/*-
 * ============LICENSE_START=======================================================
 * OSAM Core
 * ================================================================================
 * Copyright (C) 2018 Netsia
 * ================================================================================
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * ============LICENSE_END=========================================================
 */



package org.onap.osam.model.dao;

import lombok.Getter;
import lombok.Setter;

import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ManyToMany;
import javax.persistence.OneToOne;
import java.util.Set;

/**
 * Created by cemturker on 18.09.2018.
 */
@Entity
@Getter
@Setter
public class Service extends BaseEntity {

    private String name;
    @OneToOne(fetch = FetchType.EAGER)
    private TechnologyProfile technologyProfile;
    @OneToOne(fetch = FetchType.EAGER)
    private SpeedProfile upStreamProfile;
    @OneToOne(fetch = FetchType.EAGER)
    private SpeedProfile downStreamProfile;

    @ManyToMany(mappedBy = "services")
    private Set<Subscriber> subscribers;

    @Override
    public String toString() {
        final StringBuilder sb = new StringBuilder("Service{");
        sb.append("name='").append(name).append('\'');
        sb.append(", technologyProfile=").append(technologyProfile);
        sb.append(", id=").append(id);
        sb.append(", upStreamProfile=").append(upStreamProfile);
        sb.append(", downStreamProfile=").append(downStreamProfile);
        sb.append(", subscribers=").append(subscribers);
        sb.append('}');
        return sb.toString();
    }
}
