/*-
 * ============LICENSE_START=======================================================
 * OSAM Core
 * ================================================================================
 * Copyright (C) 2018 Netsia
 * ================================================================================
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * ============LICENSE_END=========================================================
 */



package org.onap.osam.model.dao;

import lombok.Getter;
import lombok.Setter;

import javax.persistence.*;

/**
 * Created by Zafer Kaban on 18.09.2018.
 */
@Entity
@Getter
@Setter
public class ONTDevice extends BaseEntity {

    private String serialNumber;
    @Enumerated(value = EnumType.STRING)
    private ActivityState portAuthState;
    @Enumerated(value = EnumType.STRING)
    private AdminState adminState;
    @Enumerated(value = EnumType.STRING)
    private ActivityState operationalState;
    private String ipAddress;
    private String macAddress;
    private int number;
    private int sTag;
    private int cTag;
    private String nasPortId;
    private String circuitId;
    private TechnologyProfile techProfile;
    private SpeedProfile speedProfile;
    @ManyToOne
    @JoinColumn(name="OLTPort_id", nullable=false)
    private OLTPort OLTPort;

    @Override
    public String toString() {
        final StringBuilder sb = new StringBuilder("oltSlot{");
        sb.append("id=").append(id);
        sb.append(", serialNumber='").append(serialNumber).append('\'');
        sb.append(", portAuthState='").append(portAuthState).append('\'');
        sb.append(", adminState='").append(adminState).append('\'');
        sb.append(", operationalState='").append(operationalState).append('\'');
        sb.append(", macAddress='").append(macAddress).append('\'');
        sb.append(", number='").append(number).append('\'');
        sb.append(", ipAddress=").append(ipAddress);
        sb.append(", sTag=").append(ipAddress);
        sb.append(", cTag=").append(cTag);
        sb.append(", nasPortId=").append(nasPortId);
        sb.append(", circuitId=").append(circuitId);
        sb.append(", techProfile=").append(techProfile);
        sb.append(", speedProfile=").append(speedProfile);
        sb.append('}');
        return sb.toString();
    }
}