/*-
 * ============LICENSE_START=======================================================
 * OSAM Core
 * ================================================================================
 * Copyright (C) 2018 Netsia
 * ================================================================================
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * ============LICENSE_END=========================================================
 */



package org.onap.osam.model.dao;

import lombok.Getter;
import lombok.Setter;

import javax.persistence.*;
import java.util.Set;

/**
 * Created by Zafer Kaban on 18.09.2018.
 */
@Entity
@Getter
@Setter
public class Chassis extends BaseEntity {

    @Column(unique = true)
    private String clli;
    private int rack;
    private int shelf;
    @Enumerated(value = EnumType.STRING)
    private ActivityState state;
    @OneToMany(fetch = FetchType.EAGER, cascade = CascadeType.ALL, mappedBy = "chassis")
    private Set<OLTSlot> oltSlots;
    @ManyToOne
    @JoinColumn(name="accessPod_pnfId", nullable=false)
    private AccessPod accessPod;

    @Override
    public String toString() {
        final StringBuilder sb = new StringBuilder("Chassis{");
        sb.append("clli=").append(clli);
        sb.append(", state='").append(state).append('\'');
        sb.append(", rack='").append(rack).append('\'');
        sb.append(", shelf='").append(shelf).append('\'');
        sb.append('}');
        return sb.toString();
    }
}
