/*-
 * ============LICENSE_START=======================================================
 * OSAM Core
 * ================================================================================
 * Copyright (C) 2018 Netsia
 * ================================================================================
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * ============LICENSE_END=========================================================
 */



package org.onap.osam.external.aai.config;

import lombok.Getter;
import lombok.Setter;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.PropertySource;

/**
 * Created by cemturker on 12.04.2018.
 */
@Configuration
@PropertySource("classpath:aai.properties")
@Slf4j
@Getter
@Setter
public class AaiConfig {
    private static final String AAI_HOST = "${aai.host}";
    private static final String AAI_PORT = "${aai.port}";

    private static final String AAI_PROTOCOL = "${aai.protocol}";

    private static final String AAI_USERNAME = "${aai.username}";
    private static final String AAI_PASSWORD = "${aai.password}";
    private static final String AAI_BASE_PATH = "${aai.base.path}";
    private static final String AAI_PNF_PATH = "${aai.pnf.path}";

    @Value(AAI_HOST)
    private String host;
    @Value(AAI_PORT)
    private int port;
    @Value(AAI_PROTOCOL)
    private String protocol;
    @Value(AAI_USERNAME)
    private String username;
    @Value(AAI_PASSWORD)
    private String password;
    @Value(AAI_BASE_PATH)
    private String basePath;
    @Value(AAI_PNF_PATH)
    private String pnfPath;

}
