/*-
 * ============LICENSE_START=======================================================
 * OSAM Core
 * ================================================================================
 * Copyright (C) 2018 Netsia
 * ================================================================================
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * ============LICENSE_END=========================================================
 */



package org.onap.osam.core;

import org.onap.osam.model.dao.Subscriber;
import org.onap.osam.model.repository.SubscriberRepository;
import org.onap.osam.api.service.SubscriberService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * Created by cemturker on 18.09.2018.
 */
@Service
public class SubscriberServiceImpl extends AbstractBaseServiceImpl implements SubscriberService {

    private SubscriberRepository subscriberRepository;

    @Autowired
    public SubscriberServiceImpl(SubscriberRepository subscriberRepository) {
        this.subscriberRepository = subscriberRepository;
    }

    @Override
    public Subscriber addOrUpdate(Subscriber subscriber) {
        //TODO Add Check the devices.....
        return add(subscriber, subscriberRepository);
    }

    @Override
    public void removeById(Long id) {
        remove(id, subscriberRepository, Subscriber.class);
    }

    @Override
    public Subscriber getById(Long id) {
        return get(id, subscriberRepository);
    }

    @Override
    public List<Subscriber> getAll() {
        return getAll(subscriberRepository);
    }

    @Override
    public Subscriber getBySubscriberIdentifier(String userIdentifier) {
        return subscriberRepository.findByUserIdentifier(userIdentifier);
    }
}
