/*-
 * ============LICENSE_START=======================================================
 * OSAM Core
 * ================================================================================
 * Copyright (C) 2018 Netsia
 * ================================================================================
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * ============LICENSE_END=========================================================
 */



package org.onap.osam.core;

import org.onap.osam.model.repository.PmConfigsRepository;
import org.onap.osam.model.dao.PmConfig;
import org.onap.osam.model.dao.PmConfigs;
import org.onap.osam.model.dao.PmGroupConfig;
import org.onap.osam.model.repository.PmConfigRepository;
import org.onap.osam.model.repository.PmGroupConfigRepository;
import org.onap.osam.api.service.PmConfigsService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

@Service
public class PmConfigsServiceImpl extends AbstractBaseServiceImpl implements PmConfigsService{

    protected PmConfigRepository pmConfigRepository;
    protected PmConfigsRepository pmConfigsRepository;
    protected PmGroupConfigRepository pmGroupConfigRepository;

    @Autowired
    public PmConfigsServiceImpl(PmConfigRepository pmConfigRepository,PmConfigsRepository pmConfigsRepository,
                                PmGroupConfigRepository pmGroupConfigRepository){

        this.pmConfigRepository=pmConfigRepository;
        this.pmGroupConfigRepository=pmGroupConfigRepository;
        this.pmConfigsRepository=pmConfigsRepository;
    }


    @Override
    public List<PmConfig> getPmConfigByPmConfigsId(Long pmConfigsId) {
        return pmConfigRepository.getByPmConfigs_Id(pmConfigsId);
    }

    @Override
    public List<PmConfig> getPmConfigByPmConfigGroupId(Long pmGroupConfigsId) {
        return pmConfigRepository.getByPmGroupConfig_Id(pmGroupConfigsId);
    }

    @Override
    public void addPmGroupConfig(PmConfig pmConfig) {
        add(pmConfig,pmConfigRepository);
    }

    @Override
    public void addPmGroupConfig(PmGroupConfig pmGroupConfig) {
        add(pmGroupConfig,pmGroupConfigRepository);
    }

    @Override
    public void removePmConfig(Long pmConfigId) {
        remove(pmConfigId,pmConfigRepository,PmConfig.class);
    }

    @Override
    public void removeGroupPmConfig(Long pmGroupConfigId) {
        remove(pmGroupConfigId,pmGroupConfigRepository,PmGroupConfig.class);
    }


    @Override
    public PmConfigs addOrUpdate(PmConfigs value) {
        return add(value,pmConfigsRepository);
    }

    @Override
    public void removeById(Long key) {
        remove(key,pmConfigsRepository,PmConfigs.class);
    }

    @Override
    public PmConfigs getById(Long key) {
        return get(key,pmConfigsRepository);
    }

    @Override
    public List<PmConfigs> getAll() {
        return getAll(pmConfigsRepository);
    }
}
