/*-
 * ============LICENSE_START=======================================================
 * OSAM Core
 * ================================================================================
 * Copyright (C) 2018 Netsia
 * ================================================================================
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * ============LICENSE_END=========================================================
 */



package org.onap.osam.core;

import org.onap.osam.model.dao.SpeedProfile;
import org.onap.osam.model.dao.Service;
import org.onap.osam.model.dao.TechnologyProfile;
import org.onap.osam.model.repository.ServiceRepository;
import org.onap.osam.model.repository.SpeedProfileRepository;
import org.onap.osam.model.repository.TechnologyProfileRepository;
import org.onap.osam.api.service.BroadBandService;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.List;

/**
 * Created by cemturker on 18.09.2018.
 */
@org.springframework.stereotype.Service
public class BroadBandServiceImpl extends AbstractBaseServiceImpl implements BroadBandService {
    private SpeedProfileRepository speedProfileRepository;
    private TechnologyProfileRepository technologyProfileRepository;
    private ServiceRepository serviceRepository;

    @Autowired
    public BroadBandServiceImpl(SpeedProfileRepository speedProfileRepository,
                                TechnologyProfileRepository technologyProfileRepository,
                                ServiceRepository serviceRepository) {
        super();
        this.speedProfileRepository = speedProfileRepository;
        this.technologyProfileRepository = technologyProfileRepository;
        this.serviceRepository = serviceRepository;
    }

    @Override
    public SpeedProfile addSpeedProfile(SpeedProfile speedProfile) {
        return add(speedProfile, speedProfileRepository);
    }

    @Override
    public TechnologyProfile addTechnologyProfile(TechnologyProfile technologyProfile) {
        return add(technologyProfile,technologyProfileRepository);
    }

    @Override
    public Service addService(Service service) {
        return add(service,serviceRepository);
    }

    @Override
    public void removeSpeedProfile(Long id) {
        remove(id, speedProfileRepository, SpeedProfile.class);

    }

    @Override
    public void removeTechnologyProfile(Long id) {
        remove(id, technologyProfileRepository, TechnologyProfile.class);
    }

    @Override
    public void removeService(Long id) {
        remove(id, serviceRepository, Service.class);
    }

    @Override
    public SpeedProfile getSpeedProfile(Long id) {
        return get(id, speedProfileRepository);
    }

    @Override
    public TechnologyProfile getTechnologyProfile(Long id) {
        return get(id, technologyProfileRepository);
    }

    @Override
    public Service getService(Long id) {
        return get(id, serviceRepository);
    }

    @Override
    public List<SpeedProfile> getSpeedProfiles() {
        return getAll(speedProfileRepository);
    }

    @Override
    public List<TechnologyProfile> getTechnologyProfiles() {
        return getAll(technologyProfileRepository);
    }

    @Override
    public List<Service> getServices() {
        return getAll(serviceRepository);
    }
}
