/*-
 * ============LICENSE_START=======================================================
 * OSAM Core
 * ================================================================================
 * Copyright (C) 2018 Netsia
 * ================================================================================
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * ============LICENSE_END=========================================================
 */



package org.onap.osam.core;

import org.onap.osam.model.dao.AlarmsAndEvents;
import org.onap.osam.api.service.AlarmService;
import org.onap.osam.common.exception.UnknownTypeException;
import org.onap.osam.model.dao.ActiveAlarmsAndEvents;
import org.onap.osam.model.dao.HistoricalAlarmsAndEvents;
import org.onap.osam.model.repository.ActiveAlarmsAndEventsRepository;
import org.onap.osam.model.repository.HistoricalAlarmsAndEventsRepository;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Date;
import java.util.List;

@Service
public class AlarmServiceImpl extends AbstractBaseServiceImpl implements AlarmService {

    ActiveAlarmsAndEventsRepository activeAlarmsAndEventsRepository;
    HistoricalAlarmsAndEventsRepository historicalAlarmsAndEventsRepository;

    @Autowired
    public AlarmServiceImpl(ActiveAlarmsAndEventsRepository activeAlarmsAndEventsRepository,
                            HistoricalAlarmsAndEventsRepository historicalAlarmsAndEventsRepository){
        this.activeAlarmsAndEventsRepository = activeAlarmsAndEventsRepository;
        this.historicalAlarmsAndEventsRepository = historicalAlarmsAndEventsRepository;
    }

    @Override
    public List<ActiveAlarmsAndEvents> getActiveAlarmsAndEventsByDate(Date startDate, Date endDate) {
        return activeAlarmsAndEventsRepository.findAllActiveAlarmsAndEventsByDateLessThanEqualAndDateGreaterThanEqual
                (endDate,startDate);
    }

    @Override
    public List<HistoricalAlarmsAndEvents> getHistoricalAlarmsAndEventsByDate(Date startDate, Date endDate) {
        return historicalAlarmsAndEventsRepository.findAllHistoricalAlarmsAndEventsByDateLessThanEqualAndDateGreaterThanEqual(endDate,startDate);

    }

    @Override
    public void addOrUpdate(AlarmsAndEvents alarmsAndEvents) {
       switch (alarmsAndEvents.getAlarmStatus()){
           case ACTIVE:
               add(new ActiveAlarmsAndEvents(alarmsAndEvents),activeAlarmsAndEventsRepository);
               add(new HistoricalAlarmsAndEvents(alarmsAndEvents),historicalAlarmsAndEventsRepository);
               break;
           case DEACTIVE:
               remove(alarmsAndEvents.getId(),activeAlarmsAndEventsRepository,AlarmsAndEvents.class);
               add(new HistoricalAlarmsAndEvents(alarmsAndEvents) ,historicalAlarmsAndEventsRepository);
               break;
           default:
               throw new UnknownTypeException("alarm status is unknown" + alarmsAndEvents.getAlarmStatus());
       }
    }
}
