/*-
 * ============LICENSE_START=======================================================
 * OSAM
 * ================================================================================
 * Copyright (C) 2018 AT&T
 * ================================================================================
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * ============LICENSE_END=========================================================
 */
package org.onap.simulator.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonInclude(JsonInclude.Include.NON_NULL)
public class SimulatorRequestResponseExpectation {

    Logger logger = LoggerFactory.getLogger(SimulatorRequestResponseExpectation.class);

    private SimulatorRequest simulatorRequest;
    private SimulatorResponse simulatorResponse;
    private Misc misc;

    public SimulatorRequest getSimulatorRequest() {
        return simulatorRequest;
    }

    public void setSimulatorRequest(SimulatorRequest simulatorRequest) {
        this.simulatorRequest = simulatorRequest;
    }

    public SimulatorResponse getSimulatorResponse() {
        return simulatorResponse;
    }

    public void setSimulatorResponse(SimulatorResponse simulatorResponse) {
        this.simulatorResponse = simulatorResponse;
    }

    public Misc getMisc() {
        return misc == null ? new Misc() : misc;
    }

    public void setMisc(Misc misc) {
        this.misc = misc;
    }

    @Override
    public String toString() {
        return "ExpectationModel{" +
                "simulatorRequest=" + simulatorRequest +
                ", simulatorResponse=" + simulatorResponse +
                ", misc=" + misc +
                '}';
    }
}
