/*-
 * ============LICENSE_START=======================================================
 * OSAM
 * ================================================================================
 * Copyright (C) 2018 AT&T
 * ================================================================================
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * ============LICENSE_END=========================================================
 */



package org.onap.osam.job;

public class NextCommand {
    private final Job.JobStatus status;
    private final JobCommand command;

    public NextCommand(Job.JobStatus nextStatus, JobCommand nextCommand) {
        this.status = nextStatus;
        this.command = nextCommand;
    }

    public NextCommand(Job.JobStatus nextStatus) {
        this.status = nextStatus;
        this.command = null;
    }

    public Job.JobStatus getStatus() {
        return status;
    }

    public JobCommand getCommand() {
        return command;
    }

}
