/*-
 * ============LICENSE_START=======================================================
 * OSAM
 * ================================================================================
 * Copyright (C) 2018 AT&T
 * ================================================================================
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * ============LICENSE_END=========================================================
 */



package org.onap.osam.aai.model;

import com.fasterxml.jackson.annotation.JsonProperty;

public class ServiceRelationships {
	
	@JsonProperty("service-instance-id")
	public String serviceInstanceId;

	@JsonProperty("service-instance-name")
	public String serviceInstanceName;

	@JsonProperty("service-type")
	public String serviceType;

	@JsonProperty("service-role")
	public String serviceRole;

	@JsonProperty("environment-context")
	public String environmentContext;

	@JsonProperty("workload-context")
	public String workloadContext;

	@JsonProperty("model-invariant-id")
	public String modelInvariantId;
	
	@JsonProperty("model-version-id")
	public String modelVersionId;

	@JsonProperty("resource-version")
	public String resourceVersion;
	
	@JsonProperty("orchestration-status")
	public String orchestrationStatus;

	@JsonProperty("relationship-list")
	public RelationshipList relationshipList;


	public String getServiceInstanceId() {
		return serviceInstanceId;
	}

	public void setServiceInstanceId(String serviceInstanceId) {
		this.serviceInstanceId = serviceInstanceId;
	}

	public String getServiceInstanceName() {
		return serviceInstanceName;
	}

	public void setServiceInstanceName(String serviceInstanceName) {
		this.serviceInstanceName = serviceInstanceName;
	}

	public String getModelInvariantId() {
		return modelInvariantId;
	}

	public void setModelInvariantId(String modelInvariantId) {
		this.modelInvariantId = modelInvariantId;
	}

	public String getModelVersionId() {
		return modelVersionId;
	}

	public void setModelVersionId(String modelVersionId) {
		this.modelVersionId = modelVersionId;
	}

	public String getResourceVersion() {
		return resourceVersion;
	}

	public void setResourceVersion(String resourceVersion) {
		this.resourceVersion = resourceVersion;
	}

	public String getOrchestrationStatus() {
		return orchestrationStatus;
	}

	public void setOrchestrationStatus(String orchestrationStatus) {
		this.orchestrationStatus = orchestrationStatus;
	}

	public RelationshipList getRelationshipList() {
		return relationshipList;
	}

	public void setRelationshipList(RelationshipList relationshipList) {
		this.relationshipList = relationshipList;
	}



	
	

}
